/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import jnpad.action.ActionManager;
import jnpad.config.Config;
import jnpad.config.Controlable;
import jnpad.text.EditPane;
import jnpad.text.TextBundle;
import jnpad.ui.icon.ArrowIcon;
import jnpad.ui.plaf.LAFUtils;

public class GutterBase
extends JPanel
implements Controlable {
    JButton btPreviousBookmark = new JButton();
    JButton btNextBookmark = new JButton();
    EditPane editPane;
    private static final long serialVersionUID = 9112739617599765904L;

    public GutterBase(EditPane editPane) {
        super(new GridLayout(0, 2));
        this.editPane = editPane;
        this.btPreviousBookmark.setToolTipText(TextBundle.getString("GutterBase.previousBookmark", new Object[0]));
        this.btPreviousBookmark.setIcon(new ArrowIcon(1));
        this.btPreviousBookmark.setMargin(LAFUtils.isNimbusLAF() ? new Insets(0, -7, 0, -7) : new Insets(0, 0, 0, 0));
        this.btPreviousBookmark.setRequestFocusEnabled(false);
        this.btPreviousBookmark.setEnabled(false);
        this.btPreviousBookmark.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GutterBase.this.editPane.previousBookmark();
            }
        });
        this.btNextBookmark.setToolTipText(TextBundle.getString("GutterBase.nextBookmark", new Object[0]));
        this.btNextBookmark.setIcon(new ArrowIcon(5));
        this.btNextBookmark.setMargin(LAFUtils.isNimbusLAF() ? new Insets(0, -7, 0, -7) : new Insets(0, 0, 0, 0));
        this.btNextBookmark.setRequestFocusEnabled(false);
        this.btNextBookmark.setEnabled(false);
        this.btNextBookmark.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GutterBase.this.editPane.nextBookmark();
            }
        });
        this.add(this.btPreviousBookmark);
        this.add(this.btNextBookmark);
        this.configure(1);
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.setBackground(Config.GUTTER_BACKGROUND.getValue());
        }
    }

    @Override
    public void updateControls() {
        this.updateControls(8191);
    }

    @Override
    public void updateControls(int ctrls) {
        if ((ctrls & 0x40) != 0) {
            boolean b = this.editPane.hasBookmarks();
            ActionManager.INSTANCE.setEnabled("next-bookmark", b);
            ActionManager.INSTANCE.setEnabled("previous-bookmark", b);
            ActionManager.INSTANCE.setEnabled("clear-all-bookmarks", b);
            this.btNextBookmark.setEnabled(b);
            this.btPreviousBookmark.setEnabled(b);
        }
    }
}

