/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import jnpad.GUIUtilities;
import jnpad.config.Config;
import jnpad.config.Configurable;
import jnpad.text.AbstractTextArea;
import jnpad.text.DocumentRange;
import jnpad.text.EditPane;
import jnpad.ui.SideBorder;

public class SimpleGutter
extends JPanel
implements Configurable {
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float RIGHT = 1.0f;
    private static final int PREFERRED_HEIGHT = 2146483647;
    boolean updateFont;
    int borderGap;
    int selectionWidth;
    Color selectionColor = Color.YELLOW;
    Color selectionBorderColor = Color.YELLOW.darker();
    boolean hasSelectionBorder = true;
    Color bookmarkBackground = Color.CYAN;
    int bookmarkWidth = 7;
    int bookmarkGap = 2;
    Color bookmarkColor = Color.RED;
    Color bookmarkBorderColor = Color.RED.darker();
    Color currentLineForeground;
    Color currentLineBackground;
    boolean currentLineBackgroundEnabled;
    float digitAlignment;
    int minimumDisplayDigits;
    boolean lineBorderVisible = true;
    Border outerBorder = new SideBorder(null, null, null, Color.LIGHT_GRAY, 1);
    int lastDigits;
    int lastHeight;
    int lastLine;
    boolean lasHasSelection;
    HashMap<String, FontMetrics> fonts;
    int selectionBegin;
    int selectionEnd;
    EditPane editPane;
    AbstractTextArea textArea;
    private static final Logger LOGGER = Logger.getLogger(SimpleGutter.class.getName());
    private static final long serialVersionUID = -5244882856595180262L;

    public SimpleGutter(AbstractTextArea textArea) {
        this(textArea, 3);
    }

    public SimpleGutter(AbstractTextArea textArea, int minimumDisplayDigits) {
        this.editPane = textArea.editPane;
        this.textArea = textArea;
        this.doConfigure(7);
        this.setDigitAlignment(1.0f);
        this.setMinimumDisplayDigits(minimumDisplayDigits);
        Handler handler = new Handler();
        textArea.getDocument().addDocumentListener(handler);
        textArea.addCaretListener(handler);
        textArea.addPropertyChangeListener("font", handler);
        textArea.addMouseListener(handler);
        textArea.addMouseMotionListener(handler);
        this.addMouseListener(handler);
    }

    @Override
    public void configure(int cfg) {
        this.doConfigure(cfg);
    }

    private void doConfigure(int cfg) {
        if ((cfg & 1) != 0) {
            this.setBackground(Config.GUTTER_BACKGROUND.getValue());
            this.setForeground(Config.GUTTER_FOREGROUND.getValue());
            this.setCurrentLineForeground(Config.GUTTER_CURRENT_FOREGROUND.getValue());
            this.setCurrentLineBackground(Config.GUTTER_CURRENT_BACKGROUND.getValue());
            this.setCurrentLineBackgroundEnabled(Config.GUTTER_CURRENT_BACKGROUND_ENABLED.getValue());
            this.setLineBorderVisible(Config.GUTTER_BORDER_VISIBLE.getValue());
            this.setLineBorder(Config.GUTTER_BORDER_COLOR.getValue(), Config.GUTTER_BORDER_WIDTH.getValue());
            this.setBorderGap(Config.GUTTER_BORDER_GAP.getValue());
            this.setSelectionWidth(Config.GUTTER_SELECTION_WIDTH.getValue());
            this.setSelectionColor(Config.GUTTER_SELECTION_COLOR.getValue());
            this.setSelectionBorderColor(Config.GUTTER_SELECTION_BORDER_COLOR.getValue());
            this.setHasSelectionBorder(Config.GUTTER_SELECTION_BORDER.getValue());
            this.setBookmarkBackground(Config.GUTTER_BOOKMARK_BACKGROUND.getValue());
            this.setBookmarkColor(Config.GUTTER_BOOKMARK_COLOR.getValue());
            this.setBookmarkBorderColor(Config.GUTTER_BOOKMARK_BORDER_COLOR.getValue());
            this.setBookmarkWidth(Config.GUTTER_BOOKMARK_WIDTH.getValue());
            this.setBookmarkGap(Config.GUTTER_BOOKMARK_GAP.getValue());
        }
        if ((cfg & 2) != 0) {
            this.setFont(this.textArea.getFont());
            this.setUpdateFont(Config.GUTTER_UPDATE_FONT.getValue());
        }
    }

    public boolean getUpdateFont() {
        return this.updateFont;
    }

    public void setUpdateFont(boolean updateFont) {
        this.updateFont = updateFont;
    }

    public int getSelectionWidth() {
        return this.selectionWidth;
    }

    public void setSelectionWidth(int width) {
        this.selectionWidth = width > 5 ? 5 : (width < 0 ? 0 : width);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        if (color != null) {
            this.selectionColor = color;
        }
    }

    public Color getSelectionBorderColor() {
        return this.selectionBorderColor;
    }

    public void setSelectionBorderColor(Color color) {
        if (color != null) {
            this.selectionBorderColor = color;
        }
    }

    public boolean hasSelectionBorder() {
        return this.hasSelectionBorder;
    }

    public void setHasSelectionBorder(boolean b) {
        this.hasSelectionBorder = b;
    }

    public Color getBookmarkBackground() {
        return this.bookmarkBackground;
    }

    public void setBookmarkBackground(Color color) {
        if (color != null) {
            this.bookmarkBackground = color;
        }
    }

    public int getBookmarkAreaWidth() {
        return this.getBookmarkWidth() + this.getBookmarkGap() * 2;
    }

    public int getBookmarkWidth() {
        return this.bookmarkWidth;
    }

    public void setBookmarkWidth(int width) {
        this.bookmarkWidth = width > 15 ? 15 : (width < 7 ? 7 : width);
    }

    public int getBookmarkGap() {
        return this.bookmarkGap;
    }

    public void setBookmarkGap(int gap) {
        this.bookmarkGap = gap > 10 ? 10 : (gap < 0 ? 0 : gap);
    }

    public Color getBookmarkColor() {
        return this.bookmarkColor;
    }

    public void setBookmarkColor(Color color) {
        if (color != null) {
            this.bookmarkColor = color;
        }
    }

    public Color getBookmarkBorderColor() {
        return this.bookmarkBorderColor;
    }

    public void setBookmarkBorderColor(Color color) {
        if (color != null) {
            this.bookmarkBorderColor = color;
        }
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public void setBorderGap(int gap) {
        this.borderGap = gap;
        EmptyBorder inner = new EmptyBorder(0, gap + this.getBookmarkAreaWidth(), 0, gap);
        if (this.isLineBorderVisible()) {
            this.setBorder(new CompoundBorder(this.getLineBorder(), inner));
        } else {
            this.setBorder(inner);
        }
        this.lastDigits = 0;
        this.setPreferredWidth();
    }

    public boolean isLineBorderVisible() {
        return this.lineBorderVisible;
    }

    public void setLineBorderVisible(boolean b) {
        this.lineBorderVisible = b;
    }

    public Border getLineBorder() {
        return this.outerBorder;
    }

    public void setLineBorder(Color color, int width) {
        if (color != null) {
            this.outerBorder = new SideBorder(null, null, null, color, width);
        }
    }

    public Color getCurrentLineForeground() {
        return this.currentLineForeground == null ? this.getForeground() : this.currentLineForeground;
    }

    public void setCurrentLineForeground(Color c) {
        this.currentLineForeground = c;
    }

    public Color getCurrentLineBackground() {
        return this.currentLineBackground == null ? this.getBackground() : this.currentLineBackground;
    }

    public void setCurrentLineBackground(Color c) {
        this.currentLineBackground = c;
    }

    public boolean isCurrentLineBackgroundEnabled() {
        return this.currentLineBackgroundEnabled;
    }

    public void setCurrentLineBackgroundEnabled(boolean b) {
        this.currentLineBackgroundEnabled = b;
    }

    public float getDigitAlignment() {
        return this.digitAlignment;
    }

    public void setDigitAlignment(float digitAlignment) {
        this.digitAlignment = digitAlignment > 1.0f ? 1.0f : (digitAlignment < 0.0f ? 0.0f : digitAlignment);
    }

    public int getMinimumDisplayDigits() {
        return this.minimumDisplayDigits;
    }

    public void setMinimumDisplayDigits(int minimumDisplayDigits) {
        this.minimumDisplayDigits = minimumDisplayDigits;
        this.setPreferredWidth();
    }

    void setPreferredWidth() {
        Element root = this.textArea.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), this.minimumDisplayDigits);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, 2146483647);
            this.setPreferredSize(d);
            this.setSize(d);
        }
    }

    void superPaintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        GUIUtilities.setRenderingHints(g);
        super.paintComponent(g);
        g.setColor(this.getBookmarkBackground());
        if (this.textArea.isMain()) {
            g.fillRect(0, 0, this.getBookmarkAreaWidth(), this.getHeight());
        } else {
            g.drawLine(this.getBookmarkAreaWidth(), 0, this.getBookmarkAreaWidth(), this.getHeight());
        }
        FontMetrics fontMetrics = this.textArea.getFontMetrics(this.textArea.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        Rectangle clip = g.getClipBounds();
        int rowStartOffset = this.textArea.viewToModel(new Point(0, clip.y));
        int endOffset = this.textArea.viewToModel(new Point(0, clip.y + clip.height));
        while (rowStartOffset <= endOffset) {
            try {
                Rectangle r = this.textArea.modelToView(rowStartOffset);
                boolean isCurrentLine = this.isCurrentLine(rowStartOffset);
                if (isCurrentLine && this.isCurrentLineBackgroundEnabled() && !this.editPane.isActiveLineVisible()) {
                    g.setColor(this.getCurrentLineBackground());
                    g.fillRect(r.x + this.getBookmarkAreaWidth(), r.y, this.getWidth(), r.height);
                }
                g.setColor(isCurrentLine ? this.getCurrentLineForeground() : this.getForeground());
                String lineNumber = this.getTextLineNumber(rowStartOffset);
                int stringWidth = fontMetrics.stringWidth(lineNumber);
                int x = this.getOffsetX(availableWidth, stringWidth) + insets.left;
                int y = this.getOffsetY(rowStartOffset, fontMetrics);
                g.drawString(lineNumber, x, y);
                rowStartOffset = Utilities.getRowEnd(this.textArea, rowStartOffset) + 1;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        Graphics2D g2D = (Graphics2D)g;
        Object oldRendering = g2D.getRenderingHint(RenderingHints.KEY_RENDERING);
        Object oldAntialiasing = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            if (this.editPane.hasBookmarks()) {
                DocumentRange[] ranges;
                DocumentRange[] documentRangeArray = ranges = this.editPane.getBookmarks();
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    DocumentRange range = documentRangeArray[n2];
                    this.paintBookmark(g, range.getStartOffset());
                    ++n2;
                }
            }
            if (this.textArea.hasSelection() && this.getSelectionWidth() > 1) {
                this.paintSelection(g);
            }
        }
        finally {
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, oldRendering);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
        }
    }

    void paintBookmark(Graphics g, int rowStartOffset) {
        try {
            Rectangle r = this.textArea.modelToView(rowStartOffset);
            int x = this.getBookmarkGap();
            int w = this.getBookmarkWidth();
            int[] xs = new int[5];
            int[] ys = new int[5];
            xs[0] = xs[1] = x;
            xs[2] = x + w / 2;
            xs[3] = xs[4] = x + w - 1;
            ys[0] = ys[4] = r.y + 1;
            ys[1] = ys[3] = r.y + r.height - 2;
            ys[2] = r.y + r.height - 5;
            g.setColor(this.getBookmarkColor());
            g.fillPolygon(xs, ys, 5);
            g.setColor(this.getBookmarkBorderColor());
            g.drawPolygon(xs, ys, 5);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    void paintSelection(Graphics g) {
        try {
            int selectionStart = this.textArea.getSelectionStart();
            int selectionEnd = this.textArea.getSelectionEnd();
            if (selectionEnd > selectionStart) {
                Rectangle r1 = this.textArea.modelToView(selectionStart);
                Rectangle r2 = this.textArea.modelToView(selectionEnd);
                int x = this.getWidth() - this.getSelectionWidth() - 3;
                int y = r1.y;
                int w = this.getSelectionWidth();
                int h = r2.y - r1.y + r2.height;
                g.setColor(this.getSelectionColor());
                g.fillRect(x, y, w, h);
                if (this.hasSelectionBorder()) {
                    GUIUtilities.drawBorder(g, this.getSelectionBorderColor(), x, y, w, h);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    boolean isCurrentLine(int rowStartOffset) {
        int caretPosition = this.textArea.getCaretPosition();
        Element root = this.textArea.getDocument().getDefaultRootElement();
        return root.getElementIndex(rowStartOffset) == root.getElementIndex(caretPosition);
    }

    String getTextLineNumber(int rowStartOffset) {
        int index;
        Element root = this.textArea.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(rowStartOffset));
        if (line.getStartOffset() == rowStartOffset) {
            int i = index + 1;
            return String.valueOf(i);
        }
        return "";
    }

    int getOffsetX(int availableWidth, int stringWidth) {
        return (int)((float)(availableWidth - stringWidth) * this.digitAlignment);
    }

    int getOffsetY(int rowStartOffset, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle r = this.textArea.modelToView(rowStartOffset);
        int lineHeight = fontMetrics.getHeight();
        int y = r.y + r.height;
        int descent = 0;
        if (r.height == lineHeight) {
            descent = fontMetrics.getDescent();
        } else {
            if (this.fonts == null) {
                this.fonts = new HashMap();
            }
            Element root = this.textArea.getDocument().getDefaultRootElement();
            int index = root.getElementIndex(rowStartOffset);
            Element line = root.getElement(index);
            int i = 0;
            while (i < line.getElementCount()) {
                Element child = line.getElement(i);
                AttributeSet as = child.getAttributes();
                String fontFamily = (String)as.getAttribute(StyleConstants.FontFamily);
                Integer fontSize = (Integer)as.getAttribute(StyleConstants.FontSize);
                String key = String.valueOf(fontFamily) + fontSize;
                FontMetrics fm = this.fonts.get(key);
                if (fm == null) {
                    Font font = new Font(fontFamily, 0, fontSize);
                    fm = this.textArea.getFontMetrics(font);
                    this.fonts.put(key, fm);
                }
                descent = Math.max(descent, fm.getDescent());
                ++i;
            }
        }
        return y - descent;
    }

    void checkForRepaint() {
        int caretPosition = this.textArea.getCaretPosition();
        Element root = this.textArea.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        boolean hasSelection = this.textArea.hasSelection();
        boolean changeLine = this.lastLine != currentLine;
        boolean changeSelection = this.lasHasSelection ^ hasSelection;
        if (changeLine || changeSelection) {
            this.repaint();
            if (changeLine) {
                this.lastLine = currentLine;
            }
            if (changeSelection) {
                this.lasHasSelection = hasSelection;
            }
        }
    }

    void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int preferredHeight = SimpleGutter.this.textArea.getPreferredSize().height;
                if (SimpleGutter.this.lastHeight != preferredHeight) {
                    SimpleGutter.this.setPreferredWidth();
                    SimpleGutter.this.repaint();
                    SimpleGutter.this.lastHeight = preferredHeight;
                }
            }
        });
    }

    void handleMouseReleased(MouseEvent e) {
    }

    void handleMousePressed(MouseEvent e) {
        Object obj = e.getSource();
        if (obj == this.textArea) {
            this.checkForRepaint();
        } else if (obj == this && !e.isControlDown() && e.getClickCount() == 1) {
            if (e.isShiftDown()) {
                int rowPos = this.textArea.viewToModel(new Point(0, e.getY()));
                Element line = this.textArea.getJNPadDocument().getParagraphElement(rowPos);
                this.selectionEnd = line.getEndOffset() - 1;
                if (this.selectionBegin <= this.selectionEnd) {
                    this.textArea.select(this.selectionBegin, this.selectionEnd);
                } else {
                    this.textArea.select(this.selectionEnd, this.selectionBegin);
                }
            } else {
                int rowPos = this.textArea.viewToModel(new Point(0, e.getY()));
                Element line = this.textArea.getJNPadDocument().getParagraphElement(rowPos);
                this.selectionBegin = line.getStartOffset();
                this.selectionEnd = line.getEndOffset() - 1;
                this.textArea.select(this.selectionBegin, this.selectionEnd);
            }
        }
    }

    void handleMouseDragged(MouseEvent e) {
        Object obj = e.getSource();
        if (obj == this.textArea) {
            this.checkForRepaint();
        }
    }

    private class Handler
    extends MouseInputAdapter
    implements CaretListener,
    DocumentListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SimpleGutter.this.handleMouseReleased(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SimpleGutter.this.handleMousePressed(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            SimpleGutter.this.handleMouseDragged(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SimpleGutter.this.documentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SimpleGutter.this.documentChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SimpleGutter.this.documentChanged();
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            SimpleGutter.this.checkForRepaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getNewValue() instanceof Font) {
                if (SimpleGutter.this.updateFont) {
                    Font newFont = (Font)e.getNewValue();
                    SimpleGutter.this.setFont(newFont);
                    SimpleGutter.this.lastDigits = 0;
                    SimpleGutter.this.setPreferredWidth();
                } else {
                    SimpleGutter.this.repaint();
                }
            }
        }
    }
}

