/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyledDocument;
import jnpad.GUIUtilities;
import jnpad.config.Config;
import jnpad.text.JNPadTextArea;
import jnpad.util.LinePosition;
import jnpad.util.Utilities;

public final class TextUtilities {
    private static final Logger LOGGER = Logger.getLogger(TextUtilities.class.getName());

    private TextUtilities() {
    }

    public static void indentLines(Document doc, int fromPos, int toPos, int tabSize) {
        int lineStart = TextUtilities.getLineNumber(doc, fromPos);
        int lineEnd = TextUtilities.getLineNumber(doc, toPos);
        int line = lineStart;
        while (line <= lineEnd) {
            try {
                Element lineElem = doc.getDefaultRootElement().getElement(line);
                doc.insertString(lineElem.getStartOffset(), Utilities.spaces(tabSize), lineElem.getAttributes());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            ++line;
        }
    }

    public static void indentLines(Document doc, int fromPos, int toPos) {
        int lineStart = TextUtilities.getLineNumber(doc, fromPos);
        int lineEnd = TextUtilities.getLineNumber(doc, toPos);
        int line = lineStart;
        while (line <= lineEnd) {
            try {
                Element lineElem = doc.getDefaultRootElement().getElement(line);
                doc.insertString(lineElem.getStartOffset(), "\t", lineElem.getAttributes());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            ++line;
        }
    }

    public static void unindentLines(Document doc, int fromPos, int toPos) {
        int lineStart = TextUtilities.getLineNumber(doc, fromPos);
        int lineEnd = TextUtilities.getLineNumber(doc, toPos);
        int line = lineStart;
        while (line <= lineEnd) {
            try {
                Element lineElem = doc.getDefaultRootElement().getElement(line);
                char ci = doc.getText(lineElem.getStartOffset(), 1).charAt(0);
                if (Character.isWhitespace(ci) && ci != '\n') {
                    doc.remove(lineElem.getStartOffset(), 1);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            ++line;
        }
    }

    public static void unindentLines(Document doc, int fromPos, int toPos, int tabSize) {
        int lineStart = TextUtilities.getLineNumber(doc, fromPos);
        int lineEnd = TextUtilities.getLineNumber(doc, toPos);
        int line = lineStart;
        while (line <= lineEnd) {
            try {
                Element lineElem = doc.getDefaultRootElement().getElement(line);
                int lineElemStart = lineElem.getStartOffset();
                int lineElemEnd = lineElem.getEndOffset();
                String lineText = doc.getText(lineElemStart, lineElemEnd - lineElemStart);
                String spacedTab = Utilities.spaces(tabSize);
                char ci = doc.getText(lineElemStart, 1).charAt(0);
                if (lineText.startsWith(spacedTab)) {
                    doc.remove(lineElemStart, tabSize);
                } else if (Character.isWhitespace(ci) && ci != '\n') {
                    doc.remove(lineElemStart, 1);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            ++line;
        }
    }

    public static int getLineNumber(Document doc, int pos) {
        Element map = doc.getDefaultRootElement();
        return map.getElementIndex(pos);
    }

    public static Element getLine(Document doc, int lineNo) {
        return doc.getDefaultRootElement().getElement(lineNo);
    }

    public static int getCurrentLineIndex(JTextComponent textComponent) {
        Document document = textComponent.getDocument();
        return document.getDefaultRootElement().getElementIndex(textComponent.getCaretPosition());
    }

    public static int getNumberOfLines(Document doc) {
        return doc.getDefaultRootElement().getElementCount();
    }

    public static int[] getLineColumnNumbers(Document doc, int pos) {
        Element map = doc.getDefaultRootElement();
        int line = map.getElementIndex(pos);
        Element lineElem = map.getElement(line);
        return new int[]{line, pos - lineElem.getStartOffset()};
    }

    public static LinePosition getLinePosition(JNPadTextArea textArea, int pos) {
        Document doc = textArea.getDocument();
        Element map = doc.getDefaultRootElement();
        int lines = map.getElementCount();
        int line = map.getElementIndex(pos);
        Element lineElem = map.getElement(line);
        int ch = pos - lineElem.getStartOffset();
        int chs = lineElem.getEndOffset() - lineElem.getStartOffset();
        int col = ch;
        try {
            String text = doc.getText(lineElem.getStartOffset(), ch);
            if (Utilities.countMatches(text, "\t") > 0 && GUIUtilities.isMonoSpaceFont(textArea.getFont())) {
                col = TextUtilities.getColumnAtCaret(textArea);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new LinePosition(line + 1, col + 1, ch + 1, lines, chs);
    }

    public static int getColumnAtCaret(JTextComponent textComponent) {
        FontMetrics fm = textComponent.getFontMetrics(textComponent.getFont());
        int characterWidth = fm.stringWidth("0");
        int column = 0;
        try {
            Rectangle r = textComponent.modelToView(textComponent.getCaretPosition());
            int width = r.x - textComponent.getInsets().left;
            column = width / characterWidth;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return column;
    }

    public static int getLineStartOffsetForPos(PlainDocument doc, int pos) {
        Element line = doc.getParagraphElement(pos);
        return line.getStartOffset();
    }

    public static int getLineStartOffsetForPos(StyledDocument doc, int pos) {
        Element line = doc.getParagraphElement(pos);
        return line.getStartOffset();
    }

    public static void deleteLineAtPos(PlainDocument doc, int pos) throws Exception {
        Element lineElem = doc.getParagraphElement(pos);
        doc.remove(lineElem.getStartOffset(), lineElem.getEndOffset() - lineElem.getStartOffset());
    }

    public static void deleteLineAtPos(StyledDocument doc, int pos) throws Exception {
        Element lineElem = doc.getParagraphElement(pos);
        doc.remove(lineElem.getStartOffset(), lineElem.getEndOffset() - lineElem.getStartOffset());
    }

    public static void deleteLineAfterPos(PlainDocument doc, int pos) throws Exception {
        Element lineElem = doc.getParagraphElement(pos);
        int len = lineElem.getEndOffset() - pos - 1;
        if (len > 0) {
            doc.remove(pos, len);
        }
    }

    public static void deleteLineAfterPos(StyledDocument doc, int pos) throws Exception {
        Element lineElem = doc.getParagraphElement(pos);
        int len = lineElem.getEndOffset() - pos - 1;
        if (len > 0) {
            doc.remove(pos, len);
        }
    }

    public static String getTextOfLineAtPosition(PlainDocument doc, int pos) {
        Element lineElem = doc.getParagraphElement(pos);
        try {
            return doc.getText(lineElem.getStartOffset(), lineElem.getEndOffset() - lineElem.getStartOffset());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTextOfLineAtPosition(StyledDocument doc, int pos) {
        Element lineElem = doc.getParagraphElement(pos);
        try {
            return doc.getText(lineElem.getStartOffset(), lineElem.getEndOffset() - lineElem.getStartOffset());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTextOfLineAtPosition_onlyUpToPos(PlainDocument doc, int pos) {
        Element line = doc.getParagraphElement(pos);
        try {
            return doc.getText(line.getStartOffset(), pos - line.getStartOffset());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTextOfLineAtPosition_onlyUpToPos(StyledDocument doc, int pos) {
        Element line = doc.getParagraphElement(pos);
        try {
            return doc.getText(line.getStartOffset(), pos - line.getStartOffset());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTextOfLine(Document doc, int line) {
        Element map = doc.getDefaultRootElement();
        Element lineElem = map.getElement(line);
        try {
            return doc.getText(lineElem.getStartOffset(), lineElem.getEndOffset() - lineElem.getStartOffset());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getText(Document doc) {
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, ex.getMessage(), ex);
            return "";
        }
    }

    public static String getText(Document doc, int offs, int len) {
        try {
            return doc.getText(offs, len);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, ex.getMessage(), ex);
            return "";
        }
    }

    public static String getTextFromTo(Document doc, int start, int end) {
        if (start == -1) {
            return "";
        }
        if (end <= start) {
            return "";
        }
        try {
            return doc.getText(start, end - start);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return "";
        }
    }

    public static char getCharAt(Document doc, int pos) {
        try {
            return doc.getText(pos, 1).charAt(0);
        }
        catch (Exception ex) {
            LOGGER.warning("Cannot read char at " + pos + " in doc: " + ex.getMessage());
            return '\u0000';
        }
    }

    public static int getDocPositionFor(Document doc, int line, int column) {
        if (line < 0) {
            return -1;
        }
        Element map = doc.getDefaultRootElement();
        Element lineElem = map.getElement(line - 1);
        if (lineElem == null) {
            return -1;
        }
        int pos = lineElem.getStartOffset() + (column > 0 ? column : 0);
        if (pos < 0) {
            return 0;
        }
        if (pos > doc.getLength()) {
            return doc.getLength();
        }
        return pos;
    }

    public static boolean haveSelection(JTextComponent textComponent) {
        Caret caret = textComponent.getCaret();
        return caret.getMark() != caret.getDot();
    }

    public static String doTabsToSpaces(String in, int tabSize) {
        StringBuilder buf = new StringBuilder();
        int width = 0;
        int i = 0;
        while (i < in.length()) {
            switch (in.charAt(i)) {
                case '\t': {
                    int count = tabSize - width % tabSize;
                    width += count;
                    while (--count >= 0) {
                        buf.append(' ');
                    }
                    break;
                }
                case '\n': {
                    width = 0;
                    buf.append(in.charAt(i));
                    break;
                }
                default: {
                    ++width;
                    buf.append(in.charAt(i));
                }
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String doSpacesToTabs(String in, int tabSize) {
        buf = new StringBuilder();
        i = 0;
        width = 0;
        whitespace = 0;
        while (i < in.length()) {
            switch (in.charAt(i)) {
                case ' ': {
                    ++whitespace;
                    ++width;
                    break;
                }
                case '\t': {
                    tab = tabSize - width % tabSize;
                    width += tab;
                    whitespace += tab;
                    break;
                }
                case '\n': {
                    whitespace = 0;
                    width = 0;
                    buf.append('\n');
                    break;
                }
                default: {
                    if (whitespace == 0) ** GOTO lbl41
                    if (whitespace < tabSize / 2 || whitespace <= 1) ** GOTO lbl39
                    indent = whitespace + (width - whitespace) % tabSize;
                    tabs = indent / tabSize;
                    spaces = indent % tabSize;
                    while (tabs-- > 0) {
                        buf.append('\t');
                    }
                    while (spaces-- > 0) {
                        buf.append(' ');
                    }
                    ** GOTO lbl40
lbl-1000:
                    // 1 sources

                    {
                        buf.append(' ');
lbl39:
                        // 2 sources

                        ** while (whitespace-- > 0)
                    }
lbl40:
                    // 2 sources

                    whitespace = 0;
lbl41:
                    // 2 sources

                    buf.append(in.charAt(i));
                    ++width;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static void sort(Document doc, boolean reverse) {
        TextUtilities.sort(doc, 0, doc.getLength(), reverse);
    }

    public static void sort(Document doc, int offset, int length, boolean reverse) {
        if (doc == null) {
            return;
        }
        Element map = doc.getDefaultRootElement();
        int fromIndex = map.getElementIndex(offset);
        int toIndex = map.getElementIndex(offset + length);
        Object[] lines = new String[toIndex - fromIndex + 1];
        try {
            int i;
            int i2 = 0;
            while (i2 < lines.length) {
                Element lineElem = map.getElement(fromIndex + i2);
                lines[i2] = doc.getText(lineElem.getStartOffset(), lineElem.getEndOffset() - lineElem.getStartOffset());
                if (((String)lines[i2]).endsWith("\n")) {
                    lines[i2] = ((String)lines[i2]).substring(0, ((String)lines[i2]).length() - 1);
                }
                ++i2;
            }
            Arrays.sort(lines);
            StringBuilder buf = new StringBuilder();
            if (reverse) {
                i = lines.length - 1;
                while (i > 0) {
                    buf.append(((String)lines[i]).concat("\n"));
                    --i;
                }
                buf.append((String)lines[0]);
            } else {
                i = 0;
                while (i < lines.length - 1) {
                    buf.append(((String)lines[i]).concat("\n"));
                    ++i;
                }
                buf.append((String)lines[lines.length - 1]);
            }
            int selStart = map.getElement(fromIndex).getStartOffset();
            int selLength = map.getElement(toIndex).getEndOffset() - selStart - 1;
            doc.remove(selStart, selLength);
            doc.insertString(selStart, buf.toString(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static int[] getVisibleDocPosBounds(JTextComponent textComponent, JScrollPane scrollPane) {
        int[] pos = new int[2];
        try {
            Point pt = scrollPane.getViewport().getViewPosition();
            pos[0] = textComponent.viewToModel(pt);
            Dimension dim = scrollPane.getViewport().getExtentSize();
            Point pt2 = new Point(pt.x + dim.width, pt.y + dim.height);
            pos[1] = textComponent.viewToModel(pt2);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        return pos;
    }

    public static void scrollToMiddle(JTextComponent textComponent, int pos) {
        JViewport vp = null;
        if (textComponent.getParent() instanceof JViewport) {
            vp = (JViewport)textComponent.getParent();
        }
        if (vp != null) {
            try {
                Rectangle viewRect = vp.getViewRect();
                Rectangle r = textComponent.modelToView(pos);
                int n = r.width = r.width == 0 ? 1 : r.width;
                if (!viewRect.contains(r)) {
                    int h = r.y - vp.getHeight() / 4;
                    if (h < 0) {
                        h = 0;
                    }
                    vp.setViewPosition(new Point(0, h));
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, ex.getMessage(), ex);
            }
        }
    }

    public static void scrollToMiddle(JTextComponent textComponent, int pos, float ratio) {
        JViewport vp = null;
        if (textComponent.getParent() instanceof JViewport) {
            vp = (JViewport)textComponent.getParent();
        }
        if (vp != null) {
            try {
                Rectangle r = textComponent.modelToView(pos);
                int h = r.y - (int)((float)vp.getHeight() * ratio);
                if (h < 0) {
                    h = 0;
                }
                vp.setViewPosition(new Point(0, h));
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, ex.getMessage(), ex);
            }
        }
    }

    public static String getSingleJavaWordAt(Document doc, int pos) {
        int[] range = TextUtilities.getJavaWordBoundsAt(doc, pos, false);
        if (range == null) {
            return null;
        }
        return TextUtilities.getTextFromTo(doc, range[0], range[1]);
    }

    public static String getSingleWordAt(Document doc, int pos, String delimiters) {
        int[] range = TextUtilities.getWordBoundsAt(doc, pos, delimiters);
        if (range == null) {
            return null;
        }
        return TextUtilities.getTextFromTo(doc, range[0], range[1]);
    }

    public static int[] getJavaWordBoundsAt(Document doc, int pos, boolean acceptDots) {
        char c;
        int start = pos;
        while (start >= 0) {
            c = TextUtilities.getCharAt(doc, start);
            if (!(Character.isJavaIdentifierPart(c) || acceptDots && c == '.')) {
                if (Character.isJavaIdentifierStart(c)) break;
                ++start;
                break;
            }
            --start;
        }
        int end = pos;
        while (end < doc.getLength()) {
            c = TextUtilities.getCharAt(doc, end);
            if ((!acceptDots || c != '.') && !Character.isJavaIdentifierPart(c)) break;
            ++end;
        }
        if (start < 0) {
            start = 0;
        }
        if (start >= end) {
            return null;
        }
        return new int[]{start, end};
    }

    public static int[] getWordBoundsAt(Document doc, int pos, String delimiters) {
        char c;
        if (delimiters == null) {
            delimiters = Config.TEXT_DELIMITERS.getValue();
        }
        int start = pos;
        while (start >= 0) {
            c = TextUtilities.getCharAt(doc, start);
            if (delimiters.indexOf(c) >= 0 || Character.isWhitespace(c)) {
                ++start;
                break;
            }
            --start;
        }
        int end = pos;
        while (end < doc.getLength()) {
            c = TextUtilities.getCharAt(doc, end);
            if (delimiters.indexOf(c) >= 0 || Character.isWhitespace(c)) break;
            ++end;
        }
        if (start < 0) {
            start = 0;
        }
        if (start >= end) {
            return null;
        }
        return new int[]{start, end};
    }

    public static int findWordStart(String line, int pos, String delimiters) {
        char c;
        if (delimiters == null) {
            delimiters = Config.TEXT_DELIMITERS.getValue();
        }
        boolean selectNoLetter = delimiters.indexOf(c = line.charAt(pos)) >= 0 || Character.isWhitespace(c);
        int wordStart = 0;
        int i = pos;
        while (i >= 0) {
            c = line.charAt(i);
            if (selectNoLetter ^ (delimiters.indexOf(c) >= 0 || Character.isWhitespace(c))) {
                wordStart = i + 1;
                break;
            }
            --i;
        }
        return wordStart;
    }

    public static int findWordEnd(String line, int pos, String delimiters) {
        char c;
        if (delimiters == null) {
            delimiters = Config.TEXT_DELIMITERS.getValue();
        }
        if (pos != 0) {
            --pos;
        }
        boolean selectNoLetter = delimiters.indexOf(c = line.charAt(pos)) >= 0 || Character.isWhitespace(c);
        int wordEnd = line.length();
        int i = pos;
        while (i < line.length()) {
            c = line.charAt(i);
            if (selectNoLetter ^ (delimiters.indexOf(c) >= 0 || Character.isWhitespace(c))) {
                wordEnd = i;
                break;
            }
            ++i;
        }
        return wordEnd;
    }

    public static int locateBracketBackward(Document doc, int dot, char openBracket, char closeBracket) throws BadLocationException {
        Element map = doc.getDefaultRootElement();
        int lineNo = map.getElementIndex(dot);
        Element lineElement = map.getElement(lineNo);
        int start = lineElement.getStartOffset();
        int offset = TextUtilities.scanBackwardLine(doc.getText(start, dot - start), openBracket, closeBracket, 0);
        int count = -offset - 1;
        if (offset >= 0) {
            return start + offset;
        }
        int i = lineNo - 1;
        while (i >= 0) {
            lineElement = map.getElement(i);
            start = lineElement.getStartOffset();
            offset = TextUtilities.scanBackwardLine(doc.getText(start, lineElement.getEndOffset() - start), openBracket, closeBracket, count);
            count = -offset - 1;
            if (offset >= 0) {
                return start + offset;
            }
            --i;
        }
        return -1;
    }

    public static int locateBracketForward(Document doc, int dot, char openBracket, char closeBracket) throws BadLocationException {
        Element map = doc.getDefaultRootElement();
        int lineNo = map.getElementIndex(dot);
        Element lineElement = map.getElement(lineNo);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        int offset = TextUtilities.scanForwardLine(doc.getText(dot + 1, end - (dot + 1)), openBracket, closeBracket, 0);
        int count = -offset - 1;
        if (offset >= 0) {
            return dot + offset + 1;
        }
        int i = lineNo + 1;
        while (i < map.getElementCount()) {
            lineElement = map.getElement(i);
            start = lineElement.getStartOffset();
            offset = TextUtilities.scanForwardLine(doc.getText(start, lineElement.getEndOffset() - start), openBracket, closeBracket, count);
            count = -offset - 1;
            if (offset >= 0) {
                return start + offset;
            }
            ++i;
        }
        return -1;
    }

    private static int scanBackwardLine(String line, char openBracket, char closeBracket, int count) {
        int i = line.length() - 1;
        while (i >= 0) {
            char c = line.charAt(i);
            if (c == closeBracket) {
                ++count;
            } else if (c == openBracket && --count < 0) {
                return i;
            }
            --i;
        }
        return -1 - count;
    }

    private static int scanForwardLine(String line, char openBracket, char closeBracket, int count) {
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == openBracket) {
                ++count;
            } else if (c == closeBracket && --count < 0) {
                return i;
            }
            ++i;
        }
        return -1 - count;
    }
}

