/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import jnpad.GUIUtilities;
import jnpad.config.Config;
import jnpad.text.AbstractTextArea;

public class PlainView2
extends PlainView {
    boolean mini;

    public PlainView2(Element elem, boolean mini) {
        super(elem);
        this.mini = mini;
    }

    @Override
    public void paint(Graphics g, Shape a) {
        GUIUtilities.setRenderingHints(g);
        Container c = this.getContainer();
        if (c instanceof AbstractTextArea) {
            Rectangle viewRect;
            AbstractTextArea host = (AbstractTextArea)c;
            if (host.isViewRectVisible() && (viewRect = host.getViewRect()) != null) {
                g.setColor(Config.MINIMAP_VIEWRECT_COLOR.getValue());
                g.fillRect(viewRect.x, viewRect.y, viewRect.width, viewRect.height);
                g.setColor(Config.MINIMAP_VIEWRECT_BORDER_COLOR.getValue());
                GUIUtilities.drawDottedRectangle(g, viewRect);
            }
            if (host.isRightMarginLineVisible()) {
                this.updateMetrics();
                int fontWidth = this.metrics.charWidth('m');
                int margin = host.getRightMarginLineWidth() * fontWidth;
                g.setColor(host.getRightMarginLineColor());
                g.drawLine(margin + 1, 0, margin + 1, c.getHeight());
            }
        }
        super.paint(g, a);
    }
}

