/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalComboBoxButton;
import jnpad.GUIUtilities;
import jnpad.ui.ColorUtilities;
import jnpad.ui.plaf.JNPadMenuUI;
import jnpad.ui.plaf.JNPadToolBarButtonUI;
import jnpad.ui.toolbar.ToolBarButton;

public final class JNPadButtonUI
extends MetalButtonUI {
    private static Color color1a;
    private static Color color1b;
    private static final JNPadButtonUI INSTANCE;

    static {
        INSTANCE = new JNPadButtonUI();
    }

    public static ComponentUI createUI(JComponent c) {
        if (c instanceof ToolBarButton) {
            return JNPadToolBarButtonUI.createUI(c);
        }
        return INSTANCE;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!c.isOpaque()) {
            super.paint(g, c);
            return;
        }
        if (JNPadButtonUI.check(c)) {
            Color color1;
            Color color2;
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (!button.isRolloverEnabled()) {
                button.setRolloverEnabled(true);
            }
            int w = c.getWidth();
            int h = c.getHeight();
            if (model.isRollover()) {
                color2 = JNPadMenuUI.topLevelMenuBg();
                color1 = this.color1a(color2);
            } else {
                color2 = c.getBackground();
                color1 = this.color1b(color2);
            }
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 0.0f, h, color2);
            g2D.setPaint(gp);
            g2D.fill(new Rectangle2D.Double(0.0, 0.0, w, h));
            GUIUtilities.draw3DBorder(g, color1, ColorUtilities.darker(color2, 25.0), 2, 2, w - 4, h - 4);
        }
        super.paint(g, c);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        GUIUtilities.setRenderingHints(g);
        super.paintText(g, (JComponent)b, textRect, text);
    }

    private static boolean check(JComponent c) {
        return c.getWidth() > c.getHeight() + 15 && !(c instanceof MetalComboBoxButton);
    }

    private Color color1a(Color color2) {
        if (color1a == null) {
            color1a = new Color(Math.min(255, color2.getRed() + 35), Math.min(255, color2.getRed() + 35), Math.min(255, color2.getBlue() + 35));
        }
        return color1a;
    }

    private Color color1b(Color color2) {
        if (color1b == null) {
            color1b = new Color(Math.min(255, color2.getRed() + 35), Math.min(255, color2.getRed() + 35), Math.min(255, color2.getBlue() + 35));
        }
        return color1b;
    }
}

