/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui.table;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import jnpad.ui.table.JNPadTableModel;

public class JNPadDefaultTableModel
extends DefaultTableModel
implements JNPadTableModel {
    private int sortedColumnIndex = -1;
    private boolean isAscending;
    private boolean isEditable = true;
    private static final long serialVersionUID = -8677302633092266110L;

    public JNPadDefaultTableModel() {
    }

    public JNPadDefaultTableModel(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public JNPadDefaultTableModel(int rowCount, int columnCount) {
        super(rowCount, columnCount);
    }

    public JNPadDefaultTableModel(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
    }

    public JNPadDefaultTableModel(Object[] columnNames, int rowCount) {
        super(columnNames, rowCount);
    }

    public JNPadDefaultTableModel(Vector<?> columnNames, int rowCount) {
        super(columnNames, rowCount);
    }

    public JNPadDefaultTableModel(Vector<?> data, Vector<?> columnNames) {
        super(data, columnNames);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        try {
            if (this.getRowCount() > 0) {
                return this.getValueAt(0, column).getClass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getColumnClass(column);
    }

    public void removeRows(int[] rows) {
        int i = 0;
        while (i < rows.length) {
            this.removeRow(rows[i] - i);
            ++i;
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.isEditable;
    }

    @Override
    public boolean isSortable(int column) {
        return true;
    }

    @Override
    public void setSortByColumn(int columnIndex, boolean isAscending) {
        Vector<Vector> data = this.getDataVector();
        Collections.sort(data, new UComparator(columnIndex, isAscending));
        this.isAscending = isAscending;
        this.sortedColumnIndex = columnIndex;
        super.fireTableDataChanged();
    }

    @Override
    public boolean isAscending() {
        return this.isAscending;
    }

    @Override
    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    static class UComparator
    implements Comparator,
    Serializable {
        private int sortedColumnIndex;
        private boolean isAscending;
        private static final long serialVersionUID = 6785677239317289558L;

        UComparator(int sortedColumnIndex, boolean isAscending) {
            this.sortedColumnIndex = sortedColumnIndex;
            this.isAscending = isAscending;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 instanceof Vector && obj2 instanceof Vector) {
                Object o1 = ((Vector)obj1).elementAt(this.sortedColumnIndex);
                Object o2 = ((Vector)obj2).elementAt(this.sortedColumnIndex);
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    Comparable c1 = (Comparable)o1;
                    Comparable c2 = (Comparable)o2;
                    if (this.isAscending) {
                        return c1.compareTo(c2);
                    }
                    return c2.compareTo(c1);
                }
            }
            return 0;
        }
    }
}

