/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_AUTOCOMPLETION_ENABLED;

import java.awt.event.ItemEvent;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.text.JNPadTextArea;

/**
 * The Class AutoCompletionAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class AutoCompletionAction extends JNPadAction {
  /** UID */
  private static final long serialVersionUID = 403044348573474697L;

  /**
   * Instantiates a new <code>AutoCompletionAction</code>.
   *
   * @param jNPad the jNPad's frame
   */
  public AutoCompletionAction(JNPadFrame jNPad) {
    super(jNPad, 
          ACTION_NAME_AUTOCOMPLETION_ENABLED, 
          Group.CONFIGURE, 
          null, null);

    if (Accelerators.isUsingCompositeShortcuts()) {
      setKeyBinding(Accelerators.getShortcutLabel(ACTION_NAME_AUTOCOMPLETION_ENABLED));
    }
    
    setSelected(Config.TEXT_AUTOCOMPLETION_ENABLED.getValue());
    setStateAction(true);
  }

  /**
   * Handle state changed.
   *
   * @param e the item event
   * @see jnpad.action.JNPadAction#handleStateChanged(java.awt.event.ItemEvent)
   */
  @Override
  public void handleStateChanged(final ItemEvent e) {
    final boolean b = ItemEvent.SELECTED == e.getStateChange();
    Config.TEXT_AUTOCOMPLETION_ENABLED.setValue(b);
    for (JNPadTextArea etxarea : jNPad.getViewer().getGlobalTextAreas()) {
      etxarea.setAutoCompletionEnabled(b);
    }
  }

}

