/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_FILE_BROWSER;
import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.config.Configurable;
import jnpad.filebrowser.FileBrowser;
import jnpad.util.Utilities;

/**
 * The Class FileBrowserAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class FileBrowserAction extends JNPadAction implements Configurable {
  /** The file browser. */
  private FileBrowser       fileBrowser;

  /** UID */
  private static final long serialVersionUID = 6288212845551057562L;

  /**
   * Instantiates a new file browser action.
   *
   * @param jNPad the jNPad's frame
   */
  public FileBrowserAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_FILE_BROWSER,
          Group.FILE,
          Accelerators.FILE_BROWSER, Utilities.EMPTY_STRING);
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    if(fileBrowser == null) {
      fileBrowser = new FileBrowser(jNPad);
    }
    fileBrowser.setVisible(true);
  }

  /**
   * Configure.
   *
   * @param cfg int
   * @see jnpad.config.Configurable#configure(int)
   */
  @Override
  public void configure(final int cfg) {
    if(fileBrowser != null) {
      fileBrowser.configure(cfg);
    }
  }

}
