/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_SELECT_LINE;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.text.DefaultEditorKit;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;

/**
 * The Class SelectLineAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class SelectLineAction extends JNPadAction {
  /** UID */
  private static final long serialVersionUID = -4318803693056077525L;

  /**
   * Instantiates a new select line action.
   *
   * @param jNPad the jNPad's frame
   */
  public SelectLineAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_SELECT_LINE,
          Group.EDIT,
          Accelerators.SELECT_LINE, "select-line.png"); //$NON-NLS-1$
  }

  /**
   * Sets the enabled.
   *
   * @param b the new enabled
   * @see javax.swing.AbstractAction#setEnabled(boolean)
   */
  @Override
  public void setEnabled(boolean b) {
    super.setEnabled(b);

    EditPane editPane = jNPad.getActiveEditPane();
    if (editPane != null) {
      Action action = editPane.getActions().get(DefaultEditorKit.selectLineAction);
      if (action != null) {
        action.setEnabled(b);
      }
    }
  }
  
  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    EditPane editPane = jNPad.getActiveEditPane();

    if (editPane != null) {
      Action action = editPane.getActions().get(DefaultEditorKit.selectLineAction);

      if (action != null) {
        action.actionPerformed(new ActionEvent(editPane.getTextArea(),
                                               ActionEvent.ACTION_PERFORMED,
                                               (String) action.getValue(Action.NAME),
                                               EventQueue.getMostRecentEventTime(),
                                               getCurrentEventModifiers()));
      }
    }
  }

}
