/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.config;

/**
 * The Class StringProp.
 * 
 * @version 0.3
 * @since jNPad 0.1
 */
public class StringProp extends Prop<String> {
  /** UID */
  private static final long serialVersionUID = 1559739318656570890L;

  /**
   * Instantiates a new string prop.
   * 
   * @param name the name
   * @param def the def
   */
  public StringProp(String name, String def) {
    super(name, def);
  }

  /**
   * Gets the default string.
   *
   * @return the default string
   * @see jnpad.config.Prop#getDefaultString()
   */
  @Override
  public String getDefaultString() {
    return defaultValue;
  }

  /**
   * Gets the value.
   *
   * @return the value
   * @see jnpad.config.Prop#getValue()
   */
  @Override
  public String getValue() {
    return Config.getStringProp(this);
  }

  /**
   * Do set value.
   *
   * @param value the value
   * @see jnpad.config.Prop#doSetValue(java.lang.Object)
   */
  @Override
  protected void doSetValue(String value) {
    Config.setStringProp(this, value);
  }

}
