/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.config;

/**
 * The Interface Updatable.
 * 
 * @version 0.3
 * @since jNPad 0.1
 */
public interface Updatable {
  /** The Constant CTRLS_UNDO. */
  int CTRLS_UNDO           = 1;

  /** The Constant CTRLS_SPLITTING. */
  int CTRLS_SPLITTING      = 1 << 1;

  /** The Constant CTRLS_TEXT_CHANGED. */
  int CTRLS_TEXT_CHANGED   = 1 << 2;

  /** The Constant CTRLS_TEXT_SELECTION. */
  int CTRLS_TEXT_SELECTION = 1 << 3;

  /** The Constant CTRLS_TEXT_MODE. */
  int CTRLS_TEXT_MODE      = 1 << 4;

  /** The Constant CTRLS_OCCURRENCE. */
  int CTRLS_OCCURRENCE     = 1 << 5;

  /** The Constant CTRLS_BOOKMARKING. */
  int CTRLS_BOOKMARKING    = 1 << 6;

  /** The Constant CTRLS_SEARCH. */
  int CTRLS_SEARCH         = 1 << 7;

  /** The Constant CTRLS_VIEW. */
  int CTRLS_VIEW           = 1 << 8;

  /** The Constant CTRLS_EDITABLE. */
  int CTRLS_EDITABLE       = 1 << 9;

  /** The Constant CTRLS_POSITION. */
  int CTRLS_POSITION       = 1 << 10;

  /** The Constant CTRLS_EOL. */
  int CTRLS_EOL            = 1 << 11;

  /** The Constant CTRLS_ENCODING. */
  int CTRLS_ENCODING       = 1 << 12;

  /** The Constant CTRLS_ALL. */
  int CTRLS_ALL            = CTRLS_UNDO | CTRLS_SPLITTING |
                               CTRLS_TEXT_CHANGED | CTRLS_TEXT_SELECTION | CTRLS_TEXT_MODE |
                               CTRLS_OCCURRENCE | CTRLS_BOOKMARKING | CTRLS_SEARCH |
                               CTRLS_VIEW | CTRLS_EDITABLE |
                               CTRLS_POSITION | CTRLS_EOL | CTRLS_ENCODING;

  /**
   * Update controls.
   * 
   * @param ctrls int
   */
  void updateControls(final int ctrls);

  /**
   * Update controls.
   */
  void updateControls();

}
