/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text;

import java.io.IOException;

import jnpad.config.Controlable;

/**
 * The Interface IBuffer.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public interface IBuffer extends Controlable {
  /**
   * Equals.
   *
   * @param obj the obj
   * @return true, if successful
   */
  @Override
  boolean equals(Object obj);

  /**
   * Hash code.
   *
   * @return the int
   */
  @Override
  int hashCode();

  /**
   * Gets the file path.
   *
   * @return the file path
   */
  String getFilePath();

  /**
   * Gets the content type.
   *
   * @return the content type
   */
  String getContentType();

  /**
   * Checks for selection.
   *
   * @return true, if successful
   */
  boolean hasSelection();

  /**
   * Gets the caret position.
   *
   * @return the caret position
   */
  int getCaretPosition();

  /**
   * Gets the tool tip text.
   *
   * @return the tool tip text
   */
  String getToolTipText();

  /**
   * Checks if is read only.
   *
   * @return true, if is read only
   */
  boolean isReadOnly();

  /**
   * Checks if is line wrapped.
   *
   * @return true, if is line wrapped
   * @since 0.3
   */
  boolean isLineWrapped();

  /**
   * Checks if is dirty.
   *
   * @return true, if is dirty
   */
  boolean isDirty();

  /**
   * Reload.
   *
   * @throws IOException Signals that an I/O exception has occurred.
   */
  void reload() throws IOException;

  /**
   * Request focus.
   */
  void requestFocus();

  /**
   * Request focus in window.
   *
   * @return true, if successful
   */
  boolean requestFocusInWindow();

  /**
   * Sets the file path.
   *
   * @param s the new file path
   */
  void setFilePath(String s);

  /**
   * To string.
   *
   * @return the string
   */
  @Override
  String toString();

}
