/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text;

import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;

/**
 * The Class JNPadTextAreaEditorKit.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class JNPadTextAreaEditorKit extends DefaultEditorKit {
  /** UID */
  private static final long serialVersionUID = -8411019424373007270L;

  /**
   * Instantiates a new jNPad text area editor kit.
   */
  public JNPadTextAreaEditorKit() {
    super();
  }

  /**
   * Creates the default document.
   *
   * @return the document
   * @see javax.swing.text.DefaultEditorKit#createDefaultDocument()
   */
  @Override
  public Document createDefaultDocument() {
    return new JNPadDocument();
  }

}
