/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text;

import jnpad.search.SearchContext;
import jnpad.util.Utilities;

/**
 * The Class OccurrencesContext.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class OccurrencesContext {
  private SearchContext searchContext;
  private int           countOfOccurrences;

  /**
   * Instantiates a new occurrences context.
   *
   * @param searchContext SearchContext
   * @param countOfOccurrences int
   */
  public OccurrencesContext(SearchContext searchContext, int countOfOccurrences) {
    this.searchContext = searchContext;
    this.countOfOccurrences = countOfOccurrences;
  }

  /**
   * Equals.
   *
   * @param obj the obj
   * @return true, if successful
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object obj) {
    return this == obj || obj != null && (obj instanceof OccurrencesContext)
        && Utilities.equals(searchContext, ((OccurrencesContext) obj).searchContext)
        && countOfOccurrences == ((OccurrencesContext) obj).countOfOccurrences;
  }

  /**
   * Hash code.
   *
   * @return the int
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode() {
    return Utilities.hashCode(searchContext, countOfOccurrences);
  }

  /**
   * Gets the search context.
   *
   * @return the search context
   */
  public SearchContext getSearchContext() {
    return searchContext;
  }

  /**
   * Gets the count of occurrences.
   *
   * @return the count of occurrences
   */
  public int getCountOfOccurrences() {
    return countOfOccurrences;
  }

  /**
   * To string.
   *
   * @return the string
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    return "[OccurrencesContext: " + //$NON-NLS-1$
        "searchContext='" + getSearchContext() + "'" + //$NON-NLS-1$//$NON-NLS-2$
        ", countOfOccurrences=" + getCountOfOccurrences() + //$NON-NLS-1$
        "]"; //$NON-NLS-1$
  }

}
