/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;

import jnpad.config.Config;
import jnpad.util.Utilities;

/**
 * The Class PropertiesScheme.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class PropertiesScheme extends SyntaxScheme {
  static Color              valueColor;

  Font                      valueFont;

  /** UID */
  private static final long serialVersionUID = -8334881204062472217L;

  /**
   * Instantiates a new properties scheme.
   *
   * @param mini the mini
   */
  public PropertiesScheme(boolean mini) {
    super(mini);
    doUpdateColors();
    doUpdateFonts();
  }

  /**
   * Do update colors.
   */
  private void doUpdateColors() {
    valueColor = Config.SYNTAX_KEYWORD6_COLOR.getValue();
  }

  /**
   * Do update fonts.
   */
  private void doUpdateFonts() {
    valueFont = textFont.deriveFont(Config.SYNTAX_KEYWORD6_STYLE.getValue());
  }

  /**
   * Sets the text font.
   *
   * @param f the new text font
   * @see jnpad.text.syntax.SyntaxScheme#setTextFont(java.awt.Font)
   */
  @Override
  public void setTextFont(Font f) {
    super.setTextFont(f);
    doUpdateFonts();
  }
  
  /**
   * Configure.
   *
   * @param cfg the cfg
   * @see jnpad.text.syntax.SyntaxScheme#configure(int)
   */
  @Override
  public void configure(final int cfg) {
    super.configure(cfg);
    if ((cfg & CFG_COLOR) != 0) {
      doUpdateColors();
    }
    if ((cfg & CFG_FONT) != 0) {
      doUpdateFonts();
    }
  }

  /**
   * Gets the value color.
   *
   * @return the value color
   */
  public Color getValueColor() {
    return valueColor;
  }

  /**
   * Gets the value font.
   *
   * @return the value font
   */
  public Font getValueFont() {
    return valueFont;
  }
 
  /**
   * Gets the content type.
   *
   * @return the content type
   * @see jnpad.text.Scheme#getContentType()
   */
  @Override
  public String getContentType() {
    return ContentTypes.PROPERTIES;
  }

  /**
   * Gets the start comment.
   *
   * @return the start comment
   * @see jnpad.text.syntax.PlainScheme#getStartComment()
   */
  @Override
  public String[] getStartComment() {
    return new String[] { "#" }; //$NON-NLS-1$
  }

  /**
   * Gets the end comment.
   *
   * @return the end comment
   * @see jnpad.text.syntax.PlainScheme#getEndComment()
   */
  @Override
  public String[] getEndComment() {
    return new String[] { Utilities.LF_STRING };
  }
  
}
