/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.io.File;

import javax.swing.filechooser.FileFilter;

import jnpad.JNPadBundle;

/**
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public class JNPadFileFilter extends FileFilter {
  /**
   * Acepta todos los directorios y archivos JNPad(*.jnpad).
   * 
   * @param file archivo a aplicarle el filtro.
   * @return <code>true</code> si acepta el archivo y <code>false</code> si no
   *         lo acepta
   */
  @Override
  public boolean accept(File file) {
    String s = file.getName().toLowerCase();
    return file.isDirectory() || s.endsWith(".jnpad"); //$NON-NLS-1$
  }

  /**
   * La descripcin del filtro
   * 
   * @return String que corresponde a la descripcin
   */
  @Override
  public String getDescription() {
    return JNPadBundle.getString("JNPadFileFilter.description"); //$NON-NLS-1$
  }
}
