/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.awt.Graphics;

import javax.swing.Icon;
import javax.swing.JLabel;

import jnpad.GUIUtilities;

/**
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public class JNPadLabel extends JLabel {
  /** UID */
  private static final long serialVersionUID = -4815119966772980069L;

  /**
   * 
   */
  public JNPadLabel() {
    super();
  }

  /**
   * 
   * @param text String
   */
  public JNPadLabel(String text) {
    super(text);
  }

  /**
   * 
   * @param image Icon
   */
  public JNPadLabel(Icon image) {
    super(image);
  }

  /**
   * 
   * @param text String
   * @param horizontalAlignment int
   */
  public JNPadLabel(String text, int horizontalAlignment) {
    super(text, horizontalAlignment);
  }

  /**
   * 
   * @param image Icon
   * @param horizontalAlignment int
   */
  public JNPadLabel(Icon image, int horizontalAlignment) {
    super(image, horizontalAlignment);
  }

  /**
   * 
   * @param text String
   * @param icon Icon
   * @param horizontalAlignment int
   */
  public JNPadLabel(String text, Icon icon, int horizontalAlignment) {
    super(text, icon, horizontalAlignment);
  }

  /**
   * 
   * @param g Graphics
   */
  @Override
  protected void paintComponent(Graphics g) {
    GUIUtilities.setRenderingHints(g);
    super.paintComponent(g);
  }
  
}
