/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;

import javax.swing.border.Border;

/**
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public class SideBorder implements Border, Serializable {
  private Color _leftColor;
  private Color _rightColor;
  private Color _topColor;
  private Color _bottomColor;
  private int   _thickness;

  /** UID */
  private static final long serialVersionUID = 4069574159289528841L;

  
  /**
   * Instantiates a new side border.
   *
   * @param color the color
   * @param thickness the thickness
   */
  public SideBorder(Color color, int thickness) {
    this(color, color, color, color, thickness);
  }

  /**
   * Instantiates a new side border.
   *
   * @param topBottomColor the top bottom color
   * @param leftRightColor the left right color
   * @param thickness the thickness
   */
  public SideBorder(Color topBottomColor, Color leftRightColor, int thickness) {
    this(topBottomColor, leftRightColor, topBottomColor, leftRightColor, thickness);
  }
  
  /**
   * Instantiates a new side border.
   *
   * @param topColor the top color
   * @param leftColor the left color
   * @param bottomColor the bottom color
   * @param rightColor the right color
   * @param thickness the thickness
   */
  public SideBorder(Color topColor, Color leftColor, Color bottomColor, Color rightColor, int thickness) {
    _topColor    = topColor;
    _leftColor   = leftColor;
    _rightColor  = rightColor;
    _bottomColor = bottomColor;
    _thickness   = thickness;
  }

  /**
   *
   * @return int
   */
  public int getThickness() {return _thickness;}

  /**
   *
   * @return boolean
   */
  public boolean isBorderOpaque() {return false;}

  /**
   *
   * @param c Component
   * @return Insets
   */
  public Insets getBorderInsets(Component c) {
    return new Insets(
        _topColor    != null ? getThickness() : 0,
        _leftColor   != null ? getThickness() : 0,
        _bottomColor != null ? getThickness() : 0,
        _rightColor  != null ? getThickness() : 0
        );
  }

  /**
   * Gets the border insets.
   *
   * @param c the c
   * @param insets the insets
   * @return the border insets
   */
  public Insets getBorderInsets(Component c, Insets insets) {
    insets.top    = _topColor    != null ? getThickness() : 0;
    insets.left   = _leftColor   != null ? getThickness() : 0;
    insets.bottom = _bottomColor != null ? getThickness() : 0;
    insets.right  = _rightColor  != null ? getThickness() : 0;
    return insets;
  }

  /**
   *
   * @param c Component
   * @param g Graphics
   * @param x int
   * @param y int
   * @param width int
   * @param height int
   */
  public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    Color oldColor = g.getColor();
    int i;

    for (i = 0; i < getThickness(); i++) {
      if (_leftColor != null) {
        g.setColor(_leftColor);
        g.drawLine(x + i, y, x + i, height - 1);
      }
      if (_topColor != null) {
        g.setColor(_topColor);
        g.drawLine(x, y + i, width - 1, y + i);
      }
      if (_rightColor != null) {
        g.setColor(_rightColor);
        g.drawLine(width - i - 1, y, width - i - 1, height - 1);
      }
      if (_bottomColor != null) {
        g.setColor(_bottomColor);
        g.drawLine(x, height - i - 1, width - 1, height - i - 1);
      }
    }
    g.setColor(oldColor);
  }

}
