/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.icon;

import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

/**
 * The Class EmptyIcon.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class EmptyIcon implements Icon {
  /** The Constant ICON_16. */
  public static final Icon ICON_16 = new EmptyIcon(16);
  
  private int _width;
  private int _height;
  
  /**
   * Instantiates a new empty icon.
   *
   * @param size int
   */
  public EmptyIcon(int size) {
    _width = size;
    _height = size;
  }

  /**
   * Instantiates a new empty icon.
   *
   * @param width int
   * @param height int
   */
  public EmptyIcon(int width, int height) {
    _width = width;
    _height = height;
  }

  /**
   * Gets the icon height.
   *
   * @return the icon height
   * @see javax.swing.Icon#getIconHeight()
   */
  @Override
  public int getIconHeight() {
    return _height;
  }

  /**
   * Gets the icon width.
   *
   * @return the icon width
   * @see javax.swing.Icon#getIconWidth()
   */
  @Override
  public int getIconWidth() {
    return _width;
  }

  /**
   * Paint icon.
   *
   * @param c the Component
   * @param g the Graphics
   * @param x the x
   * @param y the y
   * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics, int, int)
   */
  @Override
  public void paintIcon(Component c, Graphics g, int x, int y) {
    //empty
  }
}
