/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.plaf;

import java.awt.Graphics;
import java.awt.Rectangle;

import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;

import jnpad.GUIUtilities;
import jnpad.ui.toolbar.ToolBarToggleButton;

/**
 * The Class JNPadToggleButtonUI.
 *
 * @version 0.3
 * @since jNPad 0.1
 */
public final class JNPadToggleButtonUI extends MetalToggleButtonUI {
  /** The Constant INSTANCE. */
  private static final JNPadToggleButtonUI INSTANCE = new JNPadToggleButtonUI();

  /**
   * 
   * @param c JComponent
   * @return ComponentUI
   */
  public static ComponentUI createUI(JComponent c) {
    if (c instanceof ToolBarToggleButton) {
      return JNPadToolBarButtonUI.createUI(c);
    }
    return INSTANCE;
  }
  
  /**
   * 
   * @param g Graphics
   * @param b AbstractButton
   * @param textRect Rectangle
   * @param text String
   */
  @Override
  protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
    GUIUtilities.setRenderingHints(g);
    super.paintText(g, (JComponent) b, textRect, text);
  }

}
