/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.status;

/**
 * The Interface StatusDisplayable.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public interface StatusDisplayable {
  /** The Constant TIMEOUT_NONE. */
  int TIMEOUT_NONE    = 0;

  /** The Constant TIMEOUT_DEFAULT. */
  int TIMEOUT_DEFAULT = 10;
  
  /**
   * The Enum StatusType.
   */
  enum StatusType {
    SIMPLE,
    ERROR,
    WARNING,
    INFORMATION
  }

  /**
   *
   */
  void clearStatus();

  /**
   * 
   * @param text String
   */
  void setStatus(String text);

  /**
   * 
   * @param text String
   * @param timeout_sec int
   */
  void setStatus(String text, int timeout_sec);

  /**
   * Sets the status.
   *
   * @param type the type
   * @param text the text
   */
  void setStatus(StatusType type, String text);

  /**
   * Sets the status.
   *
   * @param type the type
   * @param text the text
   * @param timeout_sec the timeout_sec
   */
  void setStatus(StatusType type, String text, int timeout_sec);

  /**
   * 
   * @return String
   */
  String getStatus();

}
