/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.FaceBoard;
import com.jthomas.javafaces.FaceCache;
import com.jthomas.javafaces.FaceEvent;
import com.jthomas.javafaces.FaceEventListener;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.FaceSelect;
import com.jthomas.javafaces.JavaFaces;
import com.jthomas.javafaces.Mailmsg;
import com.jthomas.javafaces.PiconDB;
import com.jthomas.javafaces.PromptCheck;
import com.jthomas.util.Debug;
import com.jthomas.util.Queue;

public class FaceResolver
implements Runnable {
    private JavaFaces _JavaFaces;
    private FaceOptions _Options;
    private FaceCache _Cache;
    private FaceSelect _Select;
    private FaceSelect _SelectAfter;
    private FaceSelect _KillSelect;
    private PiconDB _PiconDB;
    private boolean _PIconDBDomainOnly = false;
    private String _DefaultImageURL;
    private String _KillImageURL;
    private String _BuildImageURL;
    private Queue _Queue;
    private FaceBoard _FaceBoard;

    public FaceResolver() {
        Debug.out("FaceResolver()");
        this._JavaFaces = JavaFaces.getRef();
        this._Options = this._JavaFaces.getFaceOptionsRef();
        this.refreshOptions();
        this._JavaFaces.addFaceEventListener(new 1());
        this._Queue = new Queue();
        Debug.out("FaceResolver() done");
    }

    public void queuePut(Object obj) {
        this._Queue.put(obj);
    }

    public void run() {
        try {
            Debug.out("FaceResolver.run()");
            this._PiconDB = this._JavaFaces.getPiconDBRef();
            this._FaceBoard = this._JavaFaces.getFaceBoardRef();
            this._Cache = this._JavaFaces.getCacheRef();
            do {
                Mailmsg mailmsg = (Mailmsg)this._Queue.get();
                boolean resolved = false;
                if (mailmsg.getAction() == 5) {
                    Debug.out("FaceResolver.run() dequeue mailmsg ActionResolve " + mailmsg.getKey());
                    resolved = this.resolve(mailmsg, true, this._PIconDBDomainOnly);
                    if (resolved) {
                        this.processSelection(mailmsg, true, this._PIconDBDomainOnly);
                        this._FaceBoard.queuePut(mailmsg);
                        continue;
                    }
                    Debug.out("FaceResolver.run() queue mailmsg " + mailmsg.getKey() + " for PiconDB");
                    mailmsg.setAction(7);
                    this._PiconDB.queuePut(mailmsg);
                    continue;
                }
                Debug.out("FaceResolver.run() dequeue mailmsg ActionResolveAfter " + mailmsg.getKey());
                resolved = this.resolveAfter(mailmsg, true, this._PIconDBDomainOnly);
                if (resolved) {
                    this.processSelection(mailmsg, true, this._PIconDBDomainOnly);
                    this._FaceBoard.queuePut(mailmsg);
                    continue;
                }
                Debug.out("UnResolved mail ????????????????");
            } while (!this._JavaFaces._FlagQuitMail);
        }
        catch (Exception e) {
            Debug.out("FaceResolver: Exception in run(); ", e);
        }
        catch (Error e) {
            Debug.out("FaceResolver: Error in run(); ", e);
        }
        Debug.out("FaceResolver terminating Thread");
        System.exit(1);
    }

    private void processSelection(Mailmsg mailmsg, boolean usecache, boolean domainonly) {
        String imageurl = mailmsg.getImageURL();
        String audiourl = mailmsg.getAudioURL();
        Debug.out("Selected: imageurl='" + imageurl + "'  audiourl='" + audiourl + "'");
        if (this._Cache != null && !imageurl.startsWith("file")) {
            String newurl = null;
            if (usecache) {
                newurl = this._Cache.getURL(imageurl);
            }
            if (newurl == null) {
                newurl = this._Cache.cacheImage(imageurl, null, null);
            }
            if (newurl != null) {
                Debug.out("Use " + newurl + " for " + imageurl);
                imageurl = newurl;
            }
        }
        if (audiourl != null && audiourl.length() > 0 && this._JavaFaces._FlagAudio) {
            this._JavaFaces.getFaceAudioRef().queuePut(audiourl);
        }
    }

    public boolean resolve(Mailmsg mailmsg, boolean usecache, boolean domainonly) {
        String imageurl = null;
        String audiourl = null;
        int selected = this._Select.selectImage(mailmsg);
        if (selected >= 0) {
            imageurl = this._Select.getImageURL(selected);
            audiourl = this._Select.getAudioURL(selected);
        } else {
            selected = this._KillSelect.selectImage(mailmsg);
            if (selected >= 0) {
                mailmsg.setKillCandidate(true);
                imageurl = this._KillSelect.getImageURL(selected);
                audiourl = null;
                if (imageurl == null) {
                    imageurl = this._KillImageURL;
                } else if (imageurl.toUpperCase().equals("AUTODELETE")) {
                    mailmsg.setDeleteFlag(true);
                    Debug.out("Mailmsg will be deleted on next pass");
                    imageurl = this._KillImageURL;
                    return false;
                }
            }
        }
        if (imageurl != null) {
            mailmsg.setImageURL(imageurl);
            mailmsg.setAudioURL(audiourl);
            return true;
        }
        return false;
    }

    private boolean resolveAfter(Mailmsg mailmsg, boolean usecache, boolean domainonly) {
        String imageurl = null;
        String audiourl = null;
        int selected = this._SelectAfter.selectImage(mailmsg);
        if (selected >= 0) {
            imageurl = this._SelectAfter.getImageURL(selected);
            audiourl = this._SelectAfter.getAudioURL(selected);
        }
        if (imageurl == null) {
            imageurl = mailmsg.getPiconImageURL();
            if (imageurl == null && this._BuildImageURL != null && mailmsg.getHeader("From").length() != 0) {
                Debug.out("Build icon for " + mailmsg.getHeader("From"));
                imageurl = this._BuildImageURL;
                mailmsg.setBuildIcon(true);
            }
            if (imageurl == null) {
                imageurl = this._DefaultImageURL;
            }
        }
        if (audiourl == null || audiourl.length() == 0) {
            audiourl = null;
        }
        if (imageurl != null) {
            mailmsg.setImageURL(imageurl);
            mailmsg.setAudioURL(audiourl);
            return true;
        }
        return false;
    }

    public void refreshOptions() {
        Debug.out("FaceResolver:refreshOptions()");
        this.selectSetup();
        this._PIconDBDomainOnly = this._Options.get("PIconDBDomainOnly", "true").equalsIgnoreCase("TRUE");
        this._DefaultImageURL = this._Options.get("DefaultImageURL", null);
        this._KillImageURL = this._Options.get("KillImageURL", null);
        this._BuildImageURL = this._Options.get("BuildImageURL", null);
    }

    private void selectSetup() {
        this._Select = new FaceSelect("Select");
        this._SelectAfter = new FaceSelect("SelectAfter");
        this._KillSelect = new FaceSelect("KillSelect");
        this._Select.setup();
        this._SelectAfter.setup();
        this._KillSelect.setup();
    }

    public void checkAddress() {
        Debug.out("checkAddress():");
        PromptCheck cd = (PromptCheck)PromptCheck.create();
        cd.setCheckDefaults("", false, false);
        cd.show();
        if (cd.getStatus() == 2) {
            boolean usecache = cd.getUseCache();
            boolean domainonly = cd.getDomainOnly();
            Mailmsg mailmsg = cd.getMailmsg();
            mailmsg.setAction(10);
            boolean resolved = this.resolve(mailmsg, usecache, domainonly);
            if (resolved) {
                this.processSelection(mailmsg, usecache, domainonly);
                this._FaceBoard.queuePut(mailmsg);
            } else {
                resolved = this._JavaFaces.getPiconDBRef().resolvePiconDB(mailmsg, usecache, domainonly);
                if (resolved) {
                    if (mailmsg.getImageURL() != null) {
                        this.processSelection(mailmsg, usecache, domainonly);
                        this._FaceBoard.queuePut(mailmsg);
                    }
                } else {
                    resolved = this.resolveAfter(mailmsg, usecache, domainonly);
                    if (resolved) {
                        this.processSelection(mailmsg, usecache, domainonly);
                        this._FaceBoard.queuePut(mailmsg);
                    } else {
                        Debug.out("FaceResolver.run(): Unresloved mailmsg " + mailmsg.getKey());
                    }
                }
            }
        }
    }

    private final class 1
    implements FaceEventListener {
        public void actionPerformed(FaceEvent e) {
            if (e.getID() == 20) {
                FaceResolver.this.refreshOptions();
            }
        }

        /* synthetic */ 1() {
        }
    }
}

