/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.DecodeBIT;
import j51.intel.DecodeCODE16;
import j51.intel.DecodeDATA12;
import j51.intel.DecodeDATA16;
import j51.intel.DecodeDATA8;
import j51.intel.DecodeDIRECM;
import j51.intel.DecodeDIRECP;
import j51.intel.DecodeDIRECT;
import j51.intel.DecodeOFFSET;
import j51.intel.DecodeString;
import j51.intel.MCS51;
import j51.intel.MCS51Opcode;
import j51.util.FastArray;
import j51.util.Hex;

public abstract class AbstractMCS51Opcode
implements MCS51Opcode {
    private String decoded = null;
    protected int length;
    protected String description;
    protected int opcode;
    private int cycle;
    private static FastArray<DecodeString> decoders = null;

    AbstractMCS51Opcode(int n, int n2, int n3, String string) {
        this.opcode = n;
        this.length = n2;
        this.cycle = n3;
        this.description = string;
        if (decoders == null) {
            decoders = new FastArray();
            decoders.add(new DecodeDATA12());
            decoders.add(new DecodeDATA16());
            decoders.add(new DecodeCODE16());
            decoders.add(new DecodeDATA8());
            decoders.add(new DecodeOFFSET());
            decoders.add(new DecodeDIRECT());
            decoders.add(new DecodeDIRECP());
            decoders.add(new DecodeDIRECM());
            decoders.add(new DecodeBIT());
        }
    }

    @Override
    public final int getOpcode() {
        return this.opcode;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final int getCycle() {
        return this.cycle;
    }

    @Override
    public final String decode(MCS51 mCS51, int n) {
        int n2;
        if (this.decoded != null) {
            return this.decoded;
        }
        StringBuffer stringBuffer = new StringBuffer(Hex.bin2word(n) + " ");
        for (n2 = 0; n2 < 3; ++n2) {
            if (n2 < this.getLength()) {
                stringBuffer.append(Hex.bin2byte(mCS51.code(n + n2)) + " ");
                continue;
            }
            stringBuffer.append("   ");
        }
        stringBuffer.append(this.getDescription());
        n2 = mCS51.code(n);
        int n3 = n + this.getLength();
        ++n;
        boolean bl = false;
        while (true) {
            DecodeString decodeString;
            int n4 = -1;
            int n5 = stringBuffer.length();
            int n6 = decoders.size();
            while (--n6 >= 0) {
                decodeString = decoders.get(n6);
                int n7 = decodeString.search(stringBuffer);
                if (n7 == -1 || n7 >= n5) continue;
                n5 = n7;
                n4 = n6;
            }
            if (n4 < 0) break;
            decodeString = decoders.get(n4);
            n += decodeString.decode(mCS51, n2, n3, n, stringBuffer, n5);
            bl = true;
        }
        if (!bl) {
            this.decoded = stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    @Override
    public final String getDescription() {
        String string = this.toString();
        int n = string.indexOf(9);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        while (string2.length() < 6) {
            string2 = string2 + " ";
        }
        string2 = string2 + string.substring(n + 1);
        return string2;
    }
}

