/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.AbstractInterruptSource;
import j51.intel.MCS51;
import j51.intel.MCS51Constants;
import j51.intel.MCS51Peripheral;
import j51.intel.MachineCyclesListener;
import j51.intel.SfrReadListener;
import j51.intel.SfrWriteListener;
import j51.util.Hex;

public class Timer
implements MCS51Peripheral,
MachineCyclesListener,
MCS51Constants {
    private MCS51 cpu;
    private SingleTimer timer0 = new SingleTimer(0);
    private SingleTimer timer1 = new SingleTimer(1);

    @Override
    public void registerCpu(MCS51 mCS51) {
        this.cpu = mCS51;
        mCS51.addMachineCycleListener(this);
        this.timer0.registerCpu(mCS51);
        this.timer1.registerCpu(mCS51);
    }

    @Override
    public final void cycles(int n) {
        this.timer0.cycle(n);
        this.timer1.cycle(n);
    }

    class SingleTimer
    extends AbstractInterruptSource
    implements MCS51Constants {
        private MCS51 cpu;
        private int tconShift;
        private int tmodShift;
        private int TH;
        private int TL;
        private int TF;
        private int ET;
        private int timer;
        private int tcon;
        private int tmod;

        SingleTimer(int n) {
            super(11 + n * 16);
            this.tconShift = 2 * n;
            this.tmodShift = 4 * n;
            this.TH = 140 + n;
            this.TL = 138 + n;
            this.TF = 32 << this.tconShift;
            this.ET = n == 0 ? 2 : 8;
            this.timer = n;
        }

        void registerCpu(MCS51 mCS51) {
            this.cpu = mCS51;
            mCS51.addInterruptSource(168, this, "TIMER" + this.timer);
            mCS51.addInterruptSource(136, this, "TIMER" + this.timer);
            mCS51.addSfrWriteListener(136, new SfrWriteListener(){

                @Override
                public void sfrWrite(int n, int n2) {
                    SingleTimer.this.tcon = n2 >> SingleTimer.this.tconShift;
                }
            });
            mCS51.addSfrWriteListener(137, new SfrWriteListener(){

                @Override
                public void sfrWrite(int n, int n2) {
                    SingleTimer.this.tmod = n2 >> SingleTimer.this.tmodShift;
                }
            });
            mCS51.addSfrReadListener(140 + this.timer, new SfrReadListener(){

                @Override
                public int sfrRead(int n) {
                    return SingleTimer.this.TH;
                }
            });
            mCS51.addSfrWriteListener(140 + this.timer, new SfrWriteListener(){

                @Override
                public void sfrWrite(int n, int n2) {
                    SingleTimer.this.TH = n2;
                }
            });
            mCS51.addSfrReadListener(138 + this.timer, new SfrReadListener(){

                @Override
                public int sfrRead(int n) {
                    return SingleTimer.this.TL;
                }
            });
            mCS51.addSfrWriteListener(138 + this.timer, new SfrWriteListener(){

                @Override
                public void sfrWrite(int n, int n2) {
                    SingleTimer.this.TL = n2;
                }
            });
        }

        final void cycle(int n) {
            if ((this.tcon & 0x10) == 0) {
                return;
            }
            switch (this.tmod & 3) {
                case 0: {
                    int n2 = this.TL + n;
                    this.TL = n2 & 0x1F;
                    if (n2 <= 31) break;
                    this.TH = this.TH + 1 & 0xFF;
                    if (this.TH != 0) break;
                    this.cpu.sfrSet(136, this.TF);
                    break;
                }
                case 1: {
                    int n3 = this.TL + n;
                    this.TL = n3 & 0xFF;
                    if (n3 <= 255) break;
                    this.TH = this.TH + 1 & 0xFF;
                    if (this.TH != 0) break;
                    this.cpu.sfrSet(136, this.TF);
                    break;
                }
                case 2: {
                    int n4 = this.TL;
                    while (n-- > 0) {
                        if ((n4 = n4 + 1 & 0xFF) != 0) continue;
                        n4 = this.TL = this.TH;
                        this.cpu.sfrSet(136, this.TF << this.tconShift);
                    }
                    this.TL = n4;
                }
            }
        }

        @Override
        public void interruptStart() {
            this.cpu.sfrReset(136, this.TF);
        }

        @Override
        public boolean interruptCondition() {
            return (this.cpu.sfr(168) & this.ET) != 0 && (this.cpu.sfr(136) & this.TF) != 0;
        }

        public String toString() {
            return "Timer" + this.timer + " at " + Hex.bin2word(this.vector);
        }
    }
}

