/*
 * Decompiled with CFR 0.152.
 */
package j51.philips;

import j51.intel.FlashCode;
import j51.intel.JUart;
import j51.intel.MCS51;
import j51.intel.MemoryReadListener;
import j51.intel.MemoryWriteListener;
import j51.intel.PersistentMemory;
import j51.intel.SfrWriteListener;
import j51.intel.Timer;
import j51.philips.LPC764Constants;

public class LPC764Base
extends MCS51
implements LPC764Constants,
SfrWriteListener,
MemoryReadListener,
MemoryWriteListener {
    private PersistentMemory eeprom;
    public static final int EEPROM_START = 64512;
    public static final int EEPROM_SIZE = 1024;
    public static final int EEPROM_UCFG1 = 64768;
    public static final int EEPROM_UCFG2 = 64769;

    public LPC764Base(String string) {
        super(6000000);
        this.machineCycle = 6;
        this.addSfrWriteListener(162, this);
        this.eeprom = new PersistentMemory(string, "eeprom", 768);
        FlashCode flashCode = new FlashCode(string, 4096);
        this.setCode(flashCode);
        for (int i = 0; i < 1024; ++i) {
            flashCode.addMemoryWriteListener(64512 + i, this);
            flashCode.addMemoryReadListener(64512 + i, this);
        }
        this.addPeripheral(new JUart());
        this.addPeripheral(new Timer());
        this.setSfrName(162, "AUXR1");
    }

    @Override
    public void writeMemory(int n, int n2, int n3) {
        this.eeprom.write(n -= 64512, n2);
    }

    @Override
    public int readMemory(int n, int n2) {
        return this.eeprom.read(n -= 64512);
    }

    @Override
    public void sfrWrite(int n, int n2) {
        switch (n) {
            case 162: {
                this.sfr(162, n2 &= 0xFB);
                this.swapDptr(n2 & 1);
                if ((n2 & 8) == 0) break;
                this.reset();
            }
        }
    }

    @Override
    public String toString() {
        return "LPC764 $Id: LPC764Base.java 56 2010-06-24 20:06:35Z mviara $";
    }
}

