/*
 * Decompiled with CFR 0.152.
 */
package j51.philips;

import j51.intel.FlashCode;
import j51.intel.JUart;
import j51.intel.MCS51;
import j51.intel.Memory;
import j51.intel.MemoryReadListener;
import j51.intel.MemoryWriteListener;
import j51.intel.PersistentMemory;
import j51.intel.SfrWriteListener;
import j51.intel.Timer;
import j51.philips.LPC900Constants;
import j51.philips.LPC900Misc;
import j51.philips.LPC900Ports;
import j51.philips.LPC900WDT;
import j51.util.Logger;

public class LPC900
extends MCS51
implements SfrWriteListener,
LPC900Constants,
MemoryReadListener,
MemoryWriteListener {
    private static Logger log = Logger.getLogger(LPC900.class);
    private byte[] flashBuffer;
    private int flashCounter;
    private Memory eeprom;
    private FlashCode flash;
    private boolean eepromWrite = false;
    private PersistentMemory misc;

    public LPC900() throws Exception {
        this("LPC900");
    }

    public LPC900(String string) throws Exception {
        this(string, 8192);
    }

    public LPC900(String string, int n) throws Exception {
        super(0x708000);
        int n2;
        this.machineCycle = 2;
        this.eeprom = new PersistentMemory(string, "eeprom", 512);
        this.misc = new PersistentMemory(string, "misc", 32);
        this.flash = new FlashCode(string, n);
        this.flashBuffer = new byte[64];
        this.setCode(this.flash);
        this.setXdataSize(512);
        for (n2 = 0; n2 < 16; ++n2) {
            this.flash.addMemoryReadListener(65520 + n2, this);
            this.flash.addMemoryWriteListener(65520 + n2, this);
        }
        if (!this.misc.isLoaded()) {
            this.misc.write(0, 99);
            this.misc.write(2, 31);
            this.misc.write(3, 1);
            for (n2 = 0; n2 < 8; ++n2) {
                this.misc.write(8 + n2, 0);
            }
        }
        this.addPeripheral(new Timer());
        this.addPeripheral(new LPC900Misc());
        this.addPeripheral(new LPC900Ports());
        this.addPeripheral(new JUart());
        this.addPeripheral(new LPC900WDT());
        this.addSfrWriteListener(228, this);
        this.addSfrWriteListener(229, this);
        this.addSfrWriteListener(242, this);
        this.addSfrWriteListener(243, this);
        this.addSfrWriteListener(162, this);
        this.setSfrName(229, "FMDATA");
        this.setSfrName(228, "FMCON");
        this.setSfrName(230, "FMADRL");
        this.setSfrName(231, "FMADRH");
        this.setSfrName(241, "DEECON");
        this.setSfrName(242, "DEEDAT");
        this.setSfrName(243, "DEEADR");
        this.setSfrName(162, "AUXR1");
    }

    @Override
    public void writeMemory(int n, int n2, int n3) {
        this.flash.write(n - 65520, n2);
    }

    @Override
    public int readMemory(int n, int n2) {
        return this.flash.read(n - 65520);
    }

    int miscRead(int n) {
        return this.misc.read(n);
    }

    void miscWrite(int n, int n2) {
        this.misc.write(n, n2);
    }

    @Override
    public void reset() {
        super.reset();
        if ((this.miscRead(3) & 1) != 0) {
            this.pc(this.miscRead(2) << 8);
        }
        this.sfrWrite(228, 112);
    }

    @Override
    public void sfrWrite(int n, int n2) {
        block0 : switch (n) {
            case 162: {
                this.sfr(162, n2 &= 0xFFFFFFFD);
                this.swapDptr(n2 & 1);
                if ((n2 & 8) == 0) break;
                this.reset();
                break;
            }
            case 242: {
                this.eepromWrite = true;
                break;
            }
            case 243: {
                int n3 = n2 + (this.sfr(241) & 1) * 256;
                if (this.eepromWrite) {
                    this.eeprom.write(n3, this.sfr(242));
                } else {
                    this.sfr(242, this.eeprom.read(n3));
                }
                this.sfr(241, this.sfr(241) | 0x80);
                this.eepromWrite = false;
                break;
            }
            case 229: {
                this.flashBuffer[this.flashCounter++] = (byte)n2;
                break;
            }
            case 228: {
                switch (n2) {
                    case 0: {
                        this.flashCounter = 0;
                        break block0;
                    }
                    case 104: {
                        int n4 = this.sfr(230) + this.sfr(231) * 256;
                        for (int i = 0; i < this.flashCounter; ++i) {
                            this.code(n4 + i, this.flashBuffer[i]);
                        }
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return "Philips 89LPC900 $Id: LPC900.java 74 2010-07-07 05:50:03Z mviara $";
    }
}

