/*
 * Decompiled with CFR 0.152.
 */
package j51.swing;

import j51.swing.JFactory;
import j51.swing.UpdatableComponent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JBitField
extends JPanel
implements ActionListener,
UpdatableComponent {
    private JCheckBox[] bits = new JCheckBox[8];
    private Vector listeners = new Vector();
    private int oldValue = -1;
    private int value;
    private static Vector fields = null;

    public JBitField(String string) {
        this(string, true);
    }

    public JBitField(String string, boolean bl) {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        for (int i = 0; i < 8; ++i) {
            String string2 = "" + (7 - i);
            gridBagConstraints.gridy = 0;
            if (bl) {
                this.add((Component)new JLabel(string2), gridBagConstraints);
                gridBagConstraints.gridy = 1;
            }
            this.bits[7 - i] = new JCheckBox();
            this.bits[7 - i].setMargin(new Insets(0, 0, 0, 0));
            this.bits[7 - i].addActionListener(this);
            this.bits[7 - i].setToolTipText(string2);
            this.add((Component)this.bits[7 - i], gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        JFactory.setTitle(this, string);
        this.setValue(0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.listeners.elementAt(i);
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void setBitName(int n, String string) {
        this.bits[n].setToolTipText(string);
    }

    public void setDisabled(int n, boolean bl) {
        this.bits[n].setEnabled(!bl);
    }

    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public boolean update() {
        if (this.value == this.oldValue) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            boolean bl;
            boolean bl2 = this.bits[i].isSelected();
            boolean bl3 = bl = (this.value & 1 << i) != 0;
            if (bl2 == bl) continue;
            this.bits[i].setSelected(bl);
        }
        this.oldValue = this.value;
        return true;
    }

    public int getValue() {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            if (!this.bits[i].isSelected()) continue;
            n |= 1 << i;
        }
        return n;
    }

    public void setEditable(boolean bl) {
        for (int i = 0; i < 8; ++i) {
            this.bits[i].setEnabled(bl);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }
}

