/*
 * Decompiled with CFR 0.152.
 */
package agjava.mp3;

final class BinParser {
    private static final int NUM_BYTES = 4;
    private static final int NUM_BITS = 8;
    private static final int SYNCHSAFE_BITS = 7;

    BinParser() {
    }

    public static boolean bitSet(byte by, int n) {
        boolean bl = false;
        if (n >= 0 && n < 8) {
            bl = (by & (byte)(1 << n)) != 0;
        }
        return bl;
    }

    public static byte[] convertToBytes(int n) {
        byte[] byArray = new byte[4];
        int n2 = n;
        boolean bl = false;
        int n3 = byArray.length - 1;
        while (n3 >= 0 && !bl) {
            int n4 = 0;
            while (n4 < 8 && !bl) {
                if (n2 % 2 == 1) {
                    byArray[n3] = BinParser.setBit(byArray[n3], n4);
                }
                bl = (n2 /= 2) == 0;
                ++n4;
            }
            --n3;
        }
        return byArray;
    }

    public static int convertToDecimal(byte by, int n, int n2) {
        byte by2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n2;
        if (n < 0 || n >= 8) {
            n4 = 0;
        }
        if (n2 < 0 || n2 >= 8) {
            n5 = 7;
        }
        if (n > n2) {
            n4 = n2;
            n5 = n;
        }
        int n6 = n4;
        while (n6 <= n5) {
            if (BinParser.bitSet(by, n6)) {
                by2 = BinParser.setBit(by2, n3);
            }
            ++n3;
            ++n6;
        }
        return by2;
    }

    public static int convertToInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length - 1;
        if (n3 >= 4) {
            n3 = 3;
        }
        int n4 = n3;
        while (n4 >= 0) {
            int n5 = 0;
            while (n5 < 8) {
                if (BinParser.bitSet(byArray[n4], n5)) {
                    n = (int)((double)n + Math.pow(2.0, n2));
                }
                ++n2;
                ++n5;
            }
            --n4;
        }
        return n;
    }

    public static byte[] convertToSynchsafeBytes(int n) {
        byte[] byArray = new byte[4];
        int n2 = n;
        boolean bl = false;
        int n3 = byArray.length - 1;
        while (n3 >= 0 && !bl) {
            int n4 = 0;
            while (n4 < 7 && !bl) {
                if (n2 % 2 == 1) {
                    byArray[n3] = BinParser.setBit(byArray[n3], n4);
                }
                bl = (n2 /= 2) == 0;
                ++n4;
            }
            --n3;
        }
        return byArray;
    }

    public static int convertToSynchsafeInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length - 1;
        if (n3 >= 4) {
            n3 = 3;
        }
        int n4 = n3;
        while (n4 >= 0) {
            int n5 = 0;
            while (n5 < 7) {
                if (BinParser.bitSet(byArray[n4], n5)) {
                    n = (int)((double)n + Math.pow(2.0, n2));
                }
                ++n2;
                ++n5;
            }
            --n4;
        }
        return n;
    }

    public static boolean matchPattern(byte by, String string) {
        boolean bl = true;
        int n = 0;
        while (n < 8 && n < string.length() && bl) {
            if (string.charAt(n) == '1') {
                bl = bl && BinParser.bitSet(by, 8 - n - 1);
            } else if (string.charAt(n) == '0') {
                bl = bl && !BinParser.bitSet(by, 8 - n - 1);
            }
            ++n;
        }
        return bl;
    }

    public static byte setBit(byte by, int n) {
        byte by2 = 0;
        if (n >= 0 && n < 8) {
            by2 = (byte)(by | (byte)(1 << n));
        }
        return by2;
    }
}

