/*
 * Decompiled with CFR 0.152.
 */
package com.be.swing.plaf.beos;

import com.be.swing.plaf.beos.BeOSLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class BeOSBorders {

    static class ProgressBarBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (component.isEnabled()) {
                this.drawBorder(component, graphics, n3, n4);
            } else {
                this.drawDisabledBorder(component, graphics, n3, n4);
            }
            graphics.translate(-n, -n2);
        }

        public void drawBorder(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BeOSLookAndFeel.getGray189());
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.setColor(BeOSLookAndFeel.getWhite());
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, n - 1, 1);
            graphics.setColor(BeOSLookAndFeel.getGray99());
            graphics.drawLine(1, 1, n - 2, 1);
            graphics.drawLine(1, 1, 1, n2 - 2);
            graphics.setColor(BeOSLookAndFeel.getGray222());
            graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, n2 - 2, n - 2, 2);
        }

        public void drawDisabledBorder(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BeOSLookAndFeel.getGray222());
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.setColor(BeOSLookAndFeel.getGray239());
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, n - 1, 1);
            graphics.setColor(BeOSLookAndFeel.getGray156());
            graphics.drawLine(1, 1, n - 2, 1);
            graphics.drawLine(1, 1, 1, n2 - 2);
            graphics.setColor(BeOSLookAndFeel.getGray222());
            graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, n2 - 2, n - 2, 2);
        }

        public Insets getBorderInsets(Component component) {
            return BeOSLookAndFeel.getZeroInsets();
        }

        ProgressBarBorder() {
        }
    }

    static class TextComponentBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (component.isEnabled()) {
                this.drawBorder(component, graphics, n3, n4);
            } else {
                this.drawDisabledBorder(component, graphics, n3, n4);
            }
            graphics.translate(-n, -n2);
        }

        public void drawBorder(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BeOSLookAndFeel.getGray189());
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.setColor(BeOSLookAndFeel.getWhite());
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, n - 1, 1);
            JComponent jComponent = (JComponent)component;
            if (jComponent.hasFocus()) {
                graphics.setColor(BeOSLookAndFeel.getBlue());
                graphics.drawLine(1, 1, n - 2, 1);
                graphics.drawLine(1, 1, 1, n2 - 2);
                graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
                graphics.drawLine(n - 2, n2 - 2, n - 2, 2);
            } else {
                graphics.setColor(BeOSLookAndFeel.getGray99());
                graphics.drawLine(1, 1, n - 2, 1);
                graphics.drawLine(1, 1, 1, n2 - 2);
                graphics.setColor(BeOSLookAndFeel.getGray222());
                graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
                graphics.drawLine(n - 2, n2 - 2, n - 2, 2);
            }
        }

        public void drawDisabledBorder(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BeOSLookAndFeel.getGray222());
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.setColor(BeOSLookAndFeel.getGray239());
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, n - 1, 1);
            graphics.setColor(BeOSLookAndFeel.getGray156());
            graphics.drawLine(1, 1, n - 2, 1);
            graphics.drawLine(1, 1, 1, n2 - 2);
            graphics.setColor(BeOSLookAndFeel.getGray222());
            graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, n2 - 2, n - 2, 2);
        }

        public Insets getBorderInsets(Component component) {
            return BeOSLookAndFeel.getZeroInsets();
        }

        TextComponentBorder() {
        }
    }

    static class DefaultButtonBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            if (jButton.isDefaultButton()) {
                graphics.translate(n, n2);
                if (buttonModel.isEnabled()) {
                    this.drawDefaultBorder(component, graphics, n3, n4);
                } else {
                    this.drawDisabledDefaultBorder(component, graphics, n3, n4);
                }
                graphics.translate(-n, -n2);
            }
        }

        public void drawDefaultBorder(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BeOSLookAndFeel.getGray99());
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.drawLine(n - 2, n2 - 1, 1, n2 - 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
            graphics.drawLine(0, n2 - 2, 0, 1);
            graphics.setColor(BeOSLookAndFeel.getGray189());
            graphics.drawRect(1, 1, n - 3, n2 - 3);
        }

        public void drawDisabledDefaultBorder(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BeOSLookAndFeel.getGray189());
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.drawLine(n - 2, n2 - 1, 1, n2 - 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
            graphics.drawLine(0, n2 - 2, 0, 1);
        }

        public Insets getBorderInsets(Component component) {
            JButton jButton = (JButton)component;
            if (jButton.isDefaultCapable()) {
                return BeOSLookAndFeel.getDefaultButtonInsets();
            }
            return BeOSLookAndFeel.getZeroInsets();
        }

        DefaultButtonBorder() {
        }
    }

    static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            graphics.translate(n, n2);
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    this.drawPressedBorder(component, graphics, n3, n4);
                } else {
                    this.drawActiveBorder(component, graphics, n3, n4);
                }
            } else {
                this.drawDisabledBorder(component, graphics, n3, n4);
            }
            graphics.translate(-n, -n2);
        }

        private void drawActiveBorder(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BeOSLookAndFeel.getGray99());
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.drawLine(n - 2, n2 - 1, 1, n2 - 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
            graphics.drawLine(0, n2 - 2, 0, 1);
            graphics.setColor(BeOSLookAndFeel.getGray156());
            graphics.drawLine(n - 2, 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, n2 - 2, 2, n2 - 2);
            graphics.setColor(BeOSLookAndFeel.getGray239());
            graphics.drawLine(1, 1, n - 2, 1);
            graphics.drawLine(1, 1, 1, n2 - 2);
            graphics.drawLine(4, n2 - 4, n - 4, n2 - 4);
            graphics.drawLine(n - 4, n2 - 4, n - 4, 4);
            graphics.setColor(BeOSLookAndFeel.getWhite());
            graphics.drawLine(2, 2, n - 3, 2);
            graphics.drawLine(2, 2, 2, n2 - 3);
            graphics.drawLine(3, 3, n - 4, 3);
            graphics.drawLine(3, 3, 3, n2 - 4);
            graphics.setColor(BeOSLookAndFeel.getGray222());
            graphics.drawLine(3, n2 - 3, n - 3, n2 - 3);
            graphics.drawLine(n - 3, n2 - 3, n - 3, 3);
        }

        private void drawPressedBorder(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BeOSLookAndFeel.getGray99());
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.drawLine(n - 2, n2 - 1, 1, n2 - 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
            graphics.drawLine(0, n2 - 2, 0, 1);
            graphics.setColor(BeOSLookAndFeel.getBlack());
            graphics.drawLine(n - 2, 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, n2 - 2, 2, n2 - 2);
            graphics.drawLine(1, 1, n - 2, 1);
            graphics.drawLine(1, 1, 1, n2 - 2);
            graphics.drawLine(4, n2 - 4, n - 4, n2 - 4);
            graphics.drawLine(n - 4, n2 - 4, n - 4, 4);
            graphics.drawLine(2, 2, n - 3, 2);
            graphics.drawLine(2, 2, 2, n2 - 3);
            graphics.drawLine(3, 3, n - 4, 3);
            graphics.drawLine(3, 3, 3, n2 - 4);
            graphics.drawLine(3, n2 - 3, n - 3, n2 - 3);
            graphics.drawLine(n - 3, n2 - 3, n - 3, 3);
        }

        private void drawDisabledBorder(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(BeOSLookAndFeel.getGray156());
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.drawLine(n - 2, n2 - 1, 1, n2 - 1);
            graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
            graphics.drawLine(0, n2 - 2, 0, 1);
            graphics.setColor(BeOSLookAndFeel.getGray239());
            graphics.drawLine(1, 1, n - 2, 1);
            graphics.drawLine(1, 1, 1, n2 - 2);
            graphics.drawLine(4, n2 - 4, n - 4, n2 - 4);
            graphics.drawLine(n - 4, n2 - 4, n - 4, 4);
            graphics.setColor(BeOSLookAndFeel.getWhite());
            graphics.drawLine(2, 2, n - 3, 2);
            graphics.drawLine(2, 2, 2, n2 - 3);
            graphics.drawLine(3, 3, n - 4, 3);
            graphics.drawLine(3, 3, 3, n2 - 4);
            graphics.setColor(BeOSLookAndFeel.getGray222());
            graphics.drawLine(n - 2, 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, n2 - 2, 2, n2 - 2);
            graphics.drawLine(3, n2 - 3, n - 3, n2 - 3);
            graphics.drawLine(n - 3, n2 - 3, n - 3, 3);
        }

        public Insets getBorderInsets(Component component) {
            return BeOSLookAndFeel.getZeroInsets();
        }

        ButtonBorder() {
        }
    }
}

