/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnShapeGenerator;
import napkin.NapkinConstants;
import napkin.RandomValue;

public class DrawnCircleGenerator
extends DrawnShapeGenerator
implements NapkinConstants {
    private final RandomValue startX;
    private final RandomValue startY;
    private final RandomValue endX;
    private final RandomValue endY;
    private final RandomValue tlX;
    private final RandomValue tlY;
    private final RandomValue trX;
    private final RandomValue trY;
    private final RandomValue brX;
    private final RandomValue brY;
    private final RandomValue blX;
    private final RandomValue blY;
    private boolean forFill;
    public static final DrawnCubicLineGenerator INSTANCE = new DrawnCubicLineGenerator();

    public DrawnCircleGenerator() {
        this(false);
    }

    public DrawnCircleGenerator(boolean forFill) {
        this.forFill = forFill;
        this.startX = new RandomValue(50.0, 2.0);
        this.startY = new RandomValue(0.0, 20.0);
        this.endX = new RandomValue(50.0, 2.0);
        this.endY = new RandomValue(0.0, 20.0);
        this.tlX = new RandomValue(0.0);
        this.tlY = new RandomValue(0.0);
        this.trX = new RandomValue(100.0);
        this.trY = new RandomValue(0.0);
        this.brX = new RandomValue(100.0);
        this.brY = new RandomValue(100.0);
        this.blX = new RandomValue(0.0);
        this.blY = new RandomValue(100.0);
    }

    public Shape generate(AffineTransform matrix) {
        GeneralPath circle = new GeneralPath();
        double xStart = this.startX.generate();
        double yStart = this.startY.generate();
        double xEnd = this.forFill ? xStart : this.endX.generate();
        double yEnd = this.forFill ? yStart : this.endY.generate();
        double xTL = this.tlX.generate();
        double yTL = this.tlY.generate();
        double xTR = this.trX.generate();
        double yTR = this.trY.generate();
        double xBR = this.brX.generate();
        double yBR = this.brY.generate();
        double xBL = this.blX.generate();
        double yBL = this.blY.generate();
        double bottomX = xBL + (xBR - xBL) / 2.0;
        double bottomY = yBL + (yBR - yBL) / 2.0;
        double[] coords = new double[]{xStart, yStart, xTR, yTR, xBR, yBR, bottomX, bottomY, bottomX, bottomY, xBL, yBL, xTL, yTL, xEnd, yEnd};
        if (matrix != null) {
            matrix.transform(coords, 0, coords, 0, coords.length / 2);
        }
        CubicCurve2D.Double left = new CubicCurve2D.Double(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], coords[6], coords[7]);
        CubicCurve2D.Double right = new CubicCurve2D.Double(coords[8], coords[9], coords[10], coords[11], coords[12], coords[13], coords[14], coords[15]);
        circle.append(left, false);
        circle.append(right, false);
        return circle;
    }

    public boolean isForFill() {
        return this.forFill;
    }

    public void setForFill(boolean forFill) {
        this.forFill = forFill;
    }

    public RandomValue getBlX() {
        return this.blX;
    }

    public RandomValue getBlY() {
        return this.blY;
    }

    public RandomValue getBrX() {
        return this.brX;
    }

    public RandomValue getBrY() {
        return this.brY;
    }

    public RandomValue getStartX() {
        return this.startX;
    }

    public RandomValue getStartY() {
        return this.startY;
    }

    public RandomValue getEndX() {
        return this.endX;
    }

    public RandomValue getEndY() {
        return this.endY;
    }

    public RandomValue getTlX() {
        return this.tlX;
    }

    public RandomValue getTlY() {
        return this.tlY;
    }

    public RandomValue getTrX() {
        return this.trX;
    }

    public RandomValue getTrY() {
        return this.trY;
    }
}

