/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import napkin.DrawnShapeGenerator;
import napkin.NapkinUtil;
import napkin.RandomValue;

public class DrawnTabGenerator
extends DrawnShapeGenerator {
    private final RandomValue ulX;
    private final RandomValue ulY;
    private final RandomValue urX;
    private final RandomValue urY;
    private final RandomValue lrX;
    private final RandomValue lrY;
    private final RandomValue llX;
    private final RandomValue llY;
    private final RandomValue squeeze;
    private final int side;
    public static final DrawnTabGenerator LEFT_TAB = new DrawnTabGenerator(2);
    public static final DrawnTabGenerator RIGHT_TAB = new DrawnTabGenerator(4);
    public static final DrawnTabGenerator TOP_TAB = new DrawnTabGenerator(1);
    public static final DrawnTabGenerator BOTTOM_TAB = new DrawnTabGenerator(3);
    private static final int[] STARTS = new int[5];
    private static final DrawnTabGenerator[] SIDES;

    public static DrawnTabGenerator generatorFor(int side) {
        if (side <= 0) {
            throw new IndexOutOfBoundsException();
        }
        return SIDES[side];
    }

    private DrawnTabGenerator(int side) {
        this.side = side;
        float shimmy = 0.03f;
        this.ulX = new RandomValue(0.0, shimmy);
        this.ulY = new RandomValue(0.0, shimmy);
        this.urX = new RandomValue(1.0, shimmy);
        this.urY = new RandomValue(0.0, shimmy);
        this.lrX = new RandomValue(1.0, shimmy);
        this.lrY = new RandomValue(1.0, shimmy);
        this.llX = new RandomValue(0.0, shimmy);
        this.llY = new RandomValue(1.0, shimmy);
        if (side == 2 || side == 4) {
            double horizAdj = 10.0;
            this.ulX.setRange((double)shimmy / 10.0);
            this.urX.setRange((double)shimmy / 10.0);
            this.llX.setRange((double)shimmy / 10.0);
            this.lrX.setRange((double)shimmy / 10.0);
        }
        this.squeeze = new RandomValue(0.09, 0.001);
    }

    public Shape generate(AffineTransform matrix) {
        GeneralPath tab = new GeneralPath();
        double xUL = this.ulX.generate();
        double yUL = this.ulY.generate();
        double xUR = this.urX.generate();
        double yUR = this.urY.generate();
        double xLR = this.lrX.generate();
        double yLR = this.lrY.generate();
        double xLL = this.llX.generate();
        double yLL = this.llY.generate();
        switch (this.side) {
            case 2: {
                yUL += this.squeeze.generate();
                yLL -= this.squeeze.generate();
                break;
            }
            case 4: {
                yUR += this.squeeze.generate();
                yLR -= this.squeeze.generate();
                break;
            }
            case 1: {
                xUL += this.squeeze.generate();
                xUR -= this.squeeze.generate();
                break;
            }
            case 3: {
                xLL += this.squeeze.generate();
                xLR -= this.squeeze.generate();
            }
        }
        double[] points = new double[]{xUL, yUL, xUR, yUR, xLR, yLR, xLL, yLL};
        NapkinUtil.transform(matrix, points);
        int start = STARTS[this.side];
        for (int i = 0; i < 4; ++i) {
            if (start >= points.length) {
                start = 0;
            }
            float x = (float)points[start++];
            float y = (float)points[start++];
            if (i == 0) {
                tab.moveTo(x, y);
                continue;
            }
            tab.lineTo(x, y);
        }
        return tab;
    }

    public RandomValue getLLX() {
        return this.llX;
    }

    public RandomValue getLLY() {
        return this.llY;
    }

    public RandomValue getLRX() {
        return this.lrX;
    }

    public RandomValue getLRY() {
        return this.lrY;
    }

    public RandomValue getULX() {
        return this.ulX;
    }

    public RandomValue getULY() {
        return this.ulY;
    }

    public RandomValue getURX() {
        return this.urX;
    }

    public RandomValue getURY() {
        return this.urY;
    }

    static {
        DrawnTabGenerator.STARTS[0] = -1;
        DrawnTabGenerator.STARTS[2] = 4;
        DrawnTabGenerator.STARTS[4] = 0;
        DrawnTabGenerator.STARTS[1] = 6;
        DrawnTabGenerator.STARTS[3] = 2;
        SIDES = new DrawnTabGenerator[5];
        DrawnTabGenerator.SIDES[0] = null;
        DrawnTabGenerator.SIDES[2] = LEFT_TAB;
        DrawnTabGenerator.SIDES[4] = RIGHT_TAB;
        DrawnTabGenerator.SIDES[1] = TOP_TAB;
        DrawnTabGenerator.SIDES[3] = BOTTOM_TAB;
    }
}

