/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.LineBorder;
import javax.swing.plaf.InsetsUIResource;
import napkin.DrawnBoxHolder;
import napkin.NapkinBorder;
import napkin.NapkinConstants;
import napkin.NapkinTheme;
import napkin.NapkinUtil;

public class NapkinBoxBorder
extends NapkinBorder
implements NapkinConstants {
    private static final int BORDER = 3;
    static final Insets DEFAULT_INSETS = new InsetsUIResource(3, 3, 3, 3);
    private static final NapkinUtil.PropertyFactory BOX_FACTORY = new NapkinUtil.PropertyFactory(){

        public Object createPropertyValue() {
            return new DrawnBoxHolder();
        }
    };

    public NapkinBoxBorder() {
        super(new LineBorder(NapkinTheme.Manager.getCurrentTheme().getPenColor()));
    }

    public void doPaintBorder(Component c, Graphics g1, int x, int y, int width, int height) {
        DrawnBoxHolder box = (DrawnBoxHolder)NapkinUtil.getProperty((JComponent)c, "napkin.border", BOX_FACTORY);
        Rectangle passed = new Rectangle(x, y, width, height);
        box.shapeUpToDate(passed);
        Graphics2D g = (Graphics2D)g1;
        g.translate(x, y);
        box.draw(g);
        g.translate(-x, -y);
    }

    public Insets doGetBorderInsets(Component c) {
        return DEFAULT_INSETS;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = 3;
        insets.bottom = 3;
        insets.left = 3;
        insets.top = 3;
        return insets;
    }
}

