/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import napkin.AlphaColorUIResource;
import napkin.ComponentWalker;
import napkin.NapkinBoxBorder;
import napkin.NapkinConstants;
import napkin.NapkinIconFactory;
import napkin.NapkinLineBorder;
import napkin.NapkinSelectedBorder;
import napkin.NapkinTheme;
import napkin.NapkinUtil;

public class NapkinLookAndFeel
extends BasicLookAndFeel
implements NapkinConstants {
    private static boolean JUST_NAPKIN = true;
    private static final String[] UI_TYPES = new String[]{"ButtonUI", "CheckBoxMenuItemUI", "CheckBoxUI", "ColorChooserUI", "ComboBoxUI", "DesktopIconUI", "DesktopPaneUI", "EditorPaneUI", "FileChooserUI", "FormattedTextFieldUI", "InternalFrameUI", "LabelUI", "ListUI", "MenuBarUI", "MenuItemUI", "MenuUI", "OptionPaneUI", "PanelUI", "PasswordFieldUI", "PopupMenuSeparatorUI", "PopupMenuUI", "ProgressBarUI", "RadioButtonMenuItemUI", "RadioButtonUI", "RootPaneUI", "ScrollBarUI", "ScrollPaneUI", "SeparatorUI", "SliderUI", "SpinnerUI", "SplitPaneUI", "TabbedPaneUI", "TableHeaderUI", "TableUI", "TextAreaUI", "TextFieldUI", "TextPaneUI", "ToggleButtonUI", "ToolBarSeparatorUI", "ToolBarUI", "ToolTipUI", "TreeUI", "ViewportUI"};
    private final ComponentWalker.Visitor addListenerVisitor;
    static /* synthetic */ Class class$napkin$NapkinLookAndFeel;
    private final ComponentWalker.Visitor clearKidsVisitor;
    private final Map flags = new WeakHashMap();
    private LookAndFeel formalLAF;
    private final ComponentWalker.Visitor updateUIVisitor;

    public NapkinLookAndFeel() {
        this(UIManager.getLookAndFeel());
    }

    private NapkinLookAndFeel(LookAndFeel formal) {
        this.clearKidsVisitor = new ComponentWalker.Visitor(){

            public boolean visit(Component c, int depth) {
                FormalityFlags ff = NapkinLookAndFeel.this.flags(c);
                System.out.println("clearKidsVisitor " + NapkinUtil.descFor(c) + ": " + ff);
                if (depth == 0) {
                    System.out.println("    depth == 0, return true");
                    return true;
                }
                ff.known = !ff.inherited;
                System.out.println("    return " + ff.inherited);
                return ff.inherited;
            }
        };
        this.updateUIVisitor = new ComponentWalker.Visitor(){

            public boolean visit(Component c, int depth) {
                System.out.println("updateUIVisitor " + NapkinUtil.descFor(c));
                FormalityFlags ff = NapkinLookAndFeel.this.flags(c, false);
                if (depth > 0 && !ff.inherited) {
                    return false;
                }
                if (c instanceof JComponent) {
                    System.out.println("    updateUI");
                    ((JComponent)c).updateUI();
                }
                return true;
            }
        };
        this.addListenerVisitor = new ComponentWalker.Visitor(){

            public boolean visit(Component c, int depth) {
                System.out.println("addListenerVisitor " + NapkinUtil.descFor(c));
                if (!(c instanceof Container) || NapkinLookAndFeel.this.flags.containsKey(c)) {
                    return false;
                }
                FormalityFlags ff = NapkinLookAndFeel.this.flags(c, false);
                ((Container)c).addContainerListener(ff);
                System.out.println("adding listener for " + NapkinUtil.descFor(c) + ", " + System.identityHashCode(c));
                return true;
            }
        };
        this.setFormalLAF(formal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void clear(Component c) {
        System.out.println("clear(" + NapkinUtil.descFor(c) + ")");
        this.clearKids(c);
        FormalityFlags ff = this.flags(c);
        ff.known = !ff.inherited;
    }

    private void clearKids(Component c) {
        new ComponentWalker(c, this.clearKidsVisitor);
        new ComponentWalker(c, this.updateUIVisitor);
    }

    public void dumpFormality(Component top, PrintStream out) {
        new ComponentWalker(top, new DumpVisitor(out));
    }

    private FormalityFlags flags(Component c, boolean recurse) {
        if (JUST_NAPKIN) {
            return null;
        }
        FormalityFlags ff = (FormalityFlags)this.flags.get(c);
        if (ff == null) {
            System.out.println("adding flags: " + NapkinUtil.descFor(c));
            if (recurse && c instanceof Container) {
                new ComponentWalker(c, this.addListenerVisitor);
                ff = (FormalityFlags)this.flags.get(c);
            } else {
                ff = new FormalityFlags();
                this.flags.put(c, ff);
            }
        }
        return ff;
    }

    private FormalityFlags flags(Component c) {
        return this.flags(c, true);
    }

    public String getDescription() {
        String desc = "The Napkin Look and Feel";
        if (this.formalLAF != null) {
            desc = desc + " [backed by " + this.formalLAF.getDescription() + "]";
        }
        return desc;
    }

    public LookAndFeel getFormalLAF() {
        return this.formalLAF;
    }

    public String getID() {
        String desc = "Napkin";
        if (this.formalLAF != null) {
            desc = desc + "[" + this.formalLAF.getID() + "]";
        }
        return desc;
    }

    public String getName() {
        return this.getID();
    }

    private FormalityFlags inhieritedFormal(Container container) {
        System.out.println("inheritedFormal(" + NapkinUtil.descFor(container) + ")");
        if (container == null) {
            return null;
        }
        FormalityFlags ff = this.flags(container);
        System.out.println("    flags = " + ff);
        if (ff.known) {
            return ff;
        }
        FormalityFlags pff = this.inhieritedFormal(container.getParent());
        ff.setFrom(pff);
        return pff;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String basicPackageName = (class$napkin$NapkinLookAndFeel == null ? (class$napkin$NapkinLookAndFeel = NapkinLookAndFeel.class$("napkin.NapkinLookAndFeel")) : class$napkin$NapkinLookAndFeel).getPackage().getName() + ".Napkin";
        int i = 0;
        while (i < UI_TYPES.length) {
            String uiType = UI_TYPES[i];
            String uiClass = basicPackageName + uiType;
            table.put(uiType, uiClass);
            ++i;
        }
        HashSet keys = new HashSet(table.keySet());
        keys.removeAll(Arrays.asList(UI_TYPES));
        if (keys.size() != 0) {
            System.out.println("keys we didn't overwrite: " + keys);
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        this.overrideComponentDefaults(table);
        Integer zero = new Integer(0);
        UIDefaults.ActiveValue checkBoxButtonIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createCheckBoxIcon();
            }
        };
        UIDefaults.ActiveValue radioButtonIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createRadioButtonIcon();
            }
        };
        UIDefaults.ActiveValue underlineBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinLineBorder(null, false);
            }
        };
        UIDefaults.ActiveValue selectBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinSelectedBorder();
            }
        };
        UIDefaults.ActiveValue treeOpenIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(5, 8);
            }
        };
        UIDefaults.ActiveValue treeClosedIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(3, 8);
            }
        };
        UIDefaults.ActiveValue closeIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createXIcon(10);
            }
        };
        UIDefaults.ActiveValue minIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(5, 10);
            }
        };
        this.setupActions(table);
        Object[] napkinDefaults = new Object[]{"RadioButton.textIconGap", zero, "RadioButton.icon", radioButtonIcon, "RadioButtonMenuItem.textIconGap", zero, "RadioButtonMenuItem.checkIcon", radioButtonIcon, "CheckBox.textIconGap", zero, "CheckBox.icon", checkBoxButtonIcon, "CheckBoxMenuItem.textIconGap", zero, "CheckBoxMenuItem.checkIcon", checkBoxButtonIcon, "OptionPane.messageAreaBorder", null, "TabbedPane.contentBorderInsets", NapkinBoxBorder.DEFAULT_INSETS, "Tree.openIcon", treeOpenIcon, "Tree.closedIcon", treeClosedIcon, "Tree.leafIcon", null, "Tree.selectionBorderColor", new Color(86, 46, 0), "Tree.selectionForeground", table.get("textHighlightText"), "Tree.selectionBackground", table.get("textHighlight"), "TextField.border", underlineBorder, "PasswordField.border", underlineBorder, "Menu.border", null, "PopupMenu.border", null, "ToolTip.border", null, "DesktopIcon.border", null, "ToggleButton.border", selectBorder, "InternalFrame.border", new BorderUIResource(new EmptyBorder(3, 3, 3, 3)), "InternalFrame.maximizeIcon", null, "InternalFrame.minimizeIcon", null, "InternalFrame.iconifyIcon", minIcon, "InternalFrame.closeIcon", closeIcon, "SplitPaneDivider.border", null, "SplitPane.dividerSize", new Integer(9)};
        table.putDefaults(napkinDefaults);
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        table.put("textHighlight", theme.getHighlightColor());
        table.put("activeBackground", "#3E91EB");
        table.put("activeBlend", "#3E91EB");
        table.put("activeForeground", "#FFFFFF");
        table.put("activeTitleBtnBg", "#AFD6FF");
        table.put("alternateBackground", "#EEF6FF");
        table.put("background", "#F6F5F4");
        table.put("buttonBackground", "#D7E7F9");
        table.put("buttonForeground", "#000000");
        table.put("foreground", "#000000");
        table.put("inactiveBackground", "#AFD6FF");
        table.put("inactiveBlend", "#AFD6FF");
        table.put("inactiveForeground", "#232323");
        table.put("inactiveTitleBtnBg", "#DAEEFF");
        table.put("linkColor", "#0000C0");
        table.put("selectBackground", "#A9D1FF");
        table.put("selectForeground", "#030303");
        table.put("visitedLinkColor", "#800080");
        table.put("windowBackground", "#FFFFFF");
        table.put("windowForeground", "#000000");
        String[] defaultSystemColors = new String[]{"desktop", (String)table.get("alternateBackground"), "activeCaption", (String)table.get("activeBackground"), "activeCaptionText", (String)table.get("activeForeground"), "activeCaptionBorder", (String)table.get("activeBackground"), "inactiveCaption", (String)table.get("inactiveBackground"), "inactiveCaptionText", (String)table.get("inactiveForeground"), "inactiveCaptionBorder", (String)table.get("inactiveBackground"), "window", (String)table.get("background"), "windowBorder", (String)table.get("windowBackground"), "windowText", (String)table.get("windowForeground"), "menu", (String)table.get("background"), "menuText", (String)table.get("foreground"), "text", (String)table.get("windowBackground"), "textText", (String)table.get("windowForeground"), "textHighlight", (String)table.get("selectBackground"), "textHighlightText", (String)table.get("selectForeground"), "textInactiveText", "#A7A5A3", "control", (String)table.get("background"), "controlText", (String)table.get("buttonForeground"), "controlHighlight", (String)table.get("buttonBackground"), "controlLtHighlight", (String)table.get("selectBackground"), "controlShadow", "#BBBBBB", "controlLightShadow", "#000000", "controlDkShadow", "#000000", "scrollbar", "#000000", "info", (String)table.get("foreground"), "infoText", (String)table.get("foreground")};
        this.loadSystemColors(table, defaultSystemColors, false);
    }

    public void initialize() {
        if (this.formalLAF != null) {
            this.formalLAF.initialize();
        }
    }

    public boolean isFormal(Component c) {
        if (JUST_NAPKIN) {
            return false;
        }
        FormalityFlags ff = this.flags(c);
        System.out.println("isFormal(" + NapkinUtil.descFor(c) + "): " + ff);
        if (ff.known) {
            return ff.formal;
        }
        FormalityFlags pff = this.inhieritedFormal(c.getParent());
        ff.setFrom(pff);
        return ff.formal;
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    private void overrideComponentDefaults(UIDefaults table) {
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        Font dialogPlain = theme.getTextFont();
        Font dialogBold = theme.getBoldTextFont();
        Font serifPlain = theme.getTextFont();
        Font sansSerifPlain = theme.getTextFont();
        Font monospacedPlain = theme.getFixedFont();
        UIDefaults.ActiveValue drawnBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinBoxBorder();
            }
        };
        UIDefaults.ActiveValue compoundBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                NapkinBoxBorder outside = new NapkinBoxBorder();
                BasicBorders.MarginBorder inside = new BasicBorders.MarginBorder();
                CompoundBorder compound = new CompoundBorder(outside, inside);
                return compound;
            }
        };
        AlphaColorUIResource clear = new AlphaColorUIResource(NapkinConstants.CLEAR);
        Iterator it = table.entrySet().iterator();
        while (it.hasNext()) {
            Object val;
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object res = NapkinLookAndFeel.propVal(key, "font", val = entry.getValue(), table);
            if (res != null) {
                if (!(res instanceof FontUIResource)) continue;
                FontUIResource resource = (FontUIResource)res;
                String name = resource.getFontName();
                if (name.equals("Dialog.plain")) {
                    entry.setValue(dialogPlain);
                    continue;
                }
                if (name.equals("Dialog.bold")) {
                    entry.setValue(dialogBold);
                    continue;
                }
                if (name.equals("Serif.plain")) {
                    entry.setValue(serifPlain);
                    continue;
                }
                if (name.equals("SansSerif.plain")) {
                    entry.setValue(sansSerifPlain);
                    continue;
                }
                if (name.equals("MonoSpaced.plain")) {
                    entry.setValue(monospacedPlain);
                    continue;
                }
                System.err.println("unknown font; " + name + " for " + key);
                continue;
            }
            res = NapkinLookAndFeel.propVal(key, "border", val, table);
            if (res != null) {
                if (!(res instanceof UIResource) && (!(val instanceof UIResource) || !(res instanceof BevelBorder) && !(res instanceof EtchedBorder) && !(res instanceof LineBorder) && !(res instanceof CompoundBorder))) continue;
                if (!(res instanceof CompoundBorder)) {
                    entry.setValue(drawnBorder);
                    continue;
                }
                entry.setValue(compoundBorder);
                continue;
            }
            if (key.indexOf("Text") >= 0 || key.startsWith("Password") || key.startsWith("Editor")) continue;
            if (key.endsWith(".foreground") || key.endsWith("BorderColor") || key.endsWith(".textForeground")) {
                entry.setValue(theme.getPenColor());
                continue;
            }
            if (key.endsWith(".background") || key.endsWith(".selectionBackground") || key.endsWith(".textBackground")) {
                entry.setValue(clear);
                continue;
            }
            if (!key.endsWith(".selectionForeground")) continue;
            entry.setValue(theme.getSelectionColor());
        }
    }

    private static Object propVal(String key, String prop, Object val, UIDefaults table) {
        int propLen;
        int keyLen = key.length();
        int prePos = keyLen - (propLen = prop.length()) - 1;
        if (prePos <= 0) {
            return null;
        }
        boolean match = false;
        if (key.endsWith(prop) && key.charAt(prePos) == '.') {
            match = true;
        } else if (key.endsWith(prop.substring(1)) && key.charAt(prePos + 1) == Character.toUpperCase(prop.charAt(0))) {
            match = true;
        }
        if (!match) {
            return null;
        }
        if (val instanceof UIDefaults.ProxyLazyValue) {
            val = ((UIDefaults.ProxyLazyValue)val).createValue(table);
        } else if (val instanceof UIDefaults.ActiveValue) {
            val = ((UIDefaults.ActiveValue)val).createValue(table);
        }
        return val;
    }

    public void provideErrorFeedback(Component component) {
        if (this.formalLAF != null) {
            this.formalLAF.provideErrorFeedback(component);
        } else {
            super.provideErrorFeedback(component);
        }
    }

    private void setFormalLAF(LookAndFeel formalLAF) {
        if (!JUST_NAPKIN) {
            this.formalLAF = formalLAF;
        }
    }

    public void setIsFormal(Component c, boolean isFormal, boolean impose) {
        if (JUST_NAPKIN) {
            return;
        }
        FormalityFlags ff = this.flags(c);
        ff.known = true;
        ff.formal = isFormal;
        ff.inherited = false;
        this.clearKids(c);
    }

    public void setIsFormal(Component c, boolean isFormal) {
        this.setIsFormal(c, isFormal, true);
    }

    private void setupActions(UIDefaults table) {
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        Object[] actionDefaults = new Object[]{"TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", fieldInputMap, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap};
        table.putDefaults(actionDefaults);
    }

    public void uninitialize() {
        if (this.formalLAF != null) {
            this.formalLAF.uninitialize();
        }
    }

    private class FormalityFlags
    implements ContainerListener {
        boolean formal;
        boolean inherited = true;
        boolean known;

        private FormalityFlags() {
        }

        public void componentAdded(ContainerEvent e) {
            Component child = e.getChild();
            System.out.println("Added: " + NapkinUtil.descFor(child) + " to " + e.getComponent());
            NapkinLookAndFeel.this.clear(child);
        }

        public void componentRemoved(ContainerEvent e) {
            Component child = e.getChild();
            System.out.println("Removed: " + NapkinUtil.descFor(child) + " to " + e.getComponent());
            NapkinLookAndFeel.this.clear(child);
        }

        private void setFrom(FormalityFlags parentFlags) {
            if (parentFlags != null && parentFlags.known && this.inherited) {
                this.known = true;
                this.formal = parentFlags.formal;
            }
        }

        public String toString() {
            String desc;
            if (!this.known) {
                return "???";
            }
            String string = desc = this.formal ? "formal" : "napkin";
            if (!this.inherited) {
                desc = desc.toUpperCase();
            }
            return desc;
        }
    }

    class DumpVisitor
    implements ComponentWalker.Visitor {
        private final PrintStream out;

        DumpVisitor(PrintStream out) {
            this.out = out;
        }

        public boolean visit(Component c, int depth) {
            FormalityFlags ff = NapkinLookAndFeel.this.flags(c);
            int i = 0;
            while (i < depth) {
                this.out.print(i % 2 == 0 ? (char)'|' : '.');
                this.out.print(' ');
                ++i;
            }
            String desc = NapkinUtil.descFor(c);
            this.out.print(desc);
            this.out.print(": ");
            this.out.print(ff);
            this.out.print(", " + c.isOpaque());
            this.out.println();
            return true;
        }
    }
}

