/*
 * Decompiled with CFR 0.152.
 */
package napkin;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TextField;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnLineHolder;
import napkin.DrawnShapeGenerator;
import napkin.FakeEnabled;
import napkin.FakeEnabledButton;
import napkin.FakeEnabledMenuItem;
import napkin.NapkinBackground;
import napkin.NapkinBorder;
import napkin.NapkinConstants;
import napkin.NapkinIconFactory;
import napkin.NapkinLookAndFeel;
import napkin.NapkinPainter;
import napkin.NapkinTheme;
import napkin.NapkinWrappedBorder;

public class NapkinUtil
implements NapkinConstants {
    private static final AlphaComposite ERASURE_COMPOSITE;
    private static final float FOCUS_MARK_WIDTH = 1.5f;
    private static final Insets NO_INSETS;
    private static final PropertyChangeListener PROPERTY_LISTENER;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static int count;
    private static boolean drawingDisabled;
    private static final Map fieldsForType;
    private static final Stack paperStack;
    private static final Set printed;
    public static final Random random;
    private static final Set skip;
    private static final Map strokes;
    private static final BufferedImage textureImage;
    private static final Stack themeStack;

    static {
        printed = new HashSet();
        random = new Random();
        strokes = new WeakHashMap();
        fieldsForType = new WeakHashMap();
        themeStack = new Stack();
        paperStack = new Stack();
        PROPERTY_LISTENER = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String prop = event.getPropertyName();
                if (!prop.equals("opaque")) {
                    return;
                }
                JComponent c = (JComponent)event.getSource();
                Boolean val = (Boolean)event.getNewValue();
                if (val == Boolean.FALSE) {
                    val = null;
                }
                c.putClientProperty("napkin.wasOpaque", val);
            }
        };
        NO_INSETS = new Insets(0, 0, 0, 0);
        ERASURE_COMPOSITE = AlphaComposite.getInstance(8, 0.8f);
        skip = new HashSet();
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        ImageIcon icon = theme.getErasureMask().getIcon();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        textureImage = new BufferedImage(w, h, 2);
        Graphics2D gi = textureImage.createGraphics();
        gi.setColor(new Color(0, 0, 0, 0));
        gi.fillRect(0, 0, w, h);
        gi.drawImage(icon.getImage(), 0, 0, icon.getImageObserver());
        count = 0;
    }

    public static NapkinTheme background(Graphics g1, Component c) {
        if (NapkinUtil.isGlassPane(c)) {
            return null;
        }
        Graphics2D g = (Graphics2D)g1;
        NapkinTheme theme = NapkinUtil.currentTheme(c);
        NapkinBackground bg = theme.getPaper();
        Rectangle pRect = NapkinUtil.bounds(NapkinUtil.currentPaper(c));
        Rectangle cRect = NapkinUtil.bounds(c);
        bg.paint(c, g, pRect, cRect, NapkinUtil.insets(c));
        return theme;
    }

    private static Rectangle bounds(Component c) {
        Insets in = NapkinUtil.insets(c);
        Point start = NapkinUtil.getStart(c, in, false);
        int x = start.x;
        int y = start.y;
        int width = c.getWidth() + in.left + in.right;
        int height = c.getHeight() + in.top + in.bottom;
        return new Rectangle(x, y, width, height);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static Graphics2D copy(Graphics g) {
        return (Graphics2D)g.create();
    }

    public static AffineTransform copy(AffineTransform matrix) {
        if (matrix == null) {
            return new AffineTransform();
        }
        return (AffineTransform)matrix.clone();
    }

    static JButton createArrowButton(int pointTowards, int size) {
        Icon arrow = NapkinIconFactory.createArrowIcon(pointTowards, size);
        JButton button = new JButton(arrow);
        button.setBorderPainted(false);
        Dimension dim = new Dimension(size + 3, size + 3);
        button.setPreferredSize(dim);
        button.setMinimumSize(dim);
        return button;
    }

    static JButton createArrowButton(int pointTowards) {
        int size = 10;
        return NapkinUtil.createArrowButton(pointTowards, size);
    }

    public static Component currentPaper(Component c) {
        if (paperStack.isEmpty()) {
            return NapkinUtil.themeTopFor(c);
        }
        return (JComponent)paperStack.peek();
    }

    public static NapkinTheme currentTheme(Component c) {
        if (themeStack.isEmpty()) {
            return (NapkinTheme)NapkinUtil.themeTopFor(c).getClientProperty("napkin.theme");
        }
        return (NapkinTheme)themeStack.peek();
    }

    public static Graphics2D defaultGraphics(Graphics g1, Component c) {
        boolean enabled;
        Graphics2D g = (Graphics2D)g1;
        boolean bl = enabled = c.isEnabled() && !(c instanceof FakeEnabled);
        if (!enabled && c instanceof JComponent && !drawingDisabled) {
            drawingDisabled = true;
            Rectangle r = g.getClipBounds();
            int w = r.width;
            int h = r.height;
            BufferedImage tmp = new BufferedImage(w, h, 2);
            Graphics2D tg = tmp.createGraphics();
            Composite origComp = tg.getComposite();
            tg.setComposite(AlphaComposite.Clear);
            tg.fillRect(0, 0, w, h);
            tg.setComposite(origComp);
            int offX = -r.x;
            int offY = -r.y;
            tg.translate(offX, offY);
            tg.setBackground(g.getBackground());
            tg.setClip(0, 0, w, h);
            tg.setColor(g.getColor());
            tg.setComposite(g.getComposite());
            tg.setFont(g.getFont());
            tg.setPaint(g.getPaint());
            tg.setRenderingHints(g.getRenderingHints());
            tg.setStroke(g.getStroke());
            JComponent jc = (JComponent)c;
            DisabledMark mark = new DisabledMark(g, tmp, offX, offY);
            jc.putClientProperty("napkin.disabledMark", mark);
            g = tg;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        NapkinUtil.setupBorder(c);
        return g;
    }

    static String descFor(Component c) {
        JComponent jc;
        Border border;
        if (c == null) {
            return "[null]";
        }
        String idStr = "[" + System.identityHashCode(c) + "]";
        String desc = c.getName();
        if (desc != null) {
            return desc.trim() + idStr + "/" + c.getClass().getName();
        }
        desc = c.getClass().getName();
        int dot = desc.lastIndexOf(46);
        if (dot > 0) {
            desc = desc.substring(dot + 1);
        }
        desc = desc + idStr;
        if (c instanceof JLabel) {
            desc = desc + ": " + ((JLabel)c).getText();
        } else if (c instanceof AbstractButton) {
            desc = desc + ": " + ((AbstractButton)c).getText();
        } else if (c instanceof JTextField) {
            desc = desc + ": " + ((JTextField)c).getText();
        } else if (c instanceof JPopupMenu) {
            desc = desc + ": " + ((JPopupMenu)c).getLabel();
        } else if (c instanceof Label) {
            desc = desc + ": " + ((Label)c).getText();
        } else if (c instanceof TextField) {
            desc = desc + ": " + ((TextField)c).getText();
        } else if (c instanceof Button) {
            desc = desc + ": " + ((Button)c).getLabel();
        } else if (c instanceof Checkbox) {
            desc = desc + ": " + ((Checkbox)c).getLabel();
        } else if (c instanceof Dialog) {
            desc = desc + ": " + ((Dialog)c).getTitle();
        } else if (c instanceof Frame) {
            desc = desc + ": " + ((Frame)c).getTitle();
        } else if (c instanceof JInternalFrame) {
            desc = desc + ": " + ((JInternalFrame)c).getTitle();
        }
        desc = desc.trim();
        if (c instanceof JComponent && (border = (jc = (JComponent)c).getBorder()) instanceof TitledBorder) {
            desc = desc + ": " + ((TitledBorder)border).getTitle();
        }
        desc = desc.trim();
        return desc;
    }

    static String descFor(Object obj) {
        if (obj instanceof Component) {
            return NapkinUtil.descFor((Component)obj);
        }
        return obj.getClass().getName();
    }

    public static void drawStroke(GeneralPath path, AffineTransform matrix, double x1, double y1, double x2, double y2, double baseAngle, DrawnShapeGenerator lineGen) {
        double xDelta = x1 - x2;
        double yDelta = y1 - y2;
        double angle = Math.atan2(xDelta, yDelta);
        AffineTransform mat = NapkinUtil.copy(matrix);
        mat.translate(x1, y1);
        mat.rotate(baseAngle + angle);
        double len = Math.sqrt(xDelta * xDelta + yDelta * yDelta);
        mat.scale(len / 100.0, 1.0);
        DrawnShapeGenerator.addLine(path, mat, lineGen);
    }

    private static void dumpObject(Object obj, PrintStream out, int depth, Map known) {
        Object id = known.get(obj);
        if (id != null) {
            out.println("<known: " + id + ">");
            return;
        }
        id = new Integer(known.size());
        known.put(obj, id);
        out.println(NapkinUtil.descFor(obj) + " <" + id + ">");
        try {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i <= depth) {
                sb.append(i % 2 == 0 ? (char)'.' : '|').append(' ');
                ++i;
            }
            String indent = sb.toString();
            Field[] fields = NapkinUtil.getFields(obj);
            int i2 = 0;
            while (i2 < fields.length) {
                Field field = fields[i2];
                if (!skip.contains(field.getName())) {
                    Class<?> type = field.getType();
                    out.print(indent);
                    out.print(field.getName() + " [" + field.getType().getName() + "]: ");
                    Object val = field.get(obj);
                    NapkinUtil.dumpValue(type, out, val, depth, known);
                }
                ++i2;
            }
            if (obj.getClass().isArray()) {
                Class<?> type = obj.getClass().getComponentType();
                int length = Array.getLength(obj);
                int i3 = 0;
                while (i3 < length) {
                    Object val = Array.get(obj, i3);
                    if (val != null) {
                        out.print(indent);
                        out.print(i3 + ": ");
                        NapkinUtil.dumpValue(type, out, val, depth, known);
                    }
                    ++i3;
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void dumpObject(Object obj, PrintStream out) {
        HashMap known = new HashMap();
        NapkinUtil.dumpObject(obj, out, 0, known);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpObject(Object obj, String fileName) {
        PrintStream out = null;
        try {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName)));
                NapkinUtil.dumpObject(obj, out);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                Object var5_4 = null;
                if (out == null) return;
                out.close();
                return;
            }
            Object var5_3 = null;
            if (out == null) return;
            out.close();
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
    }

    private static void dumpStacks() {
        if (!Logs.paper.isLoggable(Level.FINER)) {
            return;
        }
        if (themeStack.size() != paperStack.size()) {
            System.out.println("!!!");
        }
        String dump = count + ":\t";
        ++count;
        int i = 0;
        while (i < paperStack.size()) {
            dump = dump + ". ";
            ++i;
        }
        if (!themeStack.isEmpty()) {
            dump = dump + themeStack.peek() + " / " + NapkinUtil.descFor(paperStack.peek());
        }
        Logs.paper.log(Level.FINER, dump);
    }

    private static void dumpTo(PrintWriter out, Object obj, Class cl, int level, Set dumped) throws IllegalAccessException {
        if (cl == null) {
            return;
        }
        NapkinUtil.dumpTo(out, obj, cl.getSuperclass(), level, dumped);
        Field[] fields = cl.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            field.setAccessible(true);
            Object val = field.get(obj);
            int l = 0;
            while (l < level) {
                out.print("    ");
                ++l;
            }
            out.println(field.getName() + ": " + val);
            if (val != null && !dumped.contains(obj) && !field.getType().isPrimitive()) {
                NapkinUtil.dumpTo(out, val, val.getClass(), level + 1, dumped);
                dumped.add(obj);
            }
            ++i;
        }
    }

    static void dumpTo(String file, JComponent c) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            HashSet dumped = new HashSet();
            NapkinUtil.dumpTo(out, c, c.getClass(), 0, dumped);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private static void dumpValue(Class type, PrintStream out, Object val, int depth, Map known) {
        if (type.isPrimitive()) {
            out.println(val);
        } else if (val == null || type == (class$java$lang$String == null ? (class$java$lang$String = NapkinUtil.class$("java.lang.String")) : class$java$lang$String)) {
            out.println(val);
        } else {
            if (type.isArray()) {
                Class<?> aType = type.getComponentType();
                out.println(" " + aType.getName() + "[" + Array.getLength(val) + "]");
            }
            NapkinUtil.dumpObject(val, out, depth + 1, known);
        }
    }

    public static void finishGraphics(Graphics g1, Component c) {
        if (c == NapkinUtil.currentPaper(c)) {
            if (!paperStack.isEmpty()) {
                paperStack.pop();
            }
            if (!themeStack.isEmpty()) {
                themeStack.pop();
            }
            NapkinUtil.dumpStacks();
        }
        if (!(c instanceof JComponent)) {
            return;
        }
        JComponent jc = (JComponent)c;
        DisabledMark mark = (DisabledMark)jc.getClientProperty("napkin.disabledMark");
        if (mark == null) {
            return;
        }
        drawingDisabled = false;
        jc.putClientProperty("napkin.disabledMark", null);
        Graphics2D tg = (Graphics2D)g1;
        tg.setComposite(ERASURE_COMPOSITE);
        Point start = NapkinUtil.getStart(jc, null, false);
        int w = textureImage.getWidth();
        int h = textureImage.getHeight();
        Rectangle anchor = new Rectangle(w - start.x, h - start.y, w, h);
        tg.setPaint(new TexturePaint(textureImage, anchor));
        tg.fillRect(0, 0, mark.image.getWidth(), mark.image.getHeight());
        Graphics2D g = mark.graphics;
        g.drawImage((Image)mark.image, -mark.offX, -mark.offY, jc);
    }

    private static Field[] getFields(Object obj) {
        Class<?> type = obj.getClass();
        AccessibleObject[] fields = (Field[])fieldsForType.get(type);
        if (fields != null) {
            return fields;
        }
        HashSet<Field> fSet = new HashSet<Field>();
        int skip = 152;
        while (type != (class$java$lang$Object == null ? NapkinUtil.class$("java.lang.Object") : class$java$lang$Object)) {
            Field[] declaredFields = type.getDeclaredFields();
            int i = 0;
            while (i < declaredFields.length) {
                Field field = declaredFields[i];
                int mods = field.getModifiers();
                if (!field.getDeclaringClass().isAssignableFrom(obj.getClass())) {
                    fSet.size();
                }
                if ((mods & skip) == 0) {
                    fSet.add(field);
                }
                ++i;
            }
            type = type.getSuperclass();
        }
        fields = fSet.toArray(new Field[fSet.size()]);
        Arrays.sort(fields, new Comparator(){

            public int compare(Object o1, Object o2) {
                Field f1 = (Field)o1;
                Field f2 = (Field)o2;
                int d = f1.getName().compareTo(f2.getName());
                if (d != 0) {
                    return d;
                }
                Class<?> c1 = f1.getDeclaringClass();
                Class<?> c2 = f2.getDeclaringClass();
                return c1.getName().compareTo(c2.getName());
            }
        });
        AccessibleObject.setAccessible(fields, true);
        fieldsForType.put(obj.getClass(), fields);
        return fields;
    }

    public static String getProperty(final String prop, final String defaultValue) {
        String themeName;
        try {
            themeName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(prop, defaultValue);
                }
            });
        }
        catch (SecurityException e) {
            themeName = null;
        }
        if (themeName == null) {
            themeName = defaultValue;
        }
        return themeName;
    }

    public static Object getProperty(JComponent c, String key, PropertyFactory factory) {
        Object value = c.getClientProperty(key);
        if (value == null) {
            value = factory.createPropertyValue();
            c.putClientProperty(key, value);
        }
        return value;
    }

    private static Point getStart(Component c, Insets insets, boolean print) {
        Point start = new Point();
        if (insets != null) {
            start.setLocation(-insets.left, -insets.top);
        }
        Component paper = NapkinUtil.currentPaper(c);
        while (c != null && c != paper) {
            if (print) {
                System.out.println("(" + c.getX() + ", " + c.getY() + "): " + NapkinUtil.descFor(c));
            }
            start.x += c.getX();
            start.y += c.getY();
            if (print) {
                System.out.println("start = " + start);
            }
            c = c.getParent();
        }
        return start;
    }

    public static Font ifReplace(Font current, Font candidate) {
        return NapkinUtil.replace(current, candidate) ? candidate : current;
    }

    public static Color ifReplace(Color current, Color candidate) {
        return NapkinUtil.replace(current, candidate) ? candidate : current;
    }

    public static Object ifReplace(Object current, Object candidate) {
        return NapkinUtil.replace(current, candidate) ? candidate : current;
    }

    private static Insets insets(Component c) {
        Insets in = c instanceof JComponent ? ((JComponent)c).getInsets() : NO_INSETS;
        return in;
    }

    public static void installUI(JComponent c) {
        if (c.isOpaque()) {
            c.putClientProperty("napkin.wasOpaque", Boolean.TRUE);
            c.setOpaque(false);
        }
        c.addPropertyChangeListener(PROPERTY_LISTENER);
        if (NapkinUtil.replace(c.getBackground(), NapkinConstants.CLEAR)) {
            c.setBackground(NapkinConstants.CLEAR);
        }
    }

    public static boolean isFormal(Component c) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof NapkinLookAndFeel) {
            NapkinLookAndFeel nlaf = (NapkinLookAndFeel)laf;
            return nlaf.isFormal(c);
        }
        return true;
    }

    static boolean isFormal(JComponent l) {
        NapkinLookAndFeel nlaf = (NapkinLookAndFeel)UIManager.getLookAndFeel();
        return nlaf.isFormal(l);
    }

    private static boolean isGlassPane(JComponent c) {
        JRootPane rootPane = c.getRootPane();
        return rootPane != null && rootPane.getGlassPane() == c;
    }

    private static boolean isGlassPane(Component c) {
        if (c instanceof JComponent) {
            return NapkinUtil.isGlassPane((JComponent)c);
        }
        return false;
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    private static boolean isPaper(Component c) {
        if (c instanceof JComponent) {
            return ((JComponent)c).getClientProperty("napkin.theme") != null;
        }
        return false;
    }

    public static double leftRight(double x, boolean left) {
        return left ? x : 100.0 - x;
    }

    public static Graphics2D lineGraphics(Graphics2D orig, float w) {
        Graphics2D lineG = NapkinUtil.copy(orig);
        Float key = new Float(w);
        Stroke stroke = (Stroke)strokes.get(key);
        if (stroke == null) {
            stroke = new BasicStroke(w, 1, 1);
            strokes.put(key, stroke);
        }
        lineG.setStroke(stroke);
        lineG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return lineG;
    }

    public static Graphics2D lineGraphics(Graphics orig, float w) {
        return NapkinUtil.lineGraphics((Graphics2D)orig, w);
    }

    public static DrawnLineHolder paintLine(Graphics g, boolean vertical, DrawnLineHolder holder, Rectangle bounds) {
        if (holder == null) {
            holder = new DrawnLineHolder((DrawnShapeGenerator)DrawnCubicLineGenerator.INSTANCE, vertical);
        }
        holder.shapeUpToDate(bounds, null);
        Graphics2D lineG = NapkinUtil.copy(g);
        if (vertical) {
            lineG.translate(bounds.x + bounds.width / 2, 0);
        } else {
            lineG.translate(0, bounds.y + bounds.height / 2);
        }
        holder.draw(lineG);
        return holder;
    }

    public static void paintText(Graphics g, JComponent c, Rectangle textRect, String text, int textOffset, DrawnLineHolder line, boolean isDefault, NapkinPainter helper) {
        AbstractButton button;
        ButtonModel model;
        if (isDefault) {
            if (line == null) {
                line = new DrawnLineHolder(new DrawnCubicLineGenerator());
            }
            Graphics2D ulG = NapkinUtil.copy(g);
            FontMetrics fm = ulG.getFontMetrics();
            line.shapeUpToDate(textRect, fm);
            int x = textOffset;
            int y = textOffset;
            ulG.translate(x, y);
            ulG.setColor(NapkinUtil.currentTheme(c).getCheckColor());
            line.setWidth(1.5f);
            line.draw(ulG);
        }
        Color textColor = c.getForeground();
        if (c instanceof AbstractButton && ((model = (button = (AbstractButton)c).getModel()).isArmed() || c instanceof JMenu && model.isSelected())) {
            textColor = NapkinUtil.currentTheme(c).getSelectionColor();
        }
        g.setColor(textColor);
        c = NapkinUtil.wrapIfNeeded(c);
        helper.superPaintText(g, c, textRect, text);
    }

    static String prBool(boolean bool, String name) {
        if (bool) {
            return name;
        }
        return '!' + name;
    }

    public static void printPair(String label, double x, double y) {
        System.out.println(label + ": " + x + ", " + y);
    }

    public static Object property(ComponentUI ui, String prop) {
        String name = ui.getClass().getName();
        String base = ".Napkin";
        int pos = name.lastIndexOf(base) + base.length();
        String pref = name.substring(pos, name.length() - 2);
        return pref + "." + prop;
    }

    public static Object[] reallocate(Object[] orig, int count) {
        if (count == orig.length) {
            return orig;
        }
        Class<?> componentType = orig.getClass().getComponentType();
        Object[] next = (Object[])Array.newInstance(componentType, count);
        System.arraycopy(orig, 0, next, 0, Math.min(orig.length, next.length));
        return next;
    }

    public static boolean replace(Object current, Object candidate) {
        if (current == null) {
            return true;
        }
        return !current.equals(candidate) && current instanceof UIResource;
    }

    static AffineTransform scaleMat(double scale) {
        AffineTransform mat = new AffineTransform();
        mat.scale(scale, scale);
        return mat;
    }

    private static void setupBorder(Component c) {
        JComponent jc;
        Border b;
        if (c instanceof JComponent && (b = (jc = (JComponent)c).getBorder()) != null && !(b instanceof NapkinBorder)) {
            jc.setBorder(new NapkinWrappedBorder(b));
        }
    }

    public static void setupPaper(JComponent c, int theme) {
        c.setOpaque(true);
        NapkinTheme baseTheme = NapkinTheme.Manager.getCurrentTheme();
        c.putClientProperty("napkin.theme", baseTheme.getTheme(theme));
    }

    private static boolean shouldMakeOpaque(JComponent c) {
        if (NapkinUtil.isGlassPane(c)) {
            return false;
        }
        return c.getClientProperty("napkin.wasOpaque") == Boolean.TRUE && !c.isOpaque();
    }

    public static void syncWithTheme(Graphics2D g, Component c) {
        NapkinTheme theme;
        Color penColor;
        if (NapkinUtil.isPaper(c)) {
            paperStack.push(c);
            themeStack.push(((JComponent)c).getClientProperty("napkin.theme"));
            NapkinUtil.dumpStacks();
        }
        if (!(penColor = (theme = NapkinUtil.currentTheme(c)).getPenColor()).equals(c.getForeground()) && g != null) {
            g.setColor(penColor);
        }
    }

    public static NapkinTheme themeFor(Component c) {
        JComponent themeTop = NapkinUtil.themeTopFor(c);
        if (themeTop == null) {
            return NapkinTheme.Manager.getCurrentTheme();
        }
        return (NapkinTheme)themeTop.getClientProperty("napkin.theme");
    }

    public static JComponent themeTopFor(Component c) {
        if (c == null) {
            return null;
        }
        if (!(c instanceof JComponent)) {
            return NapkinUtil.themeTopFor(c.getParent());
        }
        JComponent jc = (JComponent)c;
        if (jc.getClientProperty("napkin.theme") != null) {
            return jc;
        }
        JComponent themeTop = NapkinUtil.themeTopFor(jc.getParent());
        if (themeTop == null) {
            NapkinUtil.setupPaper(jc, 0);
            return jc;
        }
        return themeTop;
    }

    public static String toString(Color c) {
        return "#" + Integer.toHexString(c.getRGB()) + "/" + Integer.toHexString(c.getAlpha());
    }

    static void transform(AffineTransform matrix, double[] points) {
        if (matrix != null) {
            matrix.transform(points, 0, points, 0, points.length / 2);
        }
    }

    static ComponentUI uiFor(JComponent c, ComponentUI napkinUI) {
        NapkinLookAndFeel nlaf = (NapkinLookAndFeel)UIManager.getLookAndFeel();
        ComponentUI ui = nlaf.isFormal(c) ? nlaf.getFormalLAF().getDefaults().getUI(c) : napkinUI;
        if (Logs.ui.isLoggable(Level.FINER) && !printed.contains(c.getClass())) {
            Logs.ui.finer(c.getUIClassID() + "\n  " + napkinUI.getClass() + "\n  " + c.getClass());
            printed.add(c.getClass());
        }
        return ui;
    }

    public static void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(PROPERTY_LISTENER);
        if (NapkinUtil.shouldMakeOpaque(c)) {
            c.setOpaque(true);
        }
        NapkinUtil.unsetupBorder(c);
        int i = 0;
        while (i < NapkinConstants.CLIENT_PROPERTIES.length) {
            c.putClientProperty(NapkinConstants.CLIENT_PROPERTIES[i], null);
            ++i;
        }
    }

    private static void unsetupBorder(JComponent c) {
        Border b = c.getBorder();
        if (b instanceof NapkinWrappedBorder) {
            NapkinWrappedBorder nb = (NapkinWrappedBorder)b;
            c.setBorder(nb.getFormalBorder());
        } else if (b instanceof NapkinBorder) {
            c.setBorder(null);
        }
    }

    public static boolean within(Component c, Class type) {
        if (c == null) {
            return false;
        }
        if (c instanceof JTree) {
            return false;
        }
        if (type.isAssignableFrom(c.getClass())) {
            System.out.println("--");
            return true;
        }
        return NapkinUtil.within(c.getParent(), type);
    }

    private static JComponent wrapIfNeeded(JComponent c) {
        if (!(c instanceof AbstractButton)) {
            return c;
        }
        if (c.isEnabled()) {
            return c;
        }
        if (c instanceof JMenuItem) {
            return new FakeEnabledMenuItem(c);
        }
        return new FakeEnabledButton(c);
    }

    public static class DumpListener
    implements FocusListener {
        private Timer timer;

        public void focusGained(FocusEvent ev) {
            if (this.timer != null) {
                this.timer.stop();
            }
            int delay = 1000;
            ActionListener taskPerformer = new ActionListener(this, ev){
                private final /* synthetic */ DumpListener this$0;
                private final /* synthetic */ FocusEvent val$ev;
                {
                    this.this$0 = this$0;
                    this.val$ev = val$ev;
                }

                public void actionPerformed(ActionEvent evt) {
                    NapkinLookAndFeel laf = (NapkinLookAndFeel)UIManager.getLookAndFeel();
                    laf.dumpFormality(((JComponent)this.val$ev.getSource()).getTopLevelAncestor(), System.out);
                }
            };
            this.timer = new Timer(delay, taskPerformer);
            this.timer.start();
            ev.getComponent().removeFocusListener(this);
        }

        public void focusLost(FocusEvent e) {
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    public static class DisabledMark {
        public final Graphics2D graphics;
        public final BufferedImage image;
        public final int offX;
        public final int offY;

        public DisabledMark(Graphics2D graphics, BufferedImage image, int offX, int offY) {
            this.graphics = NapkinUtil.copy(graphics);
            this.image = image;
            this.offX = offX;
            this.offY = offY;
        }
    }

    public static interface PropertyFactory {
        public Object createPropertyValue();
    }

    public static class Logs {
        public static final Logger paper;
        public static final Logger ui;

        static {
            ui = Logger.getLogger("napkin.util");
            paper = Logger.getLogger("napkin.paper");
        }
    }
}

