/*
 * Decompiled with CFR 0.152.
 */
package napkin.dev;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import napkin.DrawnBoxGenerator;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnQuadLineGenerator;
import napkin.DrawnShapeGenerator;
import napkin.RandomValueSource;
import napkin.dev.GeneratorTest;
import napkin.dev.RandomValueSpinner;
import napkin.dev.SpringUtilities;

class BoxTest
extends GeneratorTest
implements GeneratorTest.Drawer {
    private final DrawnBoxGenerator gen;
    private final RandomValueSpinner begXSpin;
    private final RandomValueSpinner endYSpin;
    private final RandomValueSpinner startAdjustSpin;
    private final RandomValueSpinner sizeXSpin;
    private final RandomValueSpinner sizeYSpin;
    private final RandomValueSource[] spinners;
    private final Side[] sides;
    private JComponent drawing;
    private static final String[] TYPE_NAMES = new String[]{"cubic", "quad", "straight"};
    private static final Class[] TYPES = new Class[]{class$napkin$DrawnCubicLineGenerator == null ? (class$napkin$DrawnCubicLineGenerator = BoxTest.class$("napkin.DrawnCubicLineGenerator")) : class$napkin$DrawnCubicLineGenerator, class$napkin$DrawnQuadLineGenerator == null ? (class$napkin$DrawnQuadLineGenerator = BoxTest.class$("napkin.DrawnQuadLineGenerator")) : class$napkin$DrawnQuadLineGenerator, null};
    static /* synthetic */ Class class$napkin$DrawnCubicLineGenerator;
    static /* synthetic */ Class class$napkin$DrawnQuadLineGenerator;

    BoxTest(DrawnCubicLineGenerator cubic, DrawnQuadLineGenerator quad) {
        this.gen = new DrawnBoxGenerator(cubic, quad);
        this.begXSpin = new RandomValueSpinner("x", this.gen.getBegX(), -5.0, 5.0, 100);
        this.endYSpin = new RandomValueSpinner("y", this.gen.getEndY(), -5.0, 5.0, 100);
        this.startAdjustSpin = new RandomValueSpinner("adj", this.gen.getStartAdjust(), 0.0, 10.0, 100, false);
        this.sizeXSpin = new RandomValueSpinner("width", this.gen.getSizeX(), 0.0, 100.0, 100, false);
        this.sizeYSpin = new RandomValueSpinner("height", this.gen.getSizeY(), 0.0, 100.0, 100, false);
        this.spinners = new RandomValueSource[]{this.begXSpin, this.endYSpin, this.widthSpin};
        this.sides = new Side[4];
        for (int i = 0; i < this.sides.length; ++i) {
            this.sides[i] = new Side(DrawnBoxGenerator.SIDE_NAMES[i], i);
            this.gen.setGenerator(i, class$napkin$DrawnCubicLineGenerator == null ? BoxTest.class$("napkin.DrawnCubicLineGenerator") : class$napkin$DrawnCubicLineGenerator);
        }
        this.rebuild();
    }

    public void generate(AffineTransform matrix) {
        this.gen.generate(matrix);
    }

    public DrawnShapeGenerator getGenerator() {
        return this.gen;
    }

    public void rebuild() {
        this.generate(null);
    }

    public RandomValueSource[] getSpinners() {
        return this.spinners;
    }

    public String getName() {
        return "Box";
    }

    public JComponent getDrawing() {
        if (this.drawing == null) {
            this.drawing = new Drawing();
        }
        return this.drawing;
    }

    public JComponent getControls() {
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.setAlignmentY(1.0f);
        controls.add(BoxTest.controlSet("Corner", this.begXSpin, this.endYSpin, this.startAdjustSpin));
        controls.add(BoxTest.controlSet("Size", this.sizeXSpin, this.sizeYSpin));
        controls.add(BoxTest.controlSet("Line", this.widthSpin));
        JPanel typeControl = new JPanel();
        typeControl.setBorder(new TitledBorder("Side types"));
        typeControl.setLayout(new SpringLayout());
        for (int i = 0; i < this.sides.length; ++i) {
            Side side = this.sides[i];
            typeControl.add(side.show);
            typeControl.add(side.selector);
        }
        SpringUtilities.makeCompactGrid(typeControl, 2, 4, 0, 0, 0, 0);
        controls.add(typeControl);
        controls.add(Box.createVerticalGlue());
        return controls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String[] access$000() {
        return TYPE_NAMES;
    }

    static /* synthetic */ Class[] access$100() {
        return TYPES;
    }

    private class Drawing
    extends JLabel {
        Drawing() {
            int space = 50;
            this.setBorder(new EmptyBorder(50, 50, 50, 50));
        }

        protected void paintComponent(Graphics g1) {
            Graphics2D g = (Graphics2D)g1;
            double mid = (double)(this.getHeight() / 2) - BoxTest.this.sizeYSpin.get() / 2.0;
            g.translate(50.0, mid);
            Graphics2D lineG = GeneratorTest.lineGraphics(g, (float)BoxTest.this.widthSpin.get());
            Graphics2D markG = GeneratorTest.markGraphics(g);
            GeneratorTest.mark(markG, GeneratorTest.ZERO, GeneratorTest.ZERO, BoxTest.this.sizeXSpin, BoxTest.this.sizeYSpin);
            for (int i = 0; i < 4; ++i) {
                this.showSide(lineG, BoxTest.this.sides[i], BoxTest.this.gen.getSide(i));
            }
            GeneratorTest.mark(markG, BoxTest.this.begXSpin, GeneratorTest.ZERO, true);
            GeneratorTest.mark(markG, GeneratorTest.ZERO, BoxTest.this.endYSpin, true);
        }

        private void showSide(Graphics2D lineG, Side side, Shape shape) {
            if (side.show.isSelected()) {
                lineG.draw(shape);
            }
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            return new Dimension(200, 500);
        }
    }

    private class Side {
        private final JComboBox selector = new JComboBox<String>(BoxTest.access$000());
        private final JCheckBox show;

        Side(String name, int which) {
            this.selector.addActionListener(GeneratorTest.REPAINT_ACTION);
            this.selector.addActionListener(new ActionListener(this, which){
                private final /* synthetic */ int val$which;
                private final /* synthetic */ Side this$1;
                {
                    this.this$1 = this$1;
                    this.val$which = val$which;
                }

                public void actionPerformed(ActionEvent e) {
                    BoxTest.access$400(Side.access$300(this.this$1)).setGenerator(this.val$which, BoxTest.access$100()[Side.access$200(this.this$1).getSelectedIndex()]);
                }
            });
            this.show = new JCheckBox(name, true);
            this.show.addActionListener(GeneratorTest.REPAINT_ACTION);
        }

        static /* synthetic */ BoxTest access$300(Side x0) {
            return x0.BoxTest.this;
        }
    }
}

