/*
 * Decompiled with CFR 0.152.
 */
package napkin.dev;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import napkin.DrawnCubicLineGenerator;
import napkin.DrawnShapeGenerator;
import napkin.RandomValue;
import napkin.RandomValueSource;
import napkin.dev.GeneratorTest;
import napkin.dev.RandomValueSpinner;

class CubicTest
extends GeneratorTest
implements GeneratorTest.Drawer {
    private final DrawnCubicLineGenerator gen = new DrawnCubicLineGenerator();
    private final RandomValue width;
    private Shape curve;
    private final RandomValueSpinner leftXSpin = new RandomValueSpinner("x", this.gen.getLeftX(), 0.0, 50.0, 100);
    private final RandomValueSpinner leftYSpin = new RandomValueSpinner("y", this.gen.getLeftY(), -20.0, 20.0, 100);
    private final RandomValueSpinner rightXSpin = new RandomValueSpinner("x", this.gen.getRightX(), 0.0, 50.0, 100);
    private final RandomValueSpinner rightYSpin = new RandomValueSpinner("y", this.gen.getRightY(), -20.0, 20.0, 100);
    private final RandomValueSpinner widthSpin;
    private final RandomValueSource[] spinners;
    private JComponent drawing;

    CubicTest() {
        this.width = new RandomValue(1.0, 0.0);
        this.widthSpin = new RandomValueSpinner("w", this.width, 0.0, 3.0, 20);
        this.spinners = new RandomValueSpinner[]{this.leftXSpin, this.leftYSpin, this.rightXSpin, this.rightYSpin, this.widthSpin};
        this.rebuild();
    }

    public DrawnShapeGenerator getGenerator() {
        return this.gen;
    }

    public void rebuild() {
        this.curve = this.generate(null);
    }

    public Shape generate(AffineTransform matrix) {
        return this.gen.generate(matrix);
    }

    public RandomValueSource[] getSpinners() {
        return this.spinners;
    }

    public String getName() {
        return "Cubic";
    }

    public JComponent getDrawing() {
        if (this.drawing == null) {
            this.drawing = new Drawing();
        }
        return this.drawing;
    }

    public JComponent getControls() {
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.setAlignmentY(1.0f);
        controls.add(CubicTest.controlSet("Left", this.leftXSpin, this.leftYSpin));
        controls.add(CubicTest.controlSet("Right", this.rightXSpin, this.rightYSpin));
        controls.add(CubicTest.controlSet("Line", this.widthSpin));
        JPanel lineControl = new JPanel();
        lineControl.setBorder(new TitledBorder("Line"));
        lineControl.setLayout(new BoxLayout(lineControl, 0));
        controls.add(Box.createVerticalGlue());
        return controls;
    }

    private class Drawing
    extends JLabel {
        Drawing() {
            int space = 50;
            this.setBorder(new EmptyBorder(50, 50, 50, 50));
        }

        protected void paintComponent(Graphics g1) {
            Graphics2D g = (Graphics2D)g1;
            double mid = this.getHeight() / 2;
            g.translate(50.0, mid);
            Graphics2D lineG = GeneratorTest.lineGraphics(g, (float)CubicTest.this.width.get());
            lineG.draw(CubicTest.this.curve);
            Graphics2D markG = GeneratorTest.markGraphics(g);
            GeneratorTest.mark(markG, CubicTest.this.leftXSpin, CubicTest.this.leftYSpin, true);
            GeneratorTest.mark(markG, CubicTest.this.rightXSpin, CubicTest.this.rightYSpin, false);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            return new Dimension(200, 500);
        }
    }
}

