/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.DataBandwidthFilterOut;
import ants.p2p.Message;
import ants.p2p.Neighbour;
import ants.p2p.NeighbourAnt;
import ants.p2p.QueryBandwidthFilterOut;
import ants.p2p.SenderThread;
import ants.p2p.query.QueryMessage;
import ants.p2p.security.sockets.SSLProvider;
import ants.p2p.utils.addresses.InetAddressWatchdog;
import ants.p2p.utils.net.BandwidthFilterOut;
import com.jcraft.jzlib.ZOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

public class DirectNeighbour
implements Neighbour {
    InetAddress ip;
    int port;
    Ant local;
    Socket s;
    static long queuedMessages = 0L;
    private static Logger _logger = Logger.getLogger((String)DirectNeighbour.class.getName());

    public DirectNeighbour(String ip, Ant local) throws Exception {
        this.local = local;
        if (ip.startsWith("/")) {
            ip = ip.substring(1);
        }
        String[] ipPort = ip.split("[:]");
        this.ip = InetAddress.getByName(ipPort[0]);
        this.port = Integer.parseInt(ipPort[1]);
        if (!InetAddressWatchdog.getInstance().allowedAddress(this.ip.getHostAddress())) {
            throw new Exception("Address not allowed! " + this.ip);
        }
        if (this.ip.getHostAddress().equals(local.getLocalInetAddress())) {
            throw new Exception("Loopback connection!");
        }
        String string = this.ip.getHostAddress();
        this.getAnt();
        this.s = SSLProvider.getSSLSecuredSocket(string, this.port, Ant.proxied);
        this.s.getOutputStream().write(2);
        this.s.getOutputStream().flush();
        this.s.setSoTimeout(180000);
    }

    public SenderThread route(Message m) {
        SenderThread st = new SenderThread(m, this);
        st.start();
        return st;
    }

    public void send(Message m) throws Exception {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        ZOutputStream zOut = new ZOutputStream((OutputStream)byteArrayOut, 9);
        BandwidthFilterOut bfOut = new BandwidthFilterOut((OutputStream)zOut);
        ObjectOutputStream zOOs = new ObjectOutputStream(bfOut);
        _logger.debug((Object)(this.getIdent() + ": DCMessage sending [" + this.getQueuedMessages() + "]" + m.getType() + " " + m));
        zOOs.writeObject(this.local.getLocalInetAddress());
        zOOs.writeObject(m);
        NeighbourAnt.totalUncompressionSizeOut += (double)zOut.getTotalIn();
        zOut.close();
        NeighbourAnt.totalCompressedSizeOut += (double)byteArrayOut.toByteArray().length;
        NeighbourAnt.updateOutStats(m, byteArrayOut.toByteArray().length);
        if (m instanceof QueryMessage) {
            QueryBandwidthFilterOut.getInstance().writeQuery(byteArrayOut.toByteArray().length);
        } else {
            DataBandwidthFilterOut.getInstance().writeData(byteArrayOut.toByteArray().length);
        }
        this.s.getOutputStream().write(byteArrayOut.toByteArray());
        this.s.close();
        _logger.debug((Object)(this.getIdent() + ": DCMessage sent"));
    }

    public String getIdent() {
        String curIp = this.ip.getHostAddress() + ":" + this.port;
        if (curIp.startsWith("/")) {
            curIp = curIp.substring(1);
        }
        return curIp;
    }

    public Ant getAnt() {
        return this.local;
    }

    private synchronized void modifyQueuedMessages(int modifier) {
        queuedMessages += (long)modifier;
    }

    public void incQueuedMessages() {
        this.modifyQueuedMessages(1);
    }

    public void decQueuedMessages() {
        this.modifyQueuedMessages(-1);
    }

    public long getQueuedMessages() {
        return queuedMessages;
    }
}

