/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Ant;
import ants.p2p.MessageWrapper;
import ants.p2p.query.QueryMessage;
import java.io.Serializable;
import javax.crypto.Cipher;

public class Message
implements Serializable,
Cloneable {
    private final String antMessageVersion = Ant.getProtocolVersion();
    private int retransmissions;
    private boolean delivered = false;
    private String source;
    private String sourceAddress;
    protected String dest;
    private String ack_id;
    private byte[] signature = null;
    private byte[] publicKey = null;
    private int type;

    public Message(Message m) {
        this.source = m.source;
        this.sourceAddress = m.sourceAddress;
        this.dest = m.dest;
        this.ack_id = m.ack_id;
        this.type = m.type;
        this.delivered = m.delivered;
        this.retransmissions = m.retransmissions;
        this.signature = m.signature;
        this.publicKey = m.publicKey;
    }

    public Message getSignableMessage() {
        try {
            Message signable = (Message)this.clone();
            signable.retransmissions = 0;
            signable.delivered = false;
            signable.signature = null;
            signable.publicKey = null;
            return signable;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setPublicKey(byte[] pubKey) {
        this.publicKey = pubKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public String getVersion() {
        return this.antMessageVersion;
    }

    public Message(MessageWrapper wm) {
        this(wm.getMessage());
    }

    public void disableAutoRetransmit() {
        this.retransmissions = Ant.maxRetransmissions;
    }

    public void retrasmitted() {
        ++this.retransmissions;
    }

    public int getRetrasmissions() {
        return this.retransmissions;
    }

    public void invalidate() {
        this.delivered = true;
    }

    public boolean getDelivered() {
        return this.delivered;
    }

    public void resetDelivered() {
        this.delivered = false;
    }

    public void setDelivered() {
        this.delivered = true;
    }

    public void resetDest() {
        this.dest = "";
    }

    public void resetSource() {
        this.source = "";
    }

    public Message() {
        this.type = -1;
        this.ack_id = null;
        this.source = null;
        this.sourceAddress = "";
        this.dest = null;
        this.retransmissions = 0;
    }

    public void fillMessageProperties(String source, String sourceAddress, String dest, int type, String id_ack) {
        this.type = type;
        this.ack_id = id_ack;
        this.source = source;
        this.sourceAddress = sourceAddress;
        this.dest = dest;
    }

    public int getType() {
        return this.type;
    }

    public String getAck_Id() {
        return this.ack_id;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public String getDest() {
        return this.dest;
    }

    public boolean equals(Object o) {
        if (o instanceof MessageWrapper) {
            return ((MessageWrapper)o).getMessage().getAck_Id().equals(this.getAck_Id()) && ((MessageWrapper)o).getMessage().getType() == this.getType();
        }
        if (o instanceof QueryMessage) {
            return ((QueryMessage)o).getAck_Id().equals(this.getAck_Id()) && ((QueryMessage)o).getType() == this.getType() && ((QueryMessage)o).getDest() == this.getDest();
        }
        try {
            return ((Message)o).ack_id.equals(this.ack_id) && ((Message)o).type == this.type;
        }
        catch (ClassCastException e) {
            return o == this;
        }
    }

    public void encrypt(Cipher enc) throws Exception {
    }

    public void decrypt(Cipher dec) throws Exception {
    }
}

