/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RoutingTableElement {
    long lastTimeUsed = System.currentTimeMillis();
    public ArrayList routes = new ArrayList();
    String ip = null;
    boolean isTraced = false;
    long lastSeenOn = 0L;
    boolean firewalled = false;

    public void setLastTimeUsed() {
        this.lastTimeUsed = System.currentTimeMillis();
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public boolean isTraced() {
        return this.isTraced;
    }

    public void setIP(String ip) {
        if (ip == null || ip.equals("")) {
            return;
        }
        if (ip.startsWith("/")) {
            ip = ip.substring(1);
        }
        if (this.ip != null && this.ip.equals(ip)) {
            return;
        }
        String[] parts = ip.split("[:]");
        try {
            InetAddress address = InetAddress.getByName(parts[0]);
            if (!RoutingTableElement.isInternetPublicAddress(address)) {
                return;
            }
            new Socket(parts[0], Integer.parseInt(parts[1]));
        }
        catch (NumberFormatException ex1) {
            return;
        }
        catch (UnknownHostException ex1) {
            return;
        }
        catch (IOException ex1) {
            this.firewalled = true;
        }
        this.ip = ip;
    }

    public String getIP() {
        return this.firewalled ? null : this.ip;
    }

    public boolean addTracedRoute(String route) {
        if (!this.isTraced()) {
            this.routes = new ArrayList();
            this.isTraced = true;
            this.lastSeenOn = Long.MAX_VALUE;
        }
        if (!this.routes.contains(route)) {
            this.routes.add(route);
            return true;
        }
        return false;
    }

    public boolean addHintRoute(String route, long lastSeenOn) {
        if (!this.isTraced() && this.lastSeenOn < lastSeenOn) {
            this.routes = new ArrayList();
            this.lastSeenOn = lastSeenOn;
            this.routes.add(route);
            return true;
        }
        return false;
    }

    public boolean removeRoute(String route) {
        if (this.routes.remove(route)) {
            if (this.routes.size() == 0) {
                this.isTraced = false;
                this.lastSeenOn = 0L;
            }
            return true;
        }
        return false;
    }

    public List getRoutes() {
        return Collections.unmodifiableList(this.routes);
    }

    public static boolean isInternetPublicAddress(InetAddress address) {
        try {
            byte head = address.getAddress()[0];
            byte body = address.getAddress()[1];
            byte tail = address.getAddress()[2];
            if (head >= 89 && head <= 127) {
                return false;
            }
            if (head >= 173 && head <= 187) {
                return false;
            }
            if (head >= 224 && head <= 239) {
                return false;
            }
            if (head >= 240 && head <= 255) {
                return false;
            }
            switch (head) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    break;
                }
                case 10: {
                    break;
                }
                case 23: {
                    break;
                }
                case 27: {
                    break;
                }
                case 31: {
                    break;
                }
                case 36: {
                    break;
                }
                case 37: {
                    break;
                }
                case 39: {
                    break;
                }
                case 41: {
                    break;
                }
                case 42: {
                    break;
                }
                case 46: {
                    break;
                }
                case 49: {
                    break;
                }
                case 50: {
                    break;
                }
                case 58: {
                    break;
                }
                case 59: {
                    break;
                }
                case 60: {
                    break;
                }
                case 71: {
                    break;
                }
                case 72: {
                    break;
                }
                case 73: {
                    break;
                }
                case 74: {
                    break;
                }
                case 75: {
                    break;
                }
                case 76: {
                    break;
                }
                case 77: {
                    break;
                }
                case 78: {
                    break;
                }
                case 79: {
                    break;
                }
                case -128: {
                    if (body == 0) break;
                }
                case -87: {
                    if (body == -2) break;
                }
                case -84: {
                    if (body >= 16 && body <= 31) break;
                }
                case -67: {
                    break;
                }
                case -66: {
                    break;
                }
                case -65: {
                    if (body == -1) break;
                }
                case -64: {
                    if (body == 0 || body == 68 && tail == -71 || body == -88) break;
                }
                case -59: {
                    break;
                }
                case -58: {
                    if (body >= 18 && body <= 19) break;
                }
                case -33: {
                    break;
                }
                default: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

