/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p;

import ants.p2p.Message;
import ants.p2p.Neighbour;
import ants.p2p.query.QueryMessage;
import org.apache.log4j.Logger;

public class SenderThread
extends Thread {
    Message m;
    Neighbour n;
    public static int queryQueueLimit = 30;
    public static int queueLimit = 100;
    public static final int waitTime = 8;
    static Logger _logger = Logger.getLogger((String)SenderThread.class.getName());
    private boolean send = true;

    public SenderThread(Message m, Neighbour n) {
        this.m = m;
        this.n = n;
        this.setPriority(10);
    }

    public void run() {
        try {
            if (this.n.getQueuedMessages() > (long)queryQueueLimit && this.m instanceof QueryMessage && (this.m.getType() == 2 || this.m.getType() == 0)) {
                _logger.debug((Object)(this.n.getIdent() + " Neighbour stuck [too many queued messages: " + this.n.getQueuedMessages() + "]. Dircarding query..."));
                return;
            }
            if (this.n.getQueuedMessages() > (long)queueLimit) {
                _logger.debug((Object)(this.n.getIdent() + " Neighbour stuck [too many queued messages: " + this.n.getQueuedMessages() + "]. Dircarding message..."));
                return;
            }
            this.n.incQueuedMessages();
            this.n.send(this.m);
            this.n.decQueuedMessages();
        }
        catch (Exception e) {
            _logger.error((Object)"Error in sending packet through Socket", (Throwable)e);
            this.n.decQueuedMessages();
        }
    }

    public void interruptSending() {
        this.send = false;
    }

    public boolean mustSend() {
        return this.send;
    }
}

