/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.filesharing;

import ants.p2p.Ant;
import ants.p2p.filesharing.MultipleSourcesDownloadManager;
import org.apache.log4j.Logger;

class DownloadWatchDog
extends Thread {
    public static long downloadTimeout = Ant.messageTimeout * (long)Ant.maxRetransmissions;
    long lastPartReceivedTime;
    MultipleSourcesDownloadManager msdm = null;
    boolean interrupt = false;
    long byteDownloadedTracer;
    long curByteDownloadedTracer;
    long startTimeTracer;
    long curStartTimeTracer;
    static Logger _logger = Logger.getLogger((String)DownloadWatchDog.class.getName());

    public DownloadWatchDog(MultipleSourcesDownloadManager msdm) {
        this.msdm = msdm;
        this.lastPartReceivedTime = System.currentTimeMillis();
        this.setPriority(6);
        this.byteDownloadedTracer = msdm.initialBytesDownloaded;
        this.startTimeTracer = msdm.startTime;
        this.curByteDownloadedTracer = msdm.initialBytesDownloaded;
        this.curStartTimeTracer = msdm.startTime;
    }

    public void setReceivedPart() {
        this.lastPartReceivedTime = System.currentTimeMillis();
    }

    public void terminate() {
        this.interrupt = true;
    }

    public void run() {
        boolean resetActivator = false;
        while (this.msdm.isAlive() && !this.interrupt) {
            try {
                DownloadWatchDog.sleep(5000L);
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
            }
            this.msdm.resume();
            long elapsed = System.currentTimeMillis() - this.lastPartReceivedTime;
            if (elapsed > downloadTimeout) {
                this.msdm.propertyChangeSupport.firePropertyChange("multipleDownloadTimedOut", null, this.msdm);
                _logger.info((Object)(this.msdm + "\ntimed out!"));
                return;
            }
            this.byteDownloadedTracer = this.curByteDownloadedTracer;
            this.startTimeTracer = this.curStartTimeTracer;
            long downloadedGroups = 0L;
            for (int x = 0; x < this.msdm.downloadedBlockGroups.length; ++x) {
                if (!this.msdm.downloadedBlockGroups[x]) continue;
                ++downloadedGroups;
            }
            downloadedGroups = downloadedGroups * (long)MultipleSourcesDownloadManager.blocksPerSource + (long)this.msdm.chunckBlocksCounter;
            this.curByteDownloadedTracer = downloadedGroups * (long)this.msdm.blockSize;
            this.curStartTimeTracer = System.currentTimeMillis();
            this.msdm.initialBytesDownloaded = this.byteDownloadedTracer;
            this.msdm.startTime = this.startTimeTracer;
            this.msdm.propertyChangeSupport.firePropertyChange("refreshDownloadGraphic", null, this.msdm);
            this.msdm.n.prunePartialFiles();
        }
        _logger.info((Object)(this.msdm + "\ninterrupted!"));
    }
}

