/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.filesharing;

import ants.p2p.filesharing.DownloadWatchDog;
import ants.p2p.filesharing.MultipleSourcesDownloadManager;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.query.QueryFileTuple;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.apache.log4j.Logger;

class PullerThread
extends Thread
implements PropertyChangeListener {
    long lastPartReceivedTime;
    boolean terminate = false;
    MultipleSourcesDownloadManager caller;
    WarriorAnt n;
    String fileName;
    String fileHash;
    long offset;
    long blocks;
    String peerId;
    int blockSize;
    String localFileName;
    boolean resume;
    QueryFileTuple peerTuple;
    int partId;
    static Logger _logger = Logger.getLogger((String)PullerThread.class.getName());

    PullerThread(MultipleSourcesDownloadManager caller, WarriorAnt n, String fileName, String fileHash, long offset, long blocks, String peerId, int blockSize, String localFileName, boolean resume, QueryFileTuple peerTuple, int partId) {
        this.n = n;
        this.caller = caller;
        this.fileName = fileName;
        this.fileHash = fileHash;
        this.offset = offset;
        this.blocks = blocks;
        this.peerId = peerId;
        this.blockSize = blockSize;
        this.localFileName = localFileName;
        this.resume = resume;
        this.peerTuple = peerTuple;
        this.partId = partId;
        this.caller.propertyChangeSupport.addPropertyChangeListener(this);
        this.setPriority(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            this.n.pullFile(this.fileName, this.fileHash, this.offset, this.blocks, this.peerId, this.blockSize, this.localFileName, this.resume);
            this.lastPartReceivedTime = System.currentTimeMillis();
            while (!this.terminate) {
                PullerThread.sleep(5000L);
                long elapsed = System.currentTimeMillis() - this.lastPartReceivedTime;
                if (this.caller.checkCompleted()) continue;
                if (this.caller.interrupt) throw new Exception("Pull failed: " + this.fileHash.substring(0, 10) + " " + this.peerId.substring(0, 10));
                if (elapsed <= DownloadWatchDog.downloadTimeout) continue;
                throw new Exception("Pull failed: " + this.fileHash.substring(0, 10) + " " + this.peerId.substring(0, 10));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            boolean[] blArray = this.caller.inServiceBlockGroups;
            // MONITORENTER : this.caller.inServiceBlockGroups
            List list = this.caller.synchronizedInServicePeerList;
            // MONITORENTER : list
            this.n.propertyChangeSupport.firePropertyChange("filePullerThreadRequestError", null, this);
            // MONITOREXIT : list
            // MONITOREXIT : blArray
        }
        this.caller.propertyChangeSupport.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("pullerThreadUpdatePart") && e.getNewValue().equals(this.peerId)) {
            this.lastPartReceivedTime = System.currentTimeMillis();
        } else if (e.getPropertyName().equals("pullerThreadCompletedPart") && e.getNewValue().equals(this.peerId)) {
            this.terminate = true;
            _logger.info((Object)("Puller thread completed: " + this.fileHash + " " + this.partId));
        } else if (e.getPropertyName().equals("pullerThreadPartError") && e.getNewValue().equals(this.peerId)) {
            this.terminate = true;
            _logger.info((Object)("Puller thread terminated: " + this.fileHash + " " + this.partId));
        }
    }
}

