/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.gui;

import ants.p2p.gui.StartUp;
import ants.p2p.query.FileTupleGroup;
import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRemoteFileTuple;
import ants.p2p.utils.encoding.PercentageString;
import ants.p2p.utils.encoding.TableEntryDate;
import ants.p2p.utils.indexer.FileSize;
import ants.p2p.utils.indexer.FileSource;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import ji.JI;
import org.apache.log4j.Logger;

public class QueryTableModel
extends AbstractTableModel {
    static Logger _logger = Logger.getLogger((String)StartUp.class.getName());
    ArrayList resultSet = new ArrayList();
    private String[] columnNames = new String[]{JI.i("File Name"), JI.i("Sources"), JI.i("Max % completed"), JI.i("File Size"), JI.i("Last Seen on"), JI.i("File Infos"), JI.i("File Hash")};

    public QueryTableModel(ArrayList resultSet) {
        this.resultSet = resultSet;
    }

    public ArrayList getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ArrayList resultSet) {
        this.resultSet = resultSet;
        this.fireTableRowsUpdated(0, this.resultSet.size());
    }

    public int getRowCount() {
        return this.resultSet.size();
    }

    public Object getValueAt(int row, int col) {
        FileTupleGroup ftg = (FileTupleGroup)this.resultSet.get(row);
        switch (col) {
            case 0: {
                return ((QueryFileTuple)ftg.tuples.get(0)).getFileName();
            }
            case 1: {
                int owners = ftg.tuples.size();
                long lastTimeSeen = ftg.getLastTimeSeen();
                return new FileSource(owners, lastTimeSeen);
            }
            case 2: {
                PercentageString percent = new PercentageString("0%");
                for (int x = 0; x < ftg.tuples.size(); ++x) {
                    QueryFileTuple qft = (QueryFileTuple)ftg.tuples.get(x);
                    if (qft instanceof QueryRemoteFileTuple) continue;
                    if (qft instanceof QueryCompletedFileTuple) {
                        return new PercentageString("100%");
                    }
                    if (!(qft instanceof QueryPartialFileTuple) || new PercentageString(((QueryPartialFileTuple)qft).getPercentage()).compareTo(percent) <= 0) continue;
                    percent = new PercentageString(((QueryPartialFileTuple)qft).getPercentage());
                }
                return percent;
            }
            case 3: {
                return new FileSize(ftg.getSize());
            }
            case 4: {
                return new TableEntryDate(ftg.getLastTimeSeen());
            }
            case 5: {
                return ((QueryFileTuple)ftg.tuples.get(0)).getExtendedInfos();
            }
            case 6: {
                return ftg.getHash();
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public Class getColumnClass(int col) {
        try {
            switch (col) {
                case 0: {
                    return Class.forName("java.lang.String");
                }
                case 1: {
                    return Class.forName("ants.p2p.utils.indexer.FileSource");
                }
                case 2: {
                    return Class.forName("ants.p2p.utils.encoding.PercentageString");
                }
                case 3: {
                    return Class.forName("ants.p2p.utils.indexer.FileSize");
                }
                case 4: {
                    return Class.forName("ants.p2p.utils.encoding.TableEntryDate");
                }
                case 5: {
                    return Class.forName("java.lang.String");
                }
                case 6: {
                    return Class.forName("java.lang.String");
                }
            }
            return null;
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot resolve class", (Throwable)e);
            return null;
        }
    }
}

