/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.http;

import ants.p2p.MessageWrapper;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.http.HttpRequestMessage;
import ants.p2p.http.HttpResponsePartMessage;
import ants.p2p.http.HttpTransferEndControlMessage;
import ants.p2p.messages.SecureConnectionErrorControlMessage;
import ants.p2p.security.EndpointSecurityManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class HttpRequestHandler
extends Thread
implements PropertyChangeListener {
    HttpRequestMessage requestMessage;
    WarriorAnt wa;
    int currentId = 0;
    boolean terminate = false;
    static Logger _logger = Logger.getLogger((String)HttpRequestHandler.class.getName());

    public HttpRequestHandler(HttpRequestMessage requestMessage, WarriorAnt wa) {
        this.wa = wa;
        this.wa.propertyChangeSupport.addPropertyChangeListener(this);
        this.requestMessage = requestMessage;
        this.start();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("httpInterruptTransfer") && e.getNewValue().equals(this.requestMessage)) {
            this.terminate();
        }
    }

    public WarriorAnt getWarriorAnt() {
        return this.wa;
    }

    public void run() {
        this.handleRequest();
    }

    public boolean equals(Object o) {
        if (o instanceof HttpRequestMessage) {
            return this.requestMessage.equals(o);
        }
        return this == o;
    }

    public void terminate() {
        this.terminate = true;
    }

    void handleRequest() {
        Socket s = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int n;
            s = new Socket("localhost", WarriorAnt.getHttpLocalServerPort());
            s.setSoTimeout(5000);
            os = s.getOutputStream();
            is = s.getInputStream();
            os.write(this.requestMessage.getBody());
            s.shutdownOutput();
            byte[] response = new byte[WarriorAnt.blockSizeInDownload];
            _logger.debug((Object)"Show Browser Request:");
            String browserRequest = "";
            for (int x = 0; x < this.requestMessage.getBody().length; ++x) {
                browserRequest = browserRequest + (char)this.requestMessage.getBody()[x];
            }
            _logger.debug((Object)browserRequest);
            _logger.debug((Object)"Waiting for Response...");
            ArrayList<MessageWrapper> sentMessages = new ArrayList<MessageWrapper>();
            while (!this.terminate && (n = is.read(response)) != -1) {
                MessageWrapper wm;
                if (n < response.length) {
                    MessageWrapper wm2;
                    byte[] responseShorted = new byte[n];
                    for (int x = 0; x < n; ++x) {
                        responseShorted[x] = response[x];
                    }
                    EndpointSecurityManager esm = this.getWarriorAnt().getInputSecureConnectionManager(this.requestMessage.getSource());
                    if (esm == null) {
                        SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                        wm2 = this.wa.sendMessage(fterrcm, this.requestMessage.getSource(), false, false);
                        _logger.debug((Object)(this.wa.getShortId() + ": No secure connection with " + this.requestMessage.getSource()));
                        while (this.wa.myMessages.contains(wm2) && !this.terminate) {
                            Thread.sleep(1000L);
                        }
                        if (this.wa.failedMessages.contains(wm2)) {
                            this.wa.failedMessages.remove(wm2);
                            _logger.debug((Object)(this.wa.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                        }
                        throw new Exception("No secure connection avaiable with endpoint " + this.requestMessage.getSource());
                    }
                    HttpResponsePartMessage httpResponsePartMessage = new HttpResponsePartMessage(responseShorted, this.requestMessage, new Integer(this.currentId++));
                    httpResponsePartMessage.encrypt(esm.getCipherEnc());
                    wm2 = this.getWarriorAnt().sendMessage(httpResponsePartMessage, this.requestMessage.getSource(), false, false);
                    sentMessages.add(wm2);
                    while (sentMessages.size() >= 2 && !this.getWarriorAnt().areInFailedMessages(sentMessages)) {
                        this.wa.removeDeliveredMessagesFromList(sentMessages);
                        Thread.sleep(1000L);
                    }
                    if (!this.getWarriorAnt().areInFailedMessages(sentMessages)) continue;
                    this.getWarriorAnt().failedMessages.removeAll(sentMessages);
                    _logger.debug((Object)(this.getWarriorAnt().getShortId() + ": Error in sending HttpResponsePartMessage" + " - Cannot send to id " + httpResponsePartMessage.getDest()));
                    this.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpResponsePartError", null, this.requestMessage);
                    this.wa.propertyChangeSupport.removePropertyChangeListener(this);
                    return;
                }
                EndpointSecurityManager esm = this.getWarriorAnt().getInputSecureConnectionManager(this.requestMessage.getSource());
                if (esm == null) {
                    SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                    wm = this.wa.sendMessage(fterrcm, this.requestMessage.getSource(), false, false);
                    _logger.debug((Object)(this.wa.getShortId() + ": No secure connection with " + this.requestMessage.getSource()));
                    while (this.wa.myMessages.contains(wm) && !this.terminate) {
                        Thread.sleep(1000L);
                    }
                    if (this.wa.failedMessages.contains(wm)) {
                        this.wa.failedMessages.remove(wm);
                        _logger.debug((Object)(this.wa.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                    }
                    throw new Exception("No secure connection avaiable with endpoint " + this.requestMessage.getSource());
                }
                HttpResponsePartMessage httpResponsePartMessage = new HttpResponsePartMessage(response, this.requestMessage, new Integer(this.currentId++));
                httpResponsePartMessage.encrypt(esm.getCipherEnc());
                wm = this.getWarriorAnt().sendMessage(httpResponsePartMessage, this.requestMessage.getSource(), false, false);
                while (this.getWarriorAnt().myMessages.contains(wm)) {
                    Thread.sleep(1000L);
                }
                if (!this.getWarriorAnt().failedMessages.contains(wm)) continue;
                httpResponsePartMessage.decrypt(esm.getCipherDec());
                this.getWarriorAnt().failedMessages.remove(wm);
                _logger.debug((Object)(this.getWarriorAnt().getShortId() + ": Error in sending HttpResponsePartMessage" + " - Cannot send to id " + httpResponsePartMessage.getDest()));
                this.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpResponsePartError", null, this.requestMessage);
                this.wa.propertyChangeSupport.removePropertyChangeListener(this);
                return;
            }
            while (!this.terminate && sentMessages.size() > 0 && !this.getWarriorAnt().areInFailedMessages(sentMessages)) {
                this.wa.removeDeliveredMessagesFromList(sentMessages);
                Thread.sleep(1000L);
            }
            if (this.getWarriorAnt().areInFailedMessages(sentMessages)) {
                this.getWarriorAnt().failedMessages.removeAll(sentMessages);
                _logger.debug((Object)(this.getWarriorAnt().getShortId() + ": Error in sending HttpResponsePartMessage" + " - Cannot send to id " + this.requestMessage.getSource()));
                this.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpResponsePartError", null, this.requestMessage);
                this.wa.propertyChangeSupport.removePropertyChangeListener(this);
                return;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error in serving request", (Throwable)e);
        }
        if (this.terminate) {
            try {
                s.shutdownInput();
                s.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.wa.propertyChangeSupport.removePropertyChangeListener(this);
            return;
        }
        try {
            EndpointSecurityManager esm = this.getWarriorAnt().getInputSecureConnectionManager(this.requestMessage.getSource());
            if (esm == null) {
                SecureConnectionErrorControlMessage fterrcm = new SecureConnectionErrorControlMessage(new Integer(0), null, "No secure connection");
                MessageWrapper wm = this.wa.sendMessage(fterrcm, this.requestMessage.getSource(), false, false);
                _logger.debug((Object)(this.wa.getShortId() + ": No secure connection with " + this.requestMessage.getSource()));
                while (this.wa.myMessages.contains(wm) && !this.terminate) {
                    Thread.sleep(1000L);
                }
                if (this.wa.failedMessages.contains(wm)) {
                    this.wa.failedMessages.remove(wm);
                    _logger.debug((Object)(this.wa.getShortId() + ": Error in sending ControlMessage " + fterrcm.getMessage()));
                }
                throw new Exception("No secure connection avaiable with endpoint " + this.requestMessage.getSource());
            }
            HttpTransferEndControlMessage httpTransferEndControlMessage = new HttpTransferEndControlMessage(new Integer(0), null, "HttpTransfer ended", this.requestMessage);
            httpTransferEndControlMessage.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.getWarriorAnt().sendMessage(httpTransferEndControlMessage, this.requestMessage.getSource(), false, false);
            while (this.getWarriorAnt().myMessages.contains(wm)) {
                Thread.sleep(1000L);
            }
            if (this.getWarriorAnt().failedMessages.contains(wm)) {
                httpTransferEndControlMessage.decrypt(esm.getCipherDec());
                this.getWarriorAnt().failedMessages.remove(wm);
                _logger.debug((Object)(this.getWarriorAnt().getShortId() + ": Error in sending HttpResponsePartMessage" + " - Cannot send to id " + httpTransferEndControlMessage.getDest()));
                this.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpResponsePartError", null, this.requestMessage);
                this.wa.propertyChangeSupport.removePropertyChangeListener(this);
                return;
            }
            _logger.debug((Object)"End of Response");
            s.shutdownInput();
            s.close();
        }
        catch (Exception e) {
            _logger.error((Object)"Error in sending end of response", (Throwable)e);
        }
        this.wa.propertyChangeSupport.removePropertyChangeListener(this);
    }
}

