/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.messages;

import ants.p2p.Message;
import ants.p2p.messages.FilePushMessage;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;

public class FilePartMessage
extends Message {
    Object content;
    Object hash;
    Object partId;
    Object fpm;

    public FilePartMessage(Message m, byte[] content, byte[] hash, Long partId, FilePushMessage fpm) {
        super(m);
        this.fpm = fpm;
        this.content = content;
        this.hash = hash;
        this.partId = partId;
    }

    public FilePartMessage(byte[] content, byte[] hash, Long partId, FilePushMessage fpm) {
        this.fpm = fpm;
        this.content = content;
        this.hash = hash;
        this.partId = partId;
    }

    public byte[] getContent() {
        if (this.content instanceof byte[]) {
            return (byte[])this.content;
        }
        return null;
    }

    public byte[] getHash() {
        if (this.hash instanceof byte[]) {
            return (byte[])this.hash;
        }
        return null;
    }

    public Long getPartId() {
        if (this.partId instanceof Long) {
            return (Long)this.partId;
        }
        return null;
    }

    public FilePushMessage getFilePushMessage() {
        if (this.fpm instanceof FilePushMessage) {
            return (FilePushMessage)this.fpm;
        }
        return null;
    }

    public void encrypt(Cipher c) throws Exception {
        this.content = new SealedObject((Serializable)((byte[])this.content), c);
        this.hash = new SealedObject((Serializable)((byte[])this.hash), c);
        this.partId = new SealedObject((Long)this.partId, c);
        this.fpm = new SealedObject((FilePushMessage)this.fpm, c);
    }

    public void decrypt(Cipher c) throws Exception {
        this.content = (byte[])((SealedObject)this.content).getObject(c);
        this.hash = (byte[])((SealedObject)this.hash).getObject(c);
        this.partId = (Long)((SealedObject)this.partId).getObject(c);
        this.fpm = (FilePushMessage)((SealedObject)this.fpm).getObject(c);
    }
}

