/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.messages.security;

import ants.p2p.Message;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.X509EncodedKeySpec;

public class MessageSigner {
    KeyPair pair;
    byte[] encodedPublic;
    static MessageSigner instance = null;
    public static final long[] sizeLimits = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, (long)Math.pow(2.0, 10.0) * 15L};

    MessageSigner() throws Exception {
        long userSeed = System.currentTimeMillis();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        random.setSeed(userSeed);
        keyGen.initialize(1024, random);
        this.pair = keyGen.generateKeyPair();
        this.encodedPublic = this.pair.getPublic().getEncoded();
    }

    public void sign(Message m) throws Exception {
        Message signable = m.getSignableMessage();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(signable);
        oos.close();
        Signature dsa = Signature.getInstance("SHA1withDSA");
        dsa.initSign(this.pair.getPrivate());
        dsa.update(baos.toByteArray());
        m.setSignature(dsa.sign());
        m.setPublicKey(this.encodedPublic);
    }

    public static MessageSigner getInstance() throws Exception {
        if (instance == null) {
            instance = new MessageSigner();
            return instance;
        }
        return instance;
    }

    public String getPublicKey() {
        return ((DSAPublicKey)this.pair.getPublic()).getY().toString();
    }

    public boolean verifySignature(Message m, String Y) throws Exception {
        if (Y == null || Y.equals("")) {
            return true;
        }
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(m.getPublicKey());
        KeyFactory keyFact = KeyFactory.getInstance("DSA");
        DSAPublicKey pubk = (DSAPublicKey)keyFact.generatePublic(x509KeySpec);
        if (!pubk.getY().toString().equals(Y)) {
            System.out.println("Source doesn't match:\n" + pubk.getY() + "\n" + Y);
            return false;
        }
        Signature dsa = Signature.getInstance("SHA1withDSA");
        dsa.initVerify(pubk);
        byte[] signature = m.getSignature();
        Message signable = m.getSignableMessage();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(signable);
        oos.close();
        dsa.update(baos.toByteArray());
        return dsa.verify(signature);
    }

    public boolean verifySize(Message m) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(m);
        oos.close();
        return m.getType() < sizeLimits.length && (long)baos.toByteArray().length <= sizeLimits[m.getType()];
    }
}

