/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRemoteFileTuple;
import java.util.ArrayList;
import java.util.Date;
import ji.JI;

public class FileTupleGroup {
    public ArrayList tuples;
    String hash;
    Long size;

    public FileTupleGroup(String hash, Long size) {
        this.hash = hash;
        this.size = size;
        this.tuples = new ArrayList();
    }

    public String getHash() {
        return this.hash;
    }

    public Long getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o instanceof FileTupleGroup) {
            return ((FileTupleGroup)o).getHash().equals(this.getHash()) && ((FileTupleGroup)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryCompletedFileTuple) {
            return ((QueryCompletedFileTuple)o).getFileHash().equals(this.getHash()) && ((QueryCompletedFileTuple)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryPartialFileTuple) {
            return ((QueryPartialFileTuple)o).getFileHash().equals(this.getHash()) && ((QueryPartialFileTuple)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryRemoteFileTuple) {
            return ((QueryRemoteFileTuple)o).getFileHash().equals(this.getHash()) && ((QueryRemoteFileTuple)o).getSize().longValue() == this.getSize().longValue();
        }
        return o == this;
    }

    public long getLastTimeSeen() {
        long lts = 0L;
        for (int x = 0; x < this.tuples.size(); ++x) {
            if (!(this.tuples.get(x) instanceof QueryRemoteFileTuple) || lts >= ((QueryRemoteFileTuple)this.tuples.get(x)).getLastTimeSeen()) {
                lts = System.currentTimeMillis();
                break;
            }
            lts = ((QueryRemoteFileTuple)this.tuples.get(x)).getLastTimeSeen();
        }
        return lts;
    }

    public String toString() {
        int owners = this.tuples.size();
        if (this.tuples.size() == 1 && this.tuples.get(0) instanceof QueryRemoteFileTuple) {
            owners = 0;
        }
        String result = this.getHash() + "  " + JI.i("Owners") + ": " + owners;
        while (result.length() < 50) {
            result = result + " ";
        }
        result = result + "  " + this.sizeToString(this.getSize().longValue());
        result = result + " ";
        while (result.length() < 70) {
            result = result + " ";
        }
        result = result + " " + ((QueryFileTuple)this.tuples.get(0)).getFileName();
        result = result + JI.i(" [Last seen on") + ": " + new Date(this.getLastTimeSeen()) + "]    " + ((QueryFileTuple)this.tuples.get(0)).getExtendedInfos();
        return result;
    }

    public String sizeToString(double dSize) {
        int index;
        int x;
        double currentSize = dSize;
        dSize /= Math.pow(2.0, 20.0);
        for (x = 1; dSize > 1.0 && x < 5; dSize /= Math.pow(2.0, 10.0), ++x) {
        }
        String suffix = " bytes";
        String size = currentSize + suffix;
        if (x == 2) {
            suffix = " Mib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 20.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 3) {
            suffix = " Gib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 30.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 4) {
            suffix = " Tib";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 40.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        return size;
    }
}

