/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query.security;

import ants.p2p.utils.encoding.Base16;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class PublicHeader
implements Serializable {
    BigInteger exp;
    BigInteger mod;
    String sessionKey;
    String encryptedSessionKey;

    public PublicHeader(BigInteger exp, BigInteger mod) {
        this.exp = exp;
        this.mod = mod;
    }

    protected PublicHeader() {
    }

    public void encryptSessionKey() throws Exception {
        this.encryptedSessionKey = this.generate();
    }

    public void invalidateSessionKey() {
        this.sessionKey = null;
    }

    public BigInteger getExp() {
        return this.exp;
    }

    public BigInteger getMod() {
        return this.mod;
    }

    private String generate() throws Exception {
        RSAKeyParameters pubParameters = new RSAKeyParameters(false, this.mod, this.exp);
        PKCS1Encoding eng = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        eng.init(true, (CipherParameters)pubParameters);
        byte[] data = Base16.fromHexString(this.sessionKey);
        data = eng.processBlock(data, 0, data.length);
        return Base16.toHexString(data);
    }

    public void generateSessionKey() throws Exception {
        byte[] sessionBytes = new byte[16];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(sessionBytes);
        for (int x = 0; x < sessionBytes.length; ++x) {
            if (sessionBytes[x] >= 0) continue;
            sessionBytes[x] = (byte)Math.abs(sessionBytes[x]);
        }
        this.sessionKey = Base16.toHexString(sessionBytes);
        this.encryptSessionKey();
    }

    public String getBase16SessionKey() {
        return this.sessionKey;
    }

    public String getEncryptedSessionKey() {
        return this.encryptedSessionKey;
    }

    public Cipher getEncCipher() throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(Base16.fromHexString(this.sessionKey), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, skeySpec);
        return cipher;
    }
}

