/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.Ant;
import ants.p2p.security.sockets.RequestsHandler;
import com.sun.net.ssl.internal.ssl.Provider;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.log4j.Logger;

public class SecureServer
implements Runnable {
    String KEYSTORE = "certs";
    char[] KEYSTOREPW = "serverkspw".toCharArray();
    char[] KEYPW = "serverpw".toCharArray();
    int serverPort = 443;
    ServerSocket serverSocket = null;
    static Logger _logger = Logger.getLogger((String)SecureServer.class.getName());
    public Thread serverThread;
    Ant n;

    public SecureServer(Ant n, int port) throws Exception {
        this.n = n;
        this.serverPort = port;
        this.serverSocket = this.createServerSocket();
        try {
            this.serverThread = new Thread(this);
            this.serverThread.setPriority(10);
            this.serverThread.start();
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
        }
    }

    public SecureServer(Ant n) throws Exception, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.n = n;
        this.serverSocket = this.createServerSocket();
        this.serverThread = new Thread(this);
        this.serverThread.setPriority(10);
        this.serverThread.start();
    }

    public void listen() {
        this.n.uPnPMapping();
        while (!this.n.isDisconnected() && !this.serverSocket.isClosed()) {
            try {
                _logger.info((Object)(this.n.getShortId() + " :Server Listening..."));
                Socket localSocket = this.serverSocket.accept();
                if (localSocket == null) continue;
                RequestsHandler handler = new RequestsHandler(this, localSocket);
                handler.start();
            }
            catch (Exception e) {
                _logger.error((Object)("Secure Server Socket listen cycle: " + this.serverSocket.getLocalPort() + " "), (Throwable)e);
                this.n.disconnect();
            }
        }
        _logger.info((Object)("Secure Server Socket closed: " + this.serverSocket.getLocalPort()));
    }

    public void run() {
        this.listen();
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private ServerSocket createServerSocket() throws Exception {
        Security.addProvider((java.security.Provider)new Provider());
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(this.getClass().getClassLoader().getResource(this.KEYSTORE).openStream(), this.KEYSTOREPW);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, this.KEYPW);
        SSLContext sslc = SSLContext.getInstance("TLSv1");
        sslc.init(kmf.getKeyManagers(), null, null);
        SSLServerSocketFactory ssf = sslc.getServerSocketFactory();
        SSLServerSocket serverSocket = (SSLServerSocket)ssf.createServerSocket(this.serverPort);
        return serverSocket;
    }
}

