/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils.indexer;

import ants.p2p.filesharing.InterruptedDownload;
import ants.p2p.filesharing.MultipleSourcesDownloadManager;
import ants.p2p.filesharing.WarriorAnt;
import ants.p2p.gui.SettingsAntPanel;
import ants.p2p.query.HttpServerInfo;
import ants.p2p.query.QueryFileListItem;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryHashItem;
import ants.p2p.query.QueryManager;
import ants.p2p.query.QueryMessage;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRandomItem;
import ants.p2p.query.QueryRemoteFileTuple;
import ants.p2p.query.QueryStringItem;
import ants.p2p.query.QuerySupernodeTuple;
import ants.p2p.utils.donkey.DonkeyHashFile;
import ants.p2p.utils.encoding.StringHash;
import ants.p2p.utils.indexer.DigestManager;
import ants.p2p.utils.indexer.DirInfos;
import ants.p2p.utils.indexer.FileDocument;
import ants.p2p.utils.indexer.FileInfos;
import ants.p2p.utils.indexer.IndexerGraphicEngine;
import ants.p2p.utils.indexer.PartialFileDocument;
import ants.p2p.utils.indexer.RemoteFileDocument;
import ants.p2p.utils.indexer.RemoteFileInfos;
import ants.p2p.utils.indexer.SupernodeEngine;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import ji.JI;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class BackgroundEngine
extends Thread
implements PropertyChangeListener {
    Hashtable partialFiles = new Hashtable();
    Hashtable partialED2KFiles = new Hashtable();
    public Hashtable sharedFilesIndexName = new Hashtable();
    public Hashtable sharedFilesIndexHash = new Hashtable();
    public Hashtable sharedFilesIndexED2KHash = new Hashtable();
    public ArrayList sharedDirectories = new ArrayList();
    public Hashtable nestedDirectories = new Hashtable();
    public Hashtable remoteFilesIndexHash = new Hashtable();
    public Hashtable remoteFilesIndexED2KHash = new Hashtable();
    long totalLocalSharedFileSize = 0L;
    long totalRemoteSharedFileSize = 0L;
    Hashtable supernodeList = new Hashtable();
    Hashtable httpServers = new Hashtable();
    int uploadListToSupernodes = 3;
    ArrayList lastUsedSuperNodes = new ArrayList();
    int isUploadingFileList = 0;
    public Hashtable lastTimeUploadedFileList = new Hashtable();
    public boolean forceUploadingLists = false;
    Hashtable lastUploadedLists = new Hashtable();
    SupernodeEngine supernodeEngine = new SupernodeEngine(this);
    static BackgroundEngine instance;
    public static int refreshRate;
    public static int maxRemoteDocsToTrace;
    public static int broadcastTimeToLive;
    public static int remoteIndexedDocumentsTimeout;
    public static boolean shareDownloadPath;
    File store = new File(WarriorAnt.workingPath + "/sharedFiles.ant");
    File remoteSharedStore = new File(WarriorAnt.workingPath + "/remoteSharedFiles.ant");
    File storeIndex = new File(WarriorAnt.workingPath + "/sharedIndex");
    File remoteStoreIndex = new File(WarriorAnt.workingPath + "/remoteSharedIndex");
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    QueryMessage currentQuery = null;
    WarriorAnt wa = null;
    static Logger _logger;
    public static boolean recursiveExplore;
    private boolean synchronizingRemote = false;
    private boolean loggingOut = false;
    boolean terminate = false;
    boolean resetCycle = false;
    boolean forceIndexing = false;
    String localIndexMonitor = "";

    public static BackgroundEngine getInstance(File store) {
        try {
            if (instance == null) {
                instance = new BackgroundEngine(store);
                instance.setPriority(1);
                instance.start();
                return instance;
            }
            return instance;
        }
        catch (Exception ex) {
            _logger.error((Object)"", (Throwable)ex);
            return null;
        }
    }

    public static BackgroundEngine getInstance() {
        try {
            if (instance == null) {
                instance = new BackgroundEngine();
                instance.start();
                return instance;
            }
            return instance;
        }
        catch (Exception ex) {
            _logger.error((Object)"", (Throwable)ex);
            return null;
        }
    }

    public void terminate(boolean join) {
        this.terminate = true;
        if (join) {
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                _logger.error((Object)"BackgroundEngine interrupted", (Throwable)ex);
            }
            instance = null;
        }
    }

    public Hashtable getSupernodeList() {
        return this.supernodeList;
    }

    public Hashtable getHttpServersList() {
        return this.httpServers;
    }

    public long getTotalLocalSharedSize() {
        return this.totalLocalSharedFileSize;
    }

    public long getTotalRemoteSharedSize() {
        return this.totalRemoteSharedFileSize;
    }

    public int getSupernodesSize() {
        return this.supernodeList.size();
    }

    public int getHttpServersSize() {
        return this.httpServers.size();
    }

    public long computeRemoteIndexedSharedSize() {
        long sharedSize = 0L;
        Enumeration keys = this.supernodeList.keys();
        while (keys.hasMoreElements()) {
            String curKey = (String)keys.nextElement();
            QuerySupernodeTuple qst = (QuerySupernodeTuple)this.supernodeList.get(curKey);
            if (qst == null) continue;
            sharedSize += qst.getTotalShareDimension().longValue();
        }
        return sharedSize;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.addPropertyChangeListener(pcl);
        DigestManager.addPropertyChangeListener(pcl);
        DonkeyHashFile.addPropertyChangeListener(pcl);
        IndexerGraphicEngine.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.removePropertyChangeListener(pcl);
        DigestManager.removePropertyChangeListener(pcl);
        DonkeyHashFile.removePropertyChangeListener(pcl);
        IndexerGraphicEngine.removePropertyChangeListener(pcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartialFile(MultipleSourcesDownloadManager msdm) {
        String string = this.localIndexMonitor;
        synchronized (string) {
            this.partialFiles.put(msdm.getFileHash(), msdm);
            this.partialED2KFiles.put(msdm.getED2KFileHash(), msdm);
            this.forceUploadingLists = true;
            try {
                IndexWriter writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), false);
                writer.addDocument(PartialFileDocument.Document(msdm));
                writer.close();
            }
            catch (IOException e) {
                _logger.error((Object)("Error in indexing partial file: " + msdm.getFileHash()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartialFile(InterruptedDownload id) {
        String string = this.localIndexMonitor;
        synchronized (string) {
            this.partialFiles.put(id.getFileHash(), id);
            this.partialED2KFiles.put(id.getED2KFileHash(), id);
            this.forceUploadingLists = true;
            try {
                IndexWriter writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), false);
                writer.addDocument(PartialFileDocument.Document(id));
                writer.close();
            }
            catch (IOException e) {
                _logger.error((Object)("Error in indexing partial file: " + id.getFileHash()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPartialFiles() {
        String string = this.localIndexMonitor;
        synchronized (string) {
            Enumeration keys = this.partialFiles.keys();
            while (keys.hasMoreElements()) {
                String hash = null;
                try {
                    hash = (String)keys.nextElement();
                    IndexReader reader = IndexReader.open((File)this.storeIndex);
                    Term term = new Term("PartialFileHash", hash);
                    int deleted = reader.delete(term);
                    reader.close();
                }
                catch (IOException e) {
                    _logger.error((Object)("Error in removing partial file from index: " + hash), (Throwable)e);
                }
            }
            this.partialFiles = new Hashtable();
            this.partialED2KFiles = new Hashtable();
            this.forceUploadingLists = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartialFile(String hash) {
        String string = this.localIndexMonitor;
        synchronized (string) {
            Object pf = this.getPartialFile(hash, QueryHashItem.ANTS_HASH);
            if (pf instanceof MultipleSourcesDownloadManager) {
                this.partialED2KFiles.remove(((MultipleSourcesDownloadManager)pf).getED2KFileHash());
            } else if (pf instanceof InterruptedDownload) {
                this.partialED2KFiles.remove(((InterruptedDownload)pf).getED2KFileHash());
            }
            this.partialFiles.remove(hash);
            this.forceUploadingLists = true;
            try {
                IndexReader reader = IndexReader.open((File)this.storeIndex);
                Term term = new Term("PartialFileHash", hash);
                int deleted = reader.delete(term);
                reader.close();
            }
            catch (IOException e) {
                _logger.error((Object)("Error in removing partial file from index: " + hash), (Throwable)e);
            }
        }
    }

    public void addRemoteFile(QueryFileTuple qft) {
        try {
            RemoteFileInfos localCached;
            QueryRemoteFileTuple qrft;
            if (this.remoteFilesIndexHash.size() > maxRemoteDocsToTrace) {
                Enumeration keys = this.remoteFilesIndexHash.keys();
                Object toBeRemoved = keys.nextElement();
                RemoteFileInfos rfiRemoved = (RemoteFileInfos)this.remoteFilesIndexHash.remove(toBeRemoved);
                this.remoteFilesIndexED2KHash.remove(rfiRemoved.getED2KFileHash());
            }
            if (qft instanceof QueryRemoteFileTuple && (qrft = (QueryRemoteFileTuple)qft).getLastTimeSeen() > System.currentTimeMillis()) {
                qrft.resetLastTimeSeen();
            }
            if (this.remoteFilesIndexHash.get(qft.getFileHash()) != null) {
                localCached = (RemoteFileInfos)this.remoteFilesIndexHash.get(qft.getFileHash());
                if (localCached.getOwners().get(qft.getOwnerID()) == null) {
                    if (qft instanceof QueryRemoteFileTuple) {
                        QueryRemoteFileTuple qrft2 = (QueryRemoteFileTuple)qft;
                        localCached.getOwners().put(qrft2.getOwnerID(), qrft2.getLastTimeSeen());
                    } else {
                        localCached.getOwners().put(qft.getOwnerID(), new Long(System.currentTimeMillis()));
                    }
                } else {
                    Long lastTimeSeen = (Long)localCached.getOwners().get(qft.getOwnerID());
                    if (qft instanceof QueryRemoteFileTuple) {
                        QueryRemoteFileTuple qrft3 = (QueryRemoteFileTuple)qft;
                        if (lastTimeSeen < qrft3.getLastTimeSeen()) {
                            localCached.getOwners().put(qrft3.getOwnerID(), qrft3.getLastTimeSeen());
                        }
                    } else {
                        localCached.getOwners().put(qft.getOwnerID(), new Long(System.currentTimeMillis()));
                    }
                    _logger.debug((Object)("Added remote source [" + qft.getOwnerID().substring(0, 10) + "] " + qft.getFileName()));
                }
                this.remoteFilesIndexHash.put(localCached.getHash(), localCached);
                this.remoteFilesIndexED2KHash.put(localCached.getED2KFileHash(), localCached);
            } else {
                localCached = new RemoteFileInfos(qft);
                this.remoteFilesIndexHash.put(localCached.getHash(), localCached);
                this.remoteFilesIndexED2KHash.put(localCached.getED2KFileHash(), localCached);
                _logger.debug((Object)("Added new remote file [" + qft.getOwnerID().substring(0, 10) + "] " + qft.getFileName()));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot add the remote file", (Throwable)ex);
        }
    }

    public Enumeration getPartialFiles() {
        return this.partialFiles.keys();
    }

    public ArrayList getPartialFilesHashes() {
        ArrayList<StringHash> hashes = new ArrayList<StringHash>();
        Enumeration keys = this.partialFiles.keys();
        while (keys.hasMoreElements()) {
            hashes.add(new StringHash((String)keys.nextElement()));
        }
        return hashes;
    }

    public Object getPartialFile(String hash, String hashType) {
        if (hashType.equals(QueryHashItem.ANTS_HASH)) {
            return this.partialFiles.get(hash);
        }
        if (hashType.equals(QueryHashItem.ED2K_HASH)) {
            return this.partialED2KFiles.get(hash);
        }
        return null;
    }

    public RemoteFileInfos getRemoteFile(String hash, String hashType) {
        if (hashType.equals(QueryHashItem.ANTS_HASH)) {
            return (RemoteFileInfos)this.remoteFilesIndexHash.get(hash);
        }
        if (hashType.equals(QueryHashItem.ED2K_HASH)) {
            return (RemoteFileInfos)this.remoteFilesIndexED2KHash.get(hash);
        }
        return null;
    }

    public FileInfos getLocalFile(String hash, String hashType) {
        if (hashType.equals(QueryHashItem.ANTS_HASH)) {
            return this.getLocalFileANts(hash);
        }
        if (hashType.equals(QueryHashItem.ED2K_HASH)) {
            return this.getLocalFileED2K(hash);
        }
        return null;
    }

    private FileInfos getLocalFileANts(String hash) {
        return (FileInfos)this.sharedFilesIndexHash.get(hash);
    }

    private FileInfos getLocalFileED2K(String hash) {
        return (FileInfos)this.sharedFilesIndexED2KHash.get(hash);
    }

    public QueryPartialFileTuple getPartialFileTuple(String sessionKey, String fileHash, String type, String ownerID, Integer freeSlots, String connectionType, boolean getChunkHashes) {
        Object partialFile = this.getPartialFile(fileHash, type);
        String ed2kFileHash = null;
        Object[] chunkHashes = null;
        String fileName = null;
        Long fileLength = null;
        Integer blockSize = null;
        Integer blocksPerSource = null;
        String percentage = null;
        String extendedInfos = null;
        boolean[] downloadedBlockGroups = null;
        if (partialFile instanceof MultipleSourcesDownloadManager) {
            MultipleSourcesDownloadManager msdmPartialFile = (MultipleSourcesDownloadManager)partialFile;
            ed2kFileHash = msdmPartialFile.getED2KFileHash();
            chunkHashes = msdmPartialFile.getChunkHashes();
            fileName = msdmPartialFile.getFileName();
            fileLength = new Long(msdmPartialFile.getFileSize());
            blockSize = new Integer(msdmPartialFile.getBlockSize());
            blocksPerSource = new Integer(MultipleSourcesDownloadManager.blocksPerSource);
            downloadedBlockGroups = msdmPartialFile.getDownloadedBlockGroups();
            percentage = msdmPartialFile.getPercentage();
            extendedInfos = msdmPartialFile.getExtendedInfos();
        } else if (partialFile instanceof InterruptedDownload) {
            InterruptedDownload idPartialFile = (InterruptedDownload)partialFile;
            ed2kFileHash = idPartialFile.getED2KFileHash();
            chunkHashes = idPartialFile.getChunkHashes();
            fileName = idPartialFile.getFileName();
            fileLength = new Long(idPartialFile.getFileSize());
            blockSize = new Integer(idPartialFile.getBlockSize());
            blocksPerSource = new Integer(MultipleSourcesDownloadManager.blocksPerSource);
            downloadedBlockGroups = idPartialFile.getDownloadedBlockGroups();
            percentage = idPartialFile.getPercentage();
            extendedInfos = idPartialFile.getExtendedInfos();
        }
        if (fileName != null && fileLength != null && blockSize != null && downloadedBlockGroups != null && percentage != null) {
            return new QueryPartialFileTuple(sessionKey, fileName, fileHash, ed2kFileHash, (Object[])(getChunkHashes ? chunkHashes : null), fileLength, blockSize, blocksPerSource, downloadedBlockGroups, ownerID, this.wa.getLocalInetAddress(), freeSlots, connectionType, percentage, extendedInfos);
        }
        throw new NullPointerException("Null pointer in QueryPartialFileTuple parameters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeLocalIndex(boolean optimize, boolean showExit) throws Exception {
        JFrame waitingFrame = this.showWorkingFrame(showExit);
        try {
            String string = this.localIndexMonitor;
            synchronized (string) {
                IndexReader reader = IndexReader.open((File)this.storeIndex);
                ArrayList filesArray = new ArrayList();
                Enumeration filesEnum = this.sharedFilesIndexName.keys();
                while (filesEnum.hasMoreElements()) {
                    filesArray.add(filesEnum.nextElement());
                }
                for (int i = 0; i < reader.maxDoc() && !this.terminate; ++i) {
                    if (reader.isDeleted(i)) continue;
                    Document document = reader.document(i);
                    String path = document.get("Path");
                    if (!filesArray.contains(path)) {
                        reader.delete(i);
                        continue;
                    }
                    filesArray.remove(path);
                }
                reader.close();
                IndexWriter writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), false);
                for (int i = 0; i < filesArray.size() && !this.terminate; ++i) {
                    File curFile = new File((String)filesArray.get(i));
                    FileInfos fI = (FileInfos)this.sharedFilesIndexName.get(filesArray.get(i));
                    if (!curFile.exists() || !curFile.isFile()) continue;
                    writer.addDocument(FileDocument.Document(fI));
                }
                if (optimize) {
                    writer.optimize();
                }
                writer.close();
                waitingFrame.setVisible(false);
            }
        }
        catch (Exception e) {
            waitingFrame.setVisible(false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeRemoteIndex(boolean showFrame) throws Exception {
        BackgroundEngine backgroundEngine = this;
        synchronized (backgroundEngine) {
            if (this.loggingOut) {
                return;
            }
            while (this.synchronizingRemote) {
                this.wait();
            }
            this.synchronizingRemote = true;
        }
        JFrame waitingFrame = null;
        if (showFrame) {
            waitingFrame = this.showWorkingFrame(true);
        }
        IndexReader reader = null;
        IndexWriter writer = null;
        try {
            int i;
            reader = IndexReader.open((File)this.remoteStoreIndex);
            ArrayList remoteFilesArray = new ArrayList();
            Enumeration remoteFilesEnum = this.remoteFilesIndexHash.keys();
            while (remoteFilesEnum.hasMoreElements()) {
                remoteFilesArray.add(remoteFilesEnum.nextElement());
            }
            for (i = 0; i < reader.maxDoc() && !this.terminate; ++i) {
                if (reader.isDeleted(i)) continue;
                Document document = reader.document(i);
                String remoteHash = document.get("RemoteFileHash");
                if (!remoteFilesArray.contains(remoteHash) || !((RemoteFileInfos)this.remoteFilesIndexHash.get(remoteHash)).hasSources(remoteIndexedDocumentsTimeout)) {
                    reader.delete(i);
                    RemoteFileInfos rfi = (RemoteFileInfos)this.remoteFilesIndexHash.get(remoteHash);
                    if (rfi != null) {
                        this.remoteFilesIndexHash.remove(remoteHash);
                        this.remoteFilesIndexED2KHash.remove(rfi.getED2KFileHash());
                    }
                }
                remoteFilesArray.remove(remoteHash);
            }
            reader.close();
            writer = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), false);
            for (i = 0; i < remoteFilesArray.size() && !this.terminate; ++i) {
                RemoteFileInfos rfi = (RemoteFileInfos)this.remoteFilesIndexHash.get(remoteFilesArray.get(i));
                if (rfi != null && rfi.hasSources(remoteIndexedDocumentsTimeout)) {
                    writer.addDocument(RemoteFileDocument.Document(rfi));
                    continue;
                }
                this.remoteFilesIndexHash.remove(remoteFilesArray.get(i));
                this.remoteFilesIndexED2KHash.remove(rfi.getED2KFileHash());
            }
            if (showFrame) {
                writer.optimize();
            }
            writer.close();
            this.storeRemote(this.remoteSharedStore);
            if (showFrame) {
                waitingFrame.setVisible(false);
            }
            BackgroundEngine backgroundEngine2 = this;
            synchronized (backgroundEngine2) {
                this.synchronizingRemote = false;
                this.notifyAll();
            }
        }
        catch (Exception e) {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (showFrame) {
                waitingFrame.setVisible(false);
            }
            BackgroundEngine backgroundEngine3 = this;
            synchronized (backgroundEngine3) {
                this.synchronizingRemote = false;
                this.notifyAll();
            }
            throw e;
        }
    }

    private void showErrorFrame() {
        final JFrame connectionDialog = new JFrame("ANts Fatal Error");
        connectionDialog.getContentPane().setLayout(new FlowLayout(1));
        connectionDialog.getContentPane().add(new JLabel("A former ANts intance wasn't able to clear lucene cache, you need to restart ANts."));
        JButton confirmConnection = new JButton("Ok");
        confirmConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                connectionDialog.setVisible(false);
            }
        });
        connectionDialog.getContentPane().add(confirmConnection);
        connectionDialog.pack();
        connectionDialog.setLocation(300, 300);
        SettingsAntPanel.setLookAndFeel(connectionDialog);
        connectionDialog.setVisible(true);
        while (connectionDialog.isVisible()) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private JFrame showWorkingFrame(boolean showExit) {
        JFrame connectionDialog = new JFrame(JI.i("ANts Indexing"));
        connectionDialog.getContentPane().setLayout(new FlowLayout(1));
        connectionDialog.getContentPane().add(new JLabel(JI.i("ANts is synchronizing your index. Please wait...")));
        if (showExit) {
            JButton confirmConnection = new JButton("Exit");
            confirmConnection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BackgroundEngine.this.terminate(true);
                    System.exit(0);
                }
            });
            connectionDialog.getContentPane().add(confirmConnection);
        }
        connectionDialog.pack();
        connectionDialog.setLocation(300, 300);
        SettingsAntPanel.setLookAndFeel(connectionDialog);
        connectionDialog.setVisible(true);
        return connectionDialog;
    }

    private void initializeIndexes() {
        IndexWriter writer;
        IndexWriter writer2;
        boolean deleted;
        File[] files;
        if (this.store.exists() && IndexReader.indexExists((File)this.storeIndex)) {
            try {
                this.load(this.store);
                this.synchronizeLocalIndex(false, true);
            }
            catch (Exception e) {
                _logger.error((Object)"Error in synchronizing index", (Throwable)e);
                try {
                    files = this.storeIndex.listFiles();
                    for (int x = 0; x < files.length; ++x) {
                        deleted = files[x].delete();
                        System.out.println(files[x].getName() + " " + deleted);
                        if (deleted) continue;
                        files[x].deleteOnExit();
                    }
                    this.storeIndex.delete();
                    writer2 = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), true);
                    writer2.optimize();
                    writer2.close();
                    this.synchronizeLocalIndex(false, true);
                }
                catch (Exception ex) {
                    _logger.error((Object)"Fatal error in creating index", (Throwable)ex);
                    this.showErrorFrame();
                    System.exit(0);
                }
            }
        } else if (this.store.exists() && !IndexReader.indexExists((File)this.storeIndex)) {
            try {
                writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), true);
                writer.optimize();
                writer.close();
            }
            catch (IOException e) {
                _logger.error((Object)"Cannot create index", (Throwable)e);
                System.exit(0);
            }
            try {
                this.load(this.store);
                this.synchronizeLocalIndex(false, true);
            }
            catch (Exception e) {
                _logger.error((Object)"Error in synchronizing index", (Throwable)e);
                try {
                    files = this.storeIndex.listFiles();
                    for (int x = 0; x < files.length; ++x) {
                        deleted = files[x].delete();
                        System.out.println(files[x].getName() + " " + deleted);
                        if (deleted) continue;
                        files[x].deleteOnExit();
                    }
                    this.storeIndex.delete();
                    writer2 = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), true);
                    writer2.optimize();
                    writer2.close();
                    this.synchronizeLocalIndex(false, true);
                }
                catch (Exception ex) {
                    _logger.error((Object)"Fatal error in creating index", (Throwable)ex);
                    this.showErrorFrame();
                    System.exit(0);
                }
            }
        } else if (!this.store.exists() && !IndexReader.indexExists((File)this.storeIndex) || !this.store.exists() && IndexReader.indexExists((File)this.storeIndex)) {
            try {
                writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), true);
                writer.optimize();
                writer.close();
            }
            catch (IOException e) {
                _logger.error((Object)"Cannot create index", (Throwable)e);
                System.exit(0);
            }
        }
        if (this.remoteSharedStore.exists() && IndexReader.indexExists((File)this.remoteStoreIndex)) {
            try {
                this.loadRemote(this.remoteSharedStore);
                this.synchronizeRemoteIndex(true);
            }
            catch (Exception e) {
                _logger.error((Object)"Error in synchronizing index", (Throwable)e);
                try {
                    files = this.remoteStoreIndex.listFiles();
                    for (int x = 0; x < files.length; ++x) {
                        deleted = files[x].delete();
                        System.out.println(files[x].getName() + " " + deleted);
                        if (deleted) continue;
                        files[x].deleteOnExit();
                    }
                    this.remoteStoreIndex.delete();
                    IndexWriter writer3 = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), true);
                    writer3.optimize();
                    writer3.close();
                    this.synchronizeRemoteIndex(true);
                }
                catch (Exception ex) {
                    _logger.error((Object)"Fatal error in creating index", (Throwable)ex);
                    this.showErrorFrame();
                    System.exit(0);
                }
            }
        } else if (this.remoteSharedStore.exists() && !IndexReader.indexExists((File)this.remoteStoreIndex)) {
            try {
                writer = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), true);
                writer.optimize();
                writer.close();
            }
            catch (IOException e) {
                _logger.error((Object)"Cannot create index", (Throwable)e);
                System.exit(0);
            }
            try {
                this.loadRemote(this.remoteSharedStore);
                this.synchronizeRemoteIndex(true);
            }
            catch (Exception e) {
                _logger.error((Object)"Error in synchronizing index", (Throwable)e);
                try {
                    files = this.remoteStoreIndex.listFiles();
                    for (int x = 0; x < files.length; ++x) {
                        deleted = files[x].delete();
                        System.out.println(files[x].getName() + " " + deleted);
                        if (deleted) continue;
                        files[x].deleteOnExit();
                    }
                    this.remoteStoreIndex.delete();
                    IndexWriter writer4 = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), true);
                    writer4.optimize();
                    writer4.close();
                    this.synchronizeRemoteIndex(true);
                }
                catch (Exception ex) {
                    _logger.error((Object)"Fatal error in creating index", (Throwable)ex);
                    this.showErrorFrame();
                    System.exit(0);
                }
            }
        } else if (!this.remoteSharedStore.exists() && !IndexReader.indexExists((File)this.storeIndex) || !this.remoteSharedStore.exists() && IndexReader.indexExists((File)this.storeIndex)) {
            try {
                writer = new IndexWriter(this.remoteStoreIndex, (Analyzer)new StandardAnalyzer(), true);
                writer.optimize();
                writer.close();
            }
            catch (IOException e) {
                _logger.error((Object)"Cannot create index", (Throwable)e);
                System.exit(0);
            }
        }
    }

    public boolean isUploadingFileList() {
        return this.isUploadingFileList > 0;
    }

    public void uploadingFileList() {
        ++this.isUploadingFileList;
    }

    public void finishedUploadingFileList() {
        --this.isUploadingFileList;
    }

    public void setLastUploadedList(String dest, ArrayList lastUploadedList) {
        if (lastUploadedList == null) {
            this.lastUploadedLists.remove(dest);
        } else {
            this.lastUploadedLists.put(dest, lastUploadedList);
        }
    }

    public ArrayList getLastUploadedList(String dest) {
        ArrayList list = (ArrayList)this.lastUploadedLists.get(dest);
        return list == null ? new ArrayList() : list;
    }

    BackgroundEngine() throws IOException, ClassNotFoundException {
        this.initializeIndexes();
        this.setPriority(1);
    }

    BackgroundEngine(File f) throws IOException, ClassNotFoundException {
        this.store = f;
        this.initializeIndexes();
        this.setPriority(1);
    }

    public void forceExternalUpdate() {
        this.propertyChangeSupport.firePropertyChange("SharedDirectoriesModification", null, this);
    }

    public void setStoreFile(File store) {
        this.store = store;
    }

    private void load(File source) throws Exception {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(source));
            int blockSize = ois.readInt();
            if (blockSize != WarriorAnt.blockSizeInDownload) {
                ois.close();
                throw new Exception("Shared files blocksize uncompatible");
            }
            Object directories = ois.readObject();
            this.sharedDirectories = (ArrayList)directories;
            for (int x = 0; x < this.sharedDirectories.size(); ++x) {
                if (this.sharedDirectories.get(x) instanceof DirInfos) continue;
                throw new Exception("Shared directories corrupted!");
            }
            this.sharedFilesIndexName = (Hashtable)ois.readObject();
            ois.close();
            this.sharedFilesIndexHash = new Hashtable();
            Enumeration fileNames = this.sharedFilesIndexName.keys();
            while (fileNames.hasMoreElements()) {
                FileInfos infos = (FileInfos)this.sharedFilesIndexName.get((String)fileNames.nextElement());
                this.sharedFilesIndexHash.put(infos.getHash(), infos);
                this.sharedFilesIndexED2KHash.put(infos.getED2KHash(), infos);
            }
        }
        catch (Exception e) {
            this.sharedDirectories = new ArrayList();
            this.sharedFilesIndexHash = new Hashtable();
            this.sharedFilesIndexED2KHash = new Hashtable();
            _logger.info((Object)"Error loading shared files infos", (Throwable)e);
            _logger.debug((Object)"TRACE", (Throwable)e);
            throw e;
        }
    }

    private void loadRemote(File source) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(File dest) {
        try {
            String string = this.localIndexMonitor;
            synchronized (string) {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dest));
                oos.writeInt(WarriorAnt.blockSizeInDownload);
                oos.writeObject(this.sharedDirectories);
                oos.writeObject(this.sharedFilesIndexName);
                oos.flush();
                oos.close();
            }
        }
        catch (Exception e) {
            _logger.info((Object)"Error storing shared files infos", (Throwable)e);
            _logger.debug((Object)"TRACE", (Throwable)e);
        }
    }

    public void storeLocal() {
        this.store(this.store);
    }

    private void storeRemote(File dest) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(dest));
            oos.writeInt(WarriorAnt.blockSizeInDownload);
            oos.writeObject(this.remoteFilesIndexHash);
            oos.writeObject(this.remoteFilesIndexED2KHash);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            _logger.info((Object)"Error storing remote shared files infos", (Throwable)e);
            _logger.debug((Object)"TRACE", (Throwable)e);
        }
    }

    public synchronized void addDirectory(File directory) {
        if (directory.isDirectory() && !this.sharedDirectories.contains(new DirInfos(directory.getAbsolutePath(), directory.lastModified()))) {
            this.sharedDirectories.add(new DirInfos(directory.getAbsolutePath(), directory.lastModified()));
            this.forceIndexing = true;
            this.propertyChangeSupport.firePropertyChange("SharedDirectoriesModification", null, this);
        }
    }

    public synchronized void removeDirectory(File directory) {
        if (this.sharedDirectories.remove(new DirInfos(directory.getAbsolutePath(), directory.lastModified()))) {
            this.forceIndexing = true;
            this.propertyChangeSupport.firePropertyChange("SharedDirectoriesModification", null, this);
        }
    }

    public void recursiveExplore(File directory, ArrayList fileList, Hashtable tempHashtable) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int y = 0; y < files.length; ++y) {
                if (files[y].isFile() && !fileList.contains(files[y].getAbsolutePath())) {
                    fileList.add(files[y].getAbsolutePath());
                    tempHashtable.remove(files[y].getAbsolutePath());
                } else if (files[y].isDirectory() && recursiveExplore) {
                    DirInfos infos = new DirInfos(files[y].getAbsolutePath(), files[y].lastModified());
                    this.nestedDirectories.put(files[y].getAbsolutePath(), infos);
                    this.recursiveExplore(files[y], fileList, tempHashtable);
                }
                try {
                    BackgroundEngine.sleep(50L);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
    }

    public boolean recursiveExploreForModifications(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int y = 0; y < files.length; ++y) {
                if (files[y].isDirectory() && recursiveExplore) {
                    DirInfos indexedDir = (DirInfos)this.nestedDirectories.get(files[y].getAbsolutePath());
                    if (indexedDir == null) {
                        return true;
                    }
                    if (indexedDir.getLastModified() != indexedDir.getFile().lastModified() || this.recursiveExploreForModifications(files[y])) {
                        return true;
                    }
                }
                try {
                    BackgroundEngine.sleep(50L);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCurrentEvent(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("httpServerQueryCompleted")) {
            BackgroundEngine backgroundEngine = this;
            synchronized (backgroundEngine) {
                QueryMessage eventQuerySource = (QueryMessage)e.getOldValue();
                ArrayList resultSet = (ArrayList)e.getNewValue();
                for (int x = 0; x < resultSet.size(); ++x) {
                    if (resultSet.get(x) == null) continue;
                    HttpServerInfo httpInfo = (HttpServerInfo)resultSet.get(x);
                    if (this.wa == null || this.wa.getIdent().equals(httpInfo.getOwnerId())) continue;
                    this.httpServers.put(httpInfo.getOwnerId(), httpInfo);
                    _logger.info((Object)("Added http server to list: " + httpInfo.getOwnerId().substring(0, 10)));
                }
            }
        }
        if (e.getPropertyName().equals("supernodeQueryCompleted")) {
            BackgroundEngine backgroundEngine = this;
            synchronized (backgroundEngine) {
                QueryMessage eventQuerySource = (QueryMessage)e.getOldValue();
                ArrayList resultSet = (ArrayList)e.getNewValue();
                for (int x = 0; x < resultSet.size(); ++x) {
                    QuerySupernodeTuple oldQft;
                    if (resultSet.get(x) == null) continue;
                    QuerySupernodeTuple qft = (QuerySupernodeTuple)resultSet.get(x);
                    if (this.wa == null) continue;
                    BackgroundEngine backgroundEngine2 = this;
                    if (backgroundEngine2.wa.isSupernode() && this.wa.getIdent().equals(qft.getOwnerID()) || (oldQft = (QuerySupernodeTuple)this.supernodeList.get(qft.getOwnerID())) != null && oldQft.getSeenOn() >= qft.getSeenOn()) continue;
                    this.supernodeList.put(qft.getOwnerID(), qft);
                    _logger.info((Object)("Added supernode to list: " + qft.getOwnerID().substring(0, 10)));
                }
            }
        }
        if (e.getPropertyName().equals("queryCompleted")) {
            BackgroundEngine backgroundEngine = this;
            synchronized (backgroundEngine) {
                QueryMessage eventQuerySource = (QueryMessage)e.getOldValue();
                if (eventQuerySource.getQuery() instanceof QueryStringItem || eventQuerySource.getQuery() instanceof QueryHashItem || eventQuerySource.getQuery() instanceof QueryFileListItem && ((QueryFileListItem)eventQuerySource.getQuery()).getAction() || eventQuerySource.getQuery() instanceof QueryRandomItem) {
                    ArrayList resultSet = (ArrayList)e.getNewValue();
                    for (int x = 0; x < resultSet.size(); ++x) {
                        if (resultSet.get(x) == null) continue;
                        QueryFileTuple qft = (QueryFileTuple)resultSet.get(x);
                        BackgroundEngine.getInstance().addRemoteFile(qft);
                    }
                    this.storeRemote(this.remoteSharedStore);
                    try {
                        this.synchronizeRemoteIndex(false);
                    }
                    catch (Exception ex) {
                        _logger.error((Object)"Error in synchronizing remote index", (Throwable)ex);
                    }
                } else if (eventQuerySource.getQuery() instanceof QueryFileListItem && !((QueryFileListItem)eventQuerySource.getQuery()).getAction()) {
                    ArrayList resultSet = (ArrayList)e.getNewValue();
                    for (int x = 0; x < resultSet.size(); ++x) {
                        if (resultSet.get(x) == null) continue;
                        QueryFileTuple qft = (QueryFileTuple)resultSet.get(x);
                        String curKey = qft.getFileHash();
                        RemoteFileInfos localCached = (RemoteFileInfos)this.remoteFilesIndexHash.get(curKey);
                        localCached.getOwners().remove(qft.getOwnerID());
                        if (localCached.hasSources(remoteIndexedDocumentsTimeout)) continue;
                        this.remoteFilesIndexHash.remove(curKey);
                        this.remoteFilesIndexED2KHash.remove(curKey);
                    }
                    this.storeRemote(this.remoteSharedStore);
                    try {
                        this.synchronizeRemoteIndex(false);
                    }
                    catch (Exception ex) {
                        _logger.error((Object)"Error in synchronizing remote index", (Throwable)ex);
                    }
                }
            }
        }
        if (e.getPropertyName().equals("routeLost")) {
            BackgroundEngine backgroundEngine = this;
            synchronized (backgroundEngine) {
                String nodeId = (String)e.getNewValue();
                if (this.supernodeList.remove(nodeId) != null) {
                    _logger.info((Object)("Removed supernode: " + nodeId.substring(0, 10)));
                }
                if (this.httpServers.remove(nodeId) != null) {
                    _logger.info((Object)("Removed http server: " + nodeId.substring(0, 10)));
                }
                Enumeration keys = this.remoteFilesIndexHash.keys();
                while (keys.hasMoreElements()) {
                    String curKey = (String)keys.nextElement();
                    RemoteFileInfos localCached = (RemoteFileInfos)this.remoteFilesIndexHash.get(curKey);
                    localCached.getOwners().remove(nodeId);
                    if (localCached.hasSources(remoteIndexedDocumentsTimeout)) continue;
                    this.remoteFilesIndexHash.remove(curKey);
                    this.remoteFilesIndexED2KHash.remove(curKey);
                }
                this.storeRemote(this.remoteSharedStore);
                try {
                    this.synchronizeRemoteIndex(false);
                }
                catch (Exception ex) {
                    _logger.error((Object)"Error in synchronizing remote index", (Throwable)ex);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        final PropertyChangeEvent event = e;
        Thread processor = new Thread(){

            public void run() {
                BackgroundEngine.this.processCurrentEvent(event);
            }
        };
        processor.setPriority(1);
        processor.start();
    }

    public void resetIndexingCycle() {
        this.resetCycle = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int counter = 0;
        this.supernodeEngine.start();
        while (!this.terminate) {
            if (this.resetCycle) {
                this.resetCycle = false;
                this.forceIndexing = true;
            }
            try {
                Object files;
                DirInfos sharedDir;
                int x;
                boolean changes = false;
                this.propertyChangeSupport.firePropertyChange("fileIndexingCompleted", null, null);
                Thread.sleep(this.forceIndexing ? 0L : (long)refreshRate);
                while (this.wa != null && this.wa.writingFileLock > 0) {
                    Thread.sleep(refreshRate);
                }
                this.propertyChangeSupport.firePropertyChange("fileIndexingInit", null, null);
                ArrayList<String> fileList = new ArrayList<String>();
                Hashtable tempHashtable = (Hashtable)this.sharedFilesIndexName.clone();
                boolean modifications = false;
                for (x = 0; x < this.sharedDirectories.size(); ++x) {
                    sharedDir = (DirInfos)this.sharedDirectories.get(x);
                    if (sharedDir.getIndexed() && sharedDir.getLastModified() == sharedDir.getFile().lastModified() && !this.recursiveExploreForModifications(sharedDir.getFile())) continue;
                    modifications = true;
                }
                if (!modifications && !this.forceIndexing) continue;
                this.nestedDirectories = new Hashtable();
                this.forceIndexing = false;
                _logger.info((Object)("Shared directory structure modification! Analyzing..." + this.sharedDirectories.size()));
                for (x = 0; x < this.sharedDirectories.size(); ++x) {
                    sharedDir = (DirInfos)this.sharedDirectories.get(x);
                    files = sharedDir.getFile().listFiles();
                    if (files != null) {
                        for (int y = 0; y < ((File[])files).length; ++y) {
                            if (files[y].isFile() && !fileList.contains(files[y].getAbsolutePath())) {
                                fileList.add(files[y].getAbsolutePath());
                                tempHashtable.remove(files[y].getAbsolutePath());
                            } else if (files[y].isDirectory() && recursiveExplore) {
                                DirInfos infos = new DirInfos(files[y].getAbsolutePath(), files[y].lastModified());
                                this.nestedDirectories.put(files[y].getAbsolutePath(), infos);
                                this.recursiveExplore(files[y], fileList, tempHashtable);
                            }
                            try {
                                BackgroundEngine.sleep(50L);
                                continue;
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                        }
                    }
                    sharedDir.setLastModified(sharedDir.getFile().lastModified());
                    sharedDir.setIndexed();
                }
                _logger.info((Object)("Total files: " + fileList.size() + "   Removing: " + tempHashtable.size()));
                Enumeration toBeRemoved = tempHashtable.keys();
                while (toBeRemoved.hasMoreElements()) {
                    changes = true;
                    String removeKey = (String)toBeRemoved.nextElement();
                    this.sharedFilesIndexHash.remove(((FileInfos)this.sharedFilesIndexName.get(removeKey)).getHash());
                    this.sharedFilesIndexED2KHash.remove(((FileInfos)this.sharedFilesIndexName.get(removeKey)).getED2KHash());
                    this.sharedFilesIndexName.remove(removeKey);
                    files = this.localIndexMonitor;
                    synchronized (files) {
                        IndexReader reader = IndexReader.open((File)this.storeIndex);
                        Term term = new Term("Path", removeKey);
                        int deleted = reader.delete(term);
                        reader.close();
                    }
                }
                _logger.info((Object)("Total shared files: " + this.sharedFilesIndexName.size() + "   Modifier: " + (this.sharedFilesIndexName.size() - fileList.size())));
                for (int y = fileList.size() - 1; !(y < 0 || this.terminate || this.resetCycle || this.wa != null && this.wa.writingFileLock > 0); --y) {
                    IndexWriter writer;
                    FileInfos infos;
                    if (!this.sharedFilesIndexName.containsKey(fileList.get(y))) {
                        changes = true;
                        infos = new FileInfos(new File((String)fileList.get(y)));
                        this.sharedFilesIndexName.put(fileList.get(y), infos);
                        this.sharedFilesIndexHash.put(infos.getHash(), infos);
                        this.sharedFilesIndexED2KHash.put(infos.getED2KHash(), infos);
                        String reader = this.localIndexMonitor;
                        synchronized (reader) {
                            writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), false);
                            IndexerGraphicEngine ige = new IndexerGraphicEngine(new File((String)fileList.get(y)));
                            ige.start();
                            writer.addDocument(FileDocument.Document(infos));
                            writer.close();
                            ige.terminate();
                        }
                        this.store(this.store);
                        this.propertyChangeSupport.firePropertyChange("fileIndexed", new Integer(fileList.size()), new Integer(y));
                        continue;
                    }
                    if (((FileInfos)this.sharedFilesIndexName.get(fileList.get(y))).getLastModified() == new File((String)fileList.get(y)).lastModified()) continue;
                    changes = true;
                    infos = new FileInfos(new File((String)fileList.get(y)));
                    this.sharedFilesIndexName.put(fileList.get(y), infos);
                    this.sharedFilesIndexHash.put(infos.getHash(), infos);
                    this.sharedFilesIndexED2KHash.put(infos.getED2KHash(), infos);
                    String reader = this.localIndexMonitor;
                    synchronized (reader) {
                        writer = new IndexWriter(this.storeIndex, (Analyzer)new StandardAnalyzer(), false);
                        writer.addDocument(FileDocument.Document(infos));
                        writer.close();
                    }
                    this.store(this.store);
                    this.propertyChangeSupport.firePropertyChange("fileIndexed", new Integer(fileList.size()), new Integer(y));
                }
                if (changes) {
                    this.forceUploadingLists = true;
                    this.store(this.store);
                    if (Logger.getRootLogger().getEffectiveLevel().toInt() <= 10000) {
                        Enumeration visualizeKeys = this.sharedFilesIndexName.keys();
                        Enumeration visualizeValues = this.sharedFilesIndexName.elements();
                        while (visualizeKeys.hasMoreElements()) {
                            _logger.debug((Object)(visualizeKeys.nextElement() + "....."));
                            FileInfos fi = (FileInfos)visualizeValues.nextElement();
                            _logger.debug((Object)(fi.getHash() + "....." + fi.getLastModified() + "\n"));
                        }
                    }
                    this.propertyChangeSupport.firePropertyChange("SharedDirectoriesModification", null, this);
                }
                this.totalLocalSharedFileSize = 0L;
                Enumeration localFiles = this.sharedFilesIndexHash.elements();
                while (localFiles.hasMoreElements()) {
                    this.totalLocalSharedFileSize += ((FileInfos)localFiles.nextElement()).getSize();
                }
                this.totalRemoteSharedFileSize = 0L;
                Enumeration remoteFiles = this.remoteFilesIndexHash.elements();
                while (remoteFiles.hasMoreElements()) {
                    this.totalRemoteSharedFileSize += ((RemoteFileInfos)remoteFiles.nextElement()).getSize();
                }
                if (this.getTimesToRemoteCrawling() > 0) {
                    if (this.wa != null && counter == 0) {
                        this.currentQuery = this.wa.doRandomQuery(broadcastTimeToLive);
                    }
                    counter = (counter + 1) % this.getTimesToRemoteCrawling();
                }
                System.gc();
            }
            catch (Exception e) {
                _logger.error((Object)"Background Indexer Error", (Throwable)e);
                this.propertyChangeSupport.firePropertyChange("fileIndexingCompleted", null, null);
            }
        }
        BackgroundEngine backgroundEngine = this;
        synchronized (backgroundEngine) {
            while (this.synchronizingRemote) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.loggingOut = true;
        }
    }

    public int getTimesToRemoteCrawling() {
        return -1;
    }

    public void setWarriorAnt(WarriorAnt wa) {
        this.wa = wa;
    }

    public ArrayList getCompleteFileList() {
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            Enumeration completeEnum = this.sharedFilesIndexName.keys();
            while (completeEnum.hasMoreElements()) {
                results.add(completeEnum.nextElement());
            }
            Enumeration partialEnum = this.partialFiles.keys();
            while (partialEnum.hasMoreElements()) {
                results.add(new StringHash((String)partialEnum.nextElement()));
            }
            return results;
        }
        catch (Exception ex) {
            _logger.error((Object)"Invalid query string", (Throwable)ex);
            return new ArrayList();
        }
    }

    public ArrayList search(String item, boolean content) {
        try {
            String path;
            Document doc;
            int i;
            ArrayList<Object> results = new ArrayList<Object>();
            IndexReader reader = IndexReader.open((File)this.storeIndex);
            IndexSearcher searcher = new IndexSearcher(reader);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            Query query = QueryParser.parse((String)item, (String)"TextPath", (Analyzer)analyzer);
            Hits hits = searcher.search(query);
            for (i = 0; i < hits.length() && i < QueryManager.resultSize; ++i) {
                doc = hits.doc(i);
                path = doc.get("Path");
                if (results.contains(path)) continue;
                results.add(path);
            }
            if (content) {
                query = QueryParser.parse((String)item, (String)"Contents", (Analyzer)analyzer);
                hits = searcher.search(query);
                for (i = 0; i < hits.length() && i < QueryManager.resultSize; ++i) {
                    doc = hits.doc(i);
                    path = doc.get("Path");
                    if (results.contains(path)) continue;
                    results.add(path);
                }
                query = QueryParser.parse((String)item, (String)"ExtendedInfosContent", (Analyzer)analyzer);
                hits = searcher.search(query);
                for (i = 0; i < hits.length() && i < QueryManager.resultSize; ++i) {
                    doc = hits.doc(i);
                    path = doc.get("Path");
                    if (results.contains(path)) continue;
                    results.add(path);
                }
            }
            query = QueryParser.parse((String)item, (String)"PartialFileName", (Analyzer)analyzer);
            hits = searcher.search(query);
            for (i = 0; i < hits.length() && i < QueryManager.resultSize; ++i) {
                doc = hits.doc(i);
                StringHash hash = new StringHash(doc.get("PartialFileHash"));
                if (results.contains(hash)) continue;
                results.add(hash);
            }
            reader.close();
            return results;
        }
        catch (Exception ex) {
            _logger.error((Object)"Invalid query string", (Throwable)ex);
            return new ArrayList();
        }
    }

    public ArrayList searchRemoteFiles(String item, boolean localSearch) {
        try {
            ArrayList<String> results = new ArrayList<String>();
            IndexReader reader = IndexReader.open((File)this.remoteStoreIndex);
            IndexSearcher searcher = new IndexSearcher(reader);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            Query query = QueryParser.parse((String)item, (String)"RemoteFileContent", (Analyzer)analyzer);
            Hits hits = searcher.search(query);
            for (int i = 0; i < hits.length() && (localSearch || i < QueryManager.resultSize); ++i) {
                Document doc = hits.doc(i);
                String hash = doc.get("RemoteFileHash");
                if (results.contains(hash)) continue;
                results.add(hash);
            }
            reader.close();
            return results;
        }
        catch (Exception ex) {
            _logger.error((Object)"Invalid query string", (Throwable)ex);
            return new ArrayList();
        }
    }

    static {
        refreshRate = 5000;
        maxRemoteDocsToTrace = 10000;
        broadcastTimeToLive = 2000;
        remoteIndexedDocumentsTimeout = 3600000;
        shareDownloadPath = true;
        _logger = Logger.getLogger((String)BackgroundEngine.class.getName());
        recursiveExplore = true;
    }
}

